/*
 * Decompiled with CFR 0.152.
 */
package com.clickadv.config;

import com.clickadv.ClickAdvancements;
import com.clickadv.config.CommonConfiguration;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class Configuration {
    private final CommonConfiguration commonConfig = new CommonConfiguration();

    public void load() {
        Path configPath = FabricLoader.getInstance().getConfigDir().normalize().resolve("clickadv.json");
        File config = configPath.toFile();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!config.exists()) {
            ClickAdvancements.LOGGER.warn("Config for dynamic view not found, recreating default");
            try {
                BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);
                gson.toJson((Object)this.commonConfig.serialize(), JsonObject.class, (Appendable)writer);
                writer.close();
            }
            catch (IOException e) {
                ClickAdvancements.LOGGER.error("Could not write config to:" + configPath, (Throwable)e);
            }
        } else {
            try {
                this.commonConfig.deserialize((JsonObject)gson.fromJson((Reader)Files.newBufferedReader(configPath), JsonObject.class));
            }
            catch (IOException e) {
                ClickAdvancements.LOGGER.error("Could not read config from:" + configPath, (Throwable)e);
            }
        }
    }

    public CommonConfiguration getCommonConfig() {
        return this.commonConfig;
    }
}

