/*
 * Decompiled with CFR 0.152.
 */
package net.grupa_tkd.better_minecraft.block.custom;

import javax.annotation.Nullable;
import net.grupa_tkd.better_minecraft.block.ModBlockStateProperties;
import net.grupa_tkd.better_minecraft.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GenericItemBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final IntegerProperty ITEM = ModBlockStateProperties.ITEM;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public GenericItemBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ITEM, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ITEM, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        if (!blockState.m_60710_((LevelReader)levelAccessor, blockPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Level level = blockPlaceContext.m_43725_();
        BlockPos blockPos = blockPlaceContext.m_8083_();
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(blockPos).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState blockState) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(blockState);
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return !levelReader.m_46859_(blockPos.m_7495_());
    }

    @Nullable
    public static BlockState wrap(BlockState blockState) {
        return GenericItemBlock.genericBlockFromItem(blockState.m_60734_().m_5456_());
    }

    @Nullable
    public static BlockState unwrap(BlockState blockState) {
        Item item = GenericItemBlock.itemFromGenericBlock(blockState);
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.m_40614_().m_49966_();
        }
        return null;
    }

    @Nullable
    public static BlockState genericBlockFromItem(Item item) {
        if (item == Items.f_41852_) {
            return null;
        }
        int n = Registry.f_122827_.m_7447_((Object)item);
        if (n != -1) {
            return (BlockState)((Block)ModBlocks.GENERIC_ITEM_BLOCK.get()).m_49966_().m_61124_((Property)ITEM, (Comparable)Integer.valueOf(n));
        }
        return null;
    }

    @Nullable
    public static Item itemFromGenericBlock(BlockState blockState) {
        if (blockState.m_61138_((Property)ITEM)) {
            Item item = (Item)Registry.f_122827_.m_7942_(((Integer)blockState.m_61143_((Property)ITEM)).intValue());
            return item != Items.f_41852_ ? item : null;
        }
        return null;
    }

    public static final class GenericBlockItem
    extends BlockItem {
        public GenericBlockItem(Block block, Item.Properties properties) {
            super(block, properties);
        }

        public Component m_7626_(ItemStack itemStack) {
            return Component.m_237113_((String)"How did we get here?");
        }
    }
}

