/*
 * Decompiled with CFR 0.152.
 */
package net.grupa_tkd.better_minecraft.block.custom;

import com.google.common.cache.LoadingCache;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.grupa_tkd.better_minecraft.block.DimHash;
import net.grupa_tkd.better_minecraft.block.ModBlocks;
import net.grupa_tkd.better_minecraft.block.entity.NeitherPortalEntity;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    protected static final VoxelShape X_AXIS_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public PortalBlock(BlockBehaviour.Properties c2) {
        super(c2);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
    }

    public VoxelShape m_5940_(BlockState cdt2, BlockGetter bnh2, BlockPos fo2, CollisionContext ddu2) {
        switch ((Direction.Axis)cdt2.m_61143_(AXIS)) {
            case Z: {
                return Z_AXIS_AABB;
            }
        }
        return X_AXIS_AABB;
    }

    public static boolean trySpawnPortal(LevelAccessor bny2, BlockPos fo2, Block btu2) {
        PortalShape a4 = PortalBlock.isPortal(bny2, fo2, btu2);
        if (a4 != null) {
            a4.createPortalBlocks();
            return true;
        }
        return false;
    }

    @Nullable
    public static PortalShape isPortal(LevelAccessor bny2, BlockPos fo2, Block btu2) {
        PortalShape a4 = new PortalShape(bny2, fo2, Direction.Axis.X, btu2);
        if (a4.isValid() && a4.numPortalBlocks == 0) {
            return a4;
        }
        PortalShape a5 = new PortalShape(bny2, fo2, Direction.Axis.Z, btu2);
        if (a5.isValid() && a5.numPortalBlocks == 0) {
            return a5;
        }
        return null;
    }

    public BlockState m_7417_(BlockState cdt1, Direction ft2, BlockState cdt3, LevelAccessor bny2, BlockPos fo5, BlockPos fo6) {
        Direction.Axis a8 = ft2.m_122434_();
        Direction.Axis a9 = (Direction.Axis)cdt1.m_61143_(AXIS);
        boolean boolean10 = a9 != a8 && a8.m_122479_();
        boolean bl = boolean10;
        if (boolean10 || cdt3.m_60734_() == this || new PortalShape(bny2, fo5, a9, this).isComplete()) {
            return super.m_7417_(cdt1, ft2, cdt3, bny2, fo5, fo6);
        }
        return Blocks.f_50016_.m_49966_();
    }

    public void m_7892_(BlockState cdt2, Level bnx2, BlockPos fo2, Entity anb2) {
        ItemStack bin6;
        if (anb2 instanceof ItemEntity && ((bin6 = ((ItemEntity)anb2).m_32055_()).m_41720_() == Items.f_42615_ || bin6.m_41720_() == Items.f_42614_)) {
            BookViewScreen.BookAccess aco7 = BookViewScreen.BookAccess.m_98308_((ItemStack)bin6);
            String string8 = "aXDDD";
            if (!string8.isEmpty()) {
                int integer9 = DimHash.getHash(string8);
                this.floodFillReplace(bnx2, fo2, cdt2, integer9);
                anb2.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return;
        }
        if (!anb2.m_20159_() && !anb2.m_20160_() && anb2.m_6072_()) {
            anb2.m_20221_(fo2);
        }
    }

    private void floodFillReplace(Level bnx2, BlockPos fo2, BlockState cdt2, int integer) {
        BlockPos fo14;
        Direction ft10;
        HashSet set6 = Sets.newHashSet();
        ArrayDeque queue7 = Queues.newArrayDeque();
        Direction.Axis a8 = (Direction.Axis)cdt2.m_61143_(AXIS);
        BlockState cdt9 = (BlockState)((Block)ModBlocks.NEITHER_PORTAL.get()).m_49966_().m_61124_(AXIS, (Comparable)a8);
        Direction ft11 = switch (a8) {
            case Direction.Axis.X -> {
                ft10 = Direction.UP;
                yield Direction.EAST;
            }
            case Direction.Axis.Y -> {
                ft10 = Direction.SOUTH;
                yield Direction.EAST;
            }
            default -> {
                ft10 = Direction.UP;
                yield Direction.SOUTH;
            }
        };
        Direction ft12 = ft10.m_122424_();
        Direction ft13 = ft11.m_122424_();
        queue7.add(fo2);
        while ((fo14 = (BlockPos)queue7.poll()) != null) {
            BlockPos fo17;
            set6.add(fo14);
            BlockState cdt15 = bnx2.m_8055_(fo14);
            if (cdt15 != cdt2) continue;
            bnx2.m_7731_(fo14, cdt9, 18);
            BlockEntity cbt16 = bnx2.m_7702_(fo14);
            if (cbt16 instanceof NeitherPortalEntity) {
                ((NeitherPortalEntity)cbt16).setDimension(integer);
            }
            if (!set6.contains(fo17 = fo14.m_121945_(ft10))) {
                queue7.add(fo17);
            }
            if (!set6.contains(fo17 = fo14.m_121945_(ft12))) {
                queue7.add(fo17);
            }
            if (!set6.contains(fo17 = fo14.m_121945_(ft11))) {
                queue7.add(fo17);
            }
            if (set6.contains(fo17 = fo14.m_121945_(ft13))) continue;
            queue7.add(fo17);
        }
    }

    public void m_214162_(BlockState cdt2, Level bnx2, BlockPos fo2, RandomSource random) {
        if (random.m_188503_(100) == 0) {
            bnx2.m_7785_((double)fo2.m_123341_() + 0.5, (double)fo2.m_123342_() + 0.5, (double)fo2.m_123343_() + 0.5, SoundEvents.f_12286_, SoundSource.BLOCKS, 0.5f, random.m_188501_() * 0.4f + 0.8f, false);
        }
        for (int integer6 = 0; integer6 < 4; ++integer6) {
            double double7 = (double)fo2.m_123341_() + (double)random.m_188501_();
            double double9 = (double)fo2.m_123342_() + (double)random.m_188501_();
            double double11 = (double)fo2.m_123343_() + (double)random.m_188501_();
            double double13 = ((double)random.m_188501_() - 0.5) * 0.5;
            double double15 = ((double)random.m_188501_() - 0.5) * 0.5;
            double double17 = ((double)random.m_188501_() - 0.5) * 0.5;
            int integer19 = random.m_188503_(2) * 2 - 1;
            if (bnx2.m_8055_(fo2.m_122024_()).m_60734_() == this || bnx2.m_8055_(fo2.m_122029_()).m_60734_() == this) {
                double11 = (double)fo2.m_123343_() + 0.5 + 0.25 * (double)integer19;
                double17 = random.m_188501_() * 2.0f * (float)integer19;
            } else {
                double7 = (double)fo2.m_123341_() + 0.5 + 0.25 * (double)integer19;
                double13 = random.m_188501_() * 2.0f * (float)integer19;
            }
            bnx2.m_7106_(this.getParticleType(cdt2, bnx2, fo2), double7, double9, double11, double13, double15, double17);
        }
    }

    protected ParticleOptions getParticleType(BlockState cdt2, Level bnx2, BlockPos fo2) {
        return ParticleTypes.f_123760_;
    }

    public ItemStack m_7397_(BlockGetter bnh2, BlockPos fo2, BlockState cdt2) {
        return ItemStack.f_41583_;
    }

    public BlockState m_6843_(BlockState cdt2, Rotation byv2) {
        switch (byv2) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)cdt2.m_61143_(AXIS)) {
                    case X: {
                        return (BlockState)cdt2.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)cdt2.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return cdt2;
            }
        }
        return cdt2;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> a2) {
        a2.m_61104_(new Property[]{AXIS});
    }

    public static BlockPattern.BlockPatternMatch getPortalShape(LevelAccessor bny2, BlockPos fo2, Block btu2) {
        Direction.Axis a4 = Direction.Axis.Z;
        PortalShape a5 = new PortalShape(bny2, fo2, Direction.Axis.X, btu2);
        LoadingCache loadingCache6 = BlockPattern.m_61187_((LevelReader)bny2, (boolean)true);
        if (!a5.isValid()) {
            a4 = Direction.Axis.X;
            a5 = new PortalShape(bny2, fo2, Direction.Axis.Z, btu2);
        }
        if (!a5.isValid()) {
            return new BlockPattern.BlockPatternMatch(fo2, Direction.NORTH, Direction.UP, loadingCache6, 1, 1, 1);
        }
        int[] arr7 = new int[Direction.AxisDirection.values().length];
        Direction ft8 = a5.rightDir.m_122428_();
        BlockPos fo9 = a5.bottomLeft.m_6630_(a5.getHeight() - 1);
        for (Direction.AxisDirection b13 : Direction.AxisDirection.values()) {
            BlockPattern.BlockPatternMatch b14 = new BlockPattern.BlockPatternMatch(ft8.m_122421_() == b13 ? fo9 : fo9.m_5484_(a5.rightDir, a5.getWidth() - 1), Direction.m_122390_((Direction.AxisDirection)b13, (Direction.Axis)a4), Direction.UP, loadingCache6, a5.getWidth(), a5.getHeight(), 1);
            for (int integer15 = 0; integer15 < a5.getWidth(); ++integer15) {
                for (int integer16 = 0; integer16 < a5.getHeight(); ++integer16) {
                    BlockInWorld cdx17 = b14.m_61229_(integer15, integer16, 1);
                    if (cdx17.m_61168_().m_60795_()) continue;
                    int n = b13.ordinal();
                    arr7[n] = arr7[n] + 1;
                }
            }
        }
        Direction.AxisDirection b10 = Direction.AxisDirection.POSITIVE;
        for (Direction.AxisDirection axisDirection : Direction.AxisDirection.values()) {
        }
        return new BlockPattern.BlockPatternMatch(ft8.m_122421_() == b10 ? fo9 : fo9.m_5484_(a5.rightDir, a5.getWidth() - 1), Direction.m_122390_((Direction.AxisDirection)b10, (Direction.Axis)a4), Direction.UP, loadingCache6, a5.getWidth(), a5.getHeight(), 1);
    }

    public static class PortalShape {
        private final LevelAccessor level;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private final Direction leftDir;
        private int numPortalBlocks;
        @Nullable
        private BlockPos bottomLeft;
        private int height;
        private int width;
        private final Block portalBlock;

        public PortalShape(LevelAccessor bny2, BlockPos fo2, Direction.Axis a2, Block btu2) {
            this.level = bny2;
            this.axis = a2;
            this.portalBlock = btu2;
            if (a2 == Direction.Axis.X) {
                this.leftDir = Direction.EAST;
                this.rightDir = Direction.WEST;
            } else {
                this.leftDir = Direction.NORTH;
                this.rightDir = Direction.SOUTH;
            }
            BlockPos fo6 = fo2;
            while (fo2.m_123342_() > fo6.m_123342_() - 21 && fo2.m_123342_() > 0 && this.isEmpty(bny2.m_8055_(fo2.m_7495_()))) {
                fo2 = fo2.m_7495_();
            }
            int integer7 = this.getDistanceUntilEdge(fo2, this.leftDir) - 1;
            if (integer7 >= 0) {
                this.bottomLeft = fo2.m_5484_(this.leftDir, integer7);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos fo2, Direction ft2) {
            BlockPos fo5;
            int integer4;
            for (integer4 = 0; integer4 < 22 && this.isEmpty(this.level.m_8055_(fo5 = fo2.m_5484_(ft2, integer4))) && this.level.m_8055_(fo5.m_7495_()).m_60734_() == Blocks.f_50080_; ++integer4) {
            }
            Block btu5 = this.level.m_8055_(fo2.m_5484_(ft2, integer4)).m_60734_();
            if (btu5 == Blocks.f_50080_) {
                return integer4;
            }
            return 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            int integer2;
            this.height = 0;
            block0: while (this.height < 21) {
                for (integer2 = 0; integer2 < this.width; ++integer2) {
                    BlockPos fo3 = this.bottomLeft.m_5484_(this.rightDir, integer2).m_6630_(this.height);
                    BlockState cdt4 = this.level.m_8055_(fo3);
                    if (!this.isEmpty(cdt4)) break block0;
                    Block btu5 = cdt4.m_60734_();
                    if (btu5 == this.portalBlock) {
                        ++this.numPortalBlocks;
                    }
                    if (integer2 == 0 ? (btu5 = this.level.m_8055_(fo3.m_121945_(this.leftDir)).m_60734_()) != Blocks.f_50080_ : integer2 == this.width - 1 && (btu5 = this.level.m_8055_(fo3.m_121945_(this.rightDir)).m_60734_()) != Blocks.f_50080_) break block0;
                }
                ++this.height;
            }
            for (integer2 = 0; integer2 < this.width; ++integer2) {
                if (this.level.m_8055_(this.bottomLeft.m_5484_(this.rightDir, integer2).m_6630_(this.height)).m_60734_() == Blocks.f_50080_) continue;
                this.height = 0;
                break;
            }
            if (this.height > 21 || this.height < 3) {
                this.bottomLeft = null;
                this.width = 0;
                this.height = 0;
                return 0;
            }
            return this.height;
        }

        protected boolean isEmpty(BlockState cdt2) {
            Block btu3 = cdt2.m_60734_();
            return cdt2.m_60795_() || cdt2.m_204336_(BlockTags.f_13076_) || btu3 == this.portalBlock;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void createPortalBlocks() {
            for (int integer2 = 0; integer2 < this.width; ++integer2) {
                BlockPos fo3 = this.bottomLeft.m_5484_(this.rightDir, integer2);
                for (int integer4 = 0; integer4 < this.height; ++integer4) {
                    this.level.m_7731_(fo3.m_6630_(integer4), (BlockState)((Block)ModBlocks.NEITHER_PORTAL.get()).m_49966_().m_61124_(AXIS, (Comparable)this.axis), 18);
                }
            }
        }

        private boolean hasAllPortalBlocks() {
            return this.numPortalBlocks >= this.width * this.height;
        }

        public boolean isComplete() {
            return this.isValid() && this.hasAllPortalBlocks();
        }
    }
}

