/*
 * Decompiled with CFR 0.152.
 */
package net.grupa_tkd.better_minecraft.block.custom;

import net.grupa_tkd.better_minecraft.block.ModBlocks;
import net.grupa_tkd.better_minecraft.block.StalkBehaviour;
import net.grupa_tkd.better_minecraft.block.StalkSpreader;
import net.grupa_tkd.better_minecraft.block.custom.StalkShriekerBlock;
import net.grupa_tkd.better_minecraft.fluid.ModFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;

public class StalkBlock
extends Block
implements StalkBehaviour {
    public StalkBlock(BlockBehaviour.Properties p_52225_) {
        super(p_52225_);
    }

    @Override
    public int attemptUseCharge(StalkSpreader.ChargeCursor p_222073_, LevelAccessor p_222074_, BlockPos p_222075_, RandomSource p_222076_, StalkSpreader p_222077_, boolean p_222078_) {
        int i = p_222073_.getCharge();
        if (i != 0 && p_222076_.m_188503_(p_222077_.chargeDecayRate()) == 0) {
            BlockPos blockpos = p_222073_.getPos();
            boolean flag = blockpos.m_123314_((Vec3i)p_222075_, (double)p_222077_.noGrowthRadius());
            if (!flag && StalkBlock.canPlaceGrowth(p_222074_, blockpos)) {
                int j = p_222077_.growthSpawnCost();
                if (p_222076_.m_188503_(j) < i) {
                    BlockPos blockpos1 = blockpos.m_7494_();
                    BlockState blockstate = this.getRandomGrowthState(p_222074_, blockpos1, p_222076_, p_222077_.isWorldGeneration());
                    p_222074_.m_7731_(blockpos1, blockstate, 3);
                    p_222074_.m_5594_((Player)null, blockpos, blockstate.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return Math.max(0, i - j);
            }
            return p_222076_.m_188503_(p_222077_.additionalDecayRate()) != 0 ? i : i - (flag ? 1 : StalkBlock.getDecayPenalty(p_222077_, blockpos, p_222075_, i));
        }
        return i;
    }

    private static int getDecayPenalty(StalkSpreader p_222080_, BlockPos p_222081_, BlockPos p_222082_, int p_222083_) {
        int i = p_222080_.noGrowthRadius();
        float f = Mth.m_14207_((float)((float)Math.sqrt(p_222081_.m_123331_((Vec3i)p_222082_)) - (float)i));
        int j = Mth.m_144944_((int)(24 - i));
        float f1 = Math.min(1.0f, f / (float)j);
        return Math.max(1, (int)((float)p_222083_ * f1 * 0.5f));
    }

    private BlockState getRandomGrowthState(LevelAccessor p_222068_, BlockPos p_222069_, RandomSource p_222070_, boolean p_222071_) {
        BlockState blockstate = p_222070_.m_188503_(11) == 0 ? (BlockState)((Block)ModBlocks.STALK_SHRIEKER.get()).m_49966_().m_61124_((Property)StalkShriekerBlock.CAN_SUMMON, (Comparable)Boolean.valueOf(p_222071_)) : ((Block)ModBlocks.STALK_SENSOR.get()).m_49966_();
        return blockstate.m_61138_((Property)BlockStateProperties.f_61362_) && !p_222068_.m_6425_(p_222069_).m_76178_() ? (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)) : blockstate;
    }

    private static boolean canPlaceGrowth(LevelAccessor p_222065_, BlockPos p_222066_) {
        BlockState blockstate = p_222065_.m_8055_(p_222066_.m_7494_());
        if (blockstate.m_60795_() || blockstate.m_60713_((Block)ModBlocks.DARK_WATER.get()) && blockstate.m_60819_().m_192917_((Fluid)ModFluids.DARK_WATER.get())) {
            int i = 0;
            for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)p_222066_.m_7918_(-4, 0, -4), (BlockPos)p_222066_.m_7918_(4, 2, 4))) {
                BlockState blockstate1 = p_222065_.m_8055_(blockpos);
                if (blockstate1.m_60713_((Block)ModBlocks.STALK_SENSOR.get()) || blockstate1.m_60713_((Block)ModBlocks.STALK_SHRIEKER.get())) {
                    ++i;
                }
                if (i <= 2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canChangeBlockStateOnSpread() {
        return false;
    }
}

