/*
 * Decompiled with CFR 0.152.
 */
package net.grupa_tkd.better_minecraft.block.entity;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.function.Predicate;
import net.grupa_tkd.better_minecraft.ModTags;
import net.grupa_tkd.better_minecraft.block.ModBlockStateProperties;
import net.grupa_tkd.better_minecraft.block.custom.ChiseledBookShelfBlock;
import net.grupa_tkd.better_minecraft.block.entity.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;

public class ChiseledBookShelfBlockEntity
extends BlockEntity
implements Container {
    public static final int MAX_BOOKS_IN_STORAGE = 6;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);

    public ChiseledBookShelfBlockEntity(BlockPos $$0, BlockState $$1) {
        super((BlockEntityType)ModTileEntities.CHISELED_BOOKSHELF.get(), $$0, $$1);
    }

    private void updateState(int $$0) {
        if ($$0 < 0 || $$0 >= 6) {
            LOGGER.error("Expected slot 0-5, got {}", (Object)$$0);
            return;
        }
        BlockState $$1 = (BlockState)this.m_58900_().m_61124_((Property)ModBlockStateProperties.CHISELED_BOOKSHELF_LAST_INTERACTION_BOOK_SLOT, (Comparable)Integer.valueOf($$0 + 1));
        for (int $$2 = 0; $$2 < ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.size(); ++$$2) {
            boolean $$3 = !this.m_8020_($$2).m_41619_();
            BooleanProperty $$4 = ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.get($$2);
            $$1 = (BlockState)$$1.m_61124_((Property)$$4, (Comparable)Boolean.valueOf($$3));
        }
        Objects.requireNonNull(this.f_58857_).m_7731_(this.f_58858_, $$1, 3);
    }

    public void m_142466_(CompoundTag $$0) {
        ContainerHelper.m_18980_((CompoundTag)$$0, this.items);
    }

    protected void m_183515_(CompoundTag $$0) {
        ContainerHelper.m_18976_((CompoundTag)$$0, this.items, (boolean)true);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag $$0 = new CompoundTag();
        ContainerHelper.m_18976_((CompoundTag)$$0, this.items, (boolean)true);
        return $$0;
    }

    public int count() {
        return (int)this.items.stream().filter(Predicate.not(ItemStack::m_41619_)).count();
    }

    public void m_6211_() {
        this.items.clear();
    }

    public int m_6643_() {
        return 6;
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int $$0) {
        return (ItemStack)this.items.get($$0);
    }

    public ItemStack m_7407_(int $$0, int $$1) {
        ItemStack $$2 = Objects.requireNonNullElse(this.items.get($$0), ItemStack.f_41583_);
        this.items.set($$0, (Object)ItemStack.f_41583_);
        if (!$$2.m_41619_()) {
            this.updateState($$0);
        }
        return $$2;
    }

    public ItemStack m_8016_(int $$0) {
        return this.m_7407_($$0, 1);
    }

    public void m_6836_(int $$0, ItemStack $$1) {
        if ($$1.m_204117_(ModTags.BOOKSHELF_BOOKS)) {
            this.items.set($$0, (Object)$$1);
            this.updateState($$0);
        }
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_6542_(Player $$0) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !($$0.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public boolean m_7013_(int $$0, ItemStack $$1) {
        return $$1.m_204117_(ModTags.BOOKSHELF_BOOKS) && this.m_8020_($$0).m_41619_();
    }
}

