/*
 * Decompiled with CFR 0.152.
 */
package net.grupa_tkd.better_minecraft.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import javax.annotation.Nullable;
import net.grupa_tkd.better_minecraft.block.custom.StalkSensorBlock;
import net.grupa_tkd.better_minecraft.block.entity.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationListener;
import org.slf4j.Logger;

public class StalkSensorBlockEntity
extends BlockEntity
implements VibrationListener.VibrationListenerConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    private VibrationListener listener;
    private int lastVibrationFrequency;

    public StalkSensorBlockEntity(BlockPos p_155635_, BlockState p_155636_) {
        super((BlockEntityType)ModTileEntities.STALK_SENSOR.get(), p_155635_, p_155636_);
        this.listener = new VibrationListener((PositionSource)new BlockPositionSource(this.f_58858_), ((StalkSensorBlock)p_155636_.m_60734_()).getListenerRange(), (VibrationListener.VibrationListenerConfig)this, (VibrationListener.ReceivingEvent)null, 0.0f, 0);
    }

    public void m_142466_(CompoundTag p_155649_) {
        super.m_142466_(p_155649_);
        this.lastVibrationFrequency = p_155649_.m_128451_("last_vibration_frequency");
        if (p_155649_.m_128425_("listener", 10)) {
            VibrationListener.m_223781_((VibrationListener.VibrationListenerConfig)this).parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_155649_.m_128469_("listener"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_222817_ -> {
                this.listener = p_222817_;
            });
        }
    }

    protected void m_183515_(CompoundTag p_187511_) {
        super.m_183515_(p_187511_);
        p_187511_.m_128405_("last_vibration_frequency", this.lastVibrationFrequency);
        VibrationListener.m_223781_((VibrationListener.VibrationListenerConfig)this).encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.listener).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_222820_ -> p_187511_.m_128365_("listener", p_222820_));
    }

    public VibrationListener getListener() {
        return this.listener;
    }

    public int getLastVibrationFrequency() {
        return this.lastVibrationFrequency;
    }

    public boolean m_213734_() {
        return true;
    }

    public boolean m_213641_(ServerLevel p_222811_, GameEventListener p_222812_, BlockPos p_222813_, GameEvent p_222814_, @Nullable GameEvent.Context p_222815_) {
        return !this.m_58901_() && (!p_222813_.equals((Object)this.m_58899_()) || p_222814_ != GameEvent.f_157794_ && p_222814_ != GameEvent.f_157797_) ? StalkSensorBlock.canActivate(this.m_58900_()) : false;
    }

    public void m_213991_(ServerLevel p_222803_, GameEventListener p_222804_, BlockPos p_222805_, GameEvent p_222806_, @Nullable Entity p_222807_, @Nullable Entity p_222808_, float p_222809_) {
        BlockState blockstate = this.m_58900_();
        if (StalkSensorBlock.canActivate(blockstate)) {
            this.lastVibrationFrequency = StalkSensorBlock.VIBRATION_FREQUENCY_FOR_EVENT.getInt((Object)p_222806_);
            StalkSensorBlock.activate(p_222807_, (Level)p_222803_, this.f_58858_, blockstate, StalkSensorBlockEntity.getRedstoneStrengthForDistance(p_222809_, p_222804_.m_142078_()));
        }
    }

    public void m_214037_() {
        this.m_6596_();
    }

    public static int getRedstoneStrengthForDistance(float p_222798_, int p_222799_) {
        double d0 = (double)p_222798_ / (double)p_222799_;
        return Math.max(1, 15 - Mth.m_14107_((double)(d0 * 15.0)));
    }

    public void setLastVibrationFrequency(int p_222801_) {
        this.lastVibrationFrequency = p_222801_;
    }
}

