/*
 * Decompiled with CFR 0.152.
 */
package net.grupa_tkd.better_minecraft.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.grupa_tkd.better_minecraft.block.custom.StalkShriekerBlock;
import net.grupa_tkd.better_minecraft.block.entity.ModTileEntities;
import net.grupa_tkd.better_minecraft.entity.ModEntities;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationListener;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class StalkShriekerBlockEntity
extends BlockEntity
implements VibrationListener.VibrationListenerConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int LISTENER_RADIUS = 8;
    private static final int WARNING_SOUND_RADIUS = 10;
    private static final int WARDEN_SPAWN_ATTEMPTS = 20;
    private static final int WARDEN_SPAWN_RANGE_XZ = 5;
    private static final int WARDEN_SPAWN_RANGE_Y = 6;
    private static final int DARKNESS_RADIUS = 40;
    private static final Int2ObjectMap<SoundEvent> SOUND_BY_LEVEL = (Int2ObjectMap)Util.m_137469_((Object)new Int2ObjectOpenHashMap(), p_222866_ -> {
        p_222866_.put(1, (Object)SoundEvents.f_215766_);
        p_222866_.put(2, (Object)SoundEvents.f_215767_);
        p_222866_.put(3, (Object)SoundEvents.f_215768_);
        p_222866_.put(4, (Object)SoundEvents.f_215765_);
    });
    private static final int SHRIEKING_TICKS = 90;
    private int warningLevel;
    private VibrationListener listener;

    public StalkShriekerBlockEntity(BlockPos p_222835_, BlockState p_222836_) {
        super((BlockEntityType)ModTileEntities.STALK_SHRIEKER.get(), p_222835_, p_222836_);
        this.listener = new VibrationListener((PositionSource)new BlockPositionSource(this.f_58858_), 8, (VibrationListener.VibrationListenerConfig)this, (VibrationListener.ReceivingEvent)null, 0.0f, 0);
    }

    public VibrationListener getListener() {
        return this.listener;
    }

    public void m_142466_(CompoundTag p_222868_) {
        super.m_142466_(p_222868_);
        if (p_222868_.m_128425_("warning_level", 99)) {
            this.warningLevel = p_222868_.m_128451_("warning_level");
        }
        if (p_222868_.m_128425_("listener", 10)) {
            VibrationListener.m_223781_((VibrationListener.VibrationListenerConfig)this).parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_222868_.m_128469_("listener"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_222864_ -> {
                this.listener = p_222864_;
            });
        }
    }

    protected void m_183515_(CompoundTag p_222878_) {
        super.m_183515_(p_222878_);
        p_222878_.m_128405_("warning_level", this.warningLevel);
        VibrationListener.m_223781_((VibrationListener.VibrationListenerConfig)this).encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.listener).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_222871_ -> p_222878_.m_128365_("listener", p_222871_));
    }

    public TagKey<GameEvent> m_213929_() {
        return GameEventTags.f_215854_;
    }

    public boolean m_213641_(ServerLevel p_222856_, GameEventListener p_222857_, BlockPos p_222858_, GameEvent p_222859_, GameEvent.Context p_222860_) {
        return !this.m_58901_() && (Boolean)this.m_58900_().m_61143_((Property)StalkShriekerBlock.SHRIEKING) == false && StalkShriekerBlockEntity.tryGetPlayer(p_222860_.f_223711_()) != null;
    }

    @Nullable
    public static ServerPlayer tryGetPlayer(@Nullable Entity p_222862_) {
        Projectile projectile;
        Entity entity1;
        Entity $$4;
        if (p_222862_ instanceof ServerPlayer) {
            ServerPlayer serverplayer1 = (ServerPlayer)p_222862_;
            return serverplayer1;
        }
        if (p_222862_ != null && ($$4 = p_222862_.m_6688_()) instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)$$4;
            return serverplayer;
        }
        if (p_222862_ instanceof Projectile && (entity1 = (projectile = (Projectile)p_222862_).m_37282_()) instanceof ServerPlayer) {
            ServerPlayer serverplayer2 = (ServerPlayer)entity1;
            return serverplayer2;
        }
        return null;
    }

    public void m_213991_(ServerLevel p_222848_, GameEventListener p_222849_, BlockPos p_222850_, GameEvent p_222851_, @Nullable Entity p_222852_, @Nullable Entity p_222853_, float p_222854_) {
        this.tryShriek(p_222848_, StalkShriekerBlockEntity.tryGetPlayer(p_222853_ != null ? p_222853_ : p_222852_));
    }

    public void tryShriek(ServerLevel p_222842_, @Nullable ServerPlayer p_222843_) {
        BlockState blockstate;
        if (p_222843_ != null && !((Boolean)(blockstate = this.m_58900_()).m_61143_((Property)StalkShriekerBlock.SHRIEKING)).booleanValue()) {
            this.warningLevel = 0;
            if (!this.canRespond(p_222842_) || this.tryToWarn(p_222842_, p_222843_)) {
                this.shriek(p_222842_, (Entity)p_222843_);
            }
        }
    }

    private boolean tryToWarn(ServerLevel p_222875_, ServerPlayer p_222876_) {
        OptionalInt optionalint = WardenSpawnTracker.m_219577_((ServerLevel)p_222875_, (BlockPos)this.m_58899_(), (ServerPlayer)p_222876_);
        optionalint.ifPresent(p_222838_ -> {
            this.warningLevel = p_222838_;
        });
        return optionalint.isPresent();
    }

    private void shriek(ServerLevel p_222845_, @Nullable Entity p_222846_) {
        BlockPos blockpos = this.m_58899_();
        BlockState blockstate = this.m_58900_();
        p_222845_.m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)StalkShriekerBlock.SHRIEKING, (Comparable)Boolean.valueOf(true)), 2);
        p_222845_.m_186460_(blockpos, blockstate.m_60734_(), 90);
        p_222845_.m_46796_(3007, blockpos, 0);
        p_222845_.m_220407_(GameEvent.f_223701_, blockpos, GameEvent.Context.m_223717_((Entity)p_222846_));
    }

    private boolean canRespond(ServerLevel p_222873_) {
        return (Boolean)this.m_58900_().m_61143_((Property)StalkShriekerBlock.CAN_SUMMON) != false && p_222873_.m_46791_() != Difficulty.PEACEFUL && p_222873_.m_46469_().m_46207_(GameRules.f_220347_);
    }

    public void tryRespond(ServerLevel p_222840_) {
        if (this.canRespond(p_222840_) && this.warningLevel > 0) {
            if (!this.trySummonWarden(p_222840_)) {
                this.playWardenReplySound();
            }
            Warden.m_219375_((ServerLevel)p_222840_, (Vec3)Vec3.m_82512_((Vec3i)this.m_58899_()), (Entity)null, (int)40);
        }
    }

    private void playWardenReplySound() {
        SoundEvent soundevent = (SoundEvent)SOUND_BY_LEVEL.get(this.warningLevel);
        if (soundevent != null) {
            BlockPos blockpos = this.m_58899_();
            int i = blockpos.m_123341_() + Mth.m_216287_((RandomSource)this.f_58857_.f_46441_, (int)-10, (int)10);
            int j = blockpos.m_123342_() + Mth.m_216287_((RandomSource)this.f_58857_.f_46441_, (int)-10, (int)10);
            int k = blockpos.m_123343_() + Mth.m_216287_((RandomSource)this.f_58857_.f_46441_, (int)-10, (int)10);
            this.f_58857_.m_6263_((Player)null, (double)i, (double)j, (double)k, soundevent, SoundSource.HOSTILE, 5.0f, 1.0f);
        }
    }

    private boolean trySummonWarden(ServerLevel p_222881_) {
        return this.warningLevel < 4 ? false : SpawnUtil.m_216403_((EntityType)((EntityType)ModEntities.STALKER.get()), (MobSpawnType)MobSpawnType.TRIGGERED, (ServerLevel)p_222881_, (BlockPos)this.m_58899_(), (int)20, (int)5, (int)6, (SpawnUtil.Strategy)SpawnUtil.Strategy.f_216413_).isPresent();
    }

    public void m_214037_() {
        this.m_6596_();
    }
}

