/*
 * Decompiled with CFR 0.152.
 */
package net.grupa_tkd.better_minecraft.client.gui;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ModConfig {
    private static final ModConfig INSTANCE;
    public static final ForgeConfigSpec SPEC;
    private static final Path CONFIG_PATH;
    public final ForgeConfigSpec.BooleanValue showBedrockUi;

    private ModConfig(ForgeConfigSpec.Builder configSpecBuilder) {
        this.showBedrockUi = configSpecBuilder.translation("KonfiguracjaBedrocka").define("showBedrockUi", true);
    }

    public static ModConfig getInstance() {
        return INSTANCE;
    }

    public boolean showBedrockUi() {
        return (Boolean)this.showBedrockUi.get();
    }

    public void changeShowBedrockUi(boolean newValue) {
        this.showBedrockUi.set((Object)newValue);
    }

    public void save() {
        SPEC.save();
    }

    static {
        CONFIG_PATH = Paths.get("config", "better_minecraft.toml");
        Pair specPair = new ForgeConfigSpec.Builder().configure(ModConfig::new);
        INSTANCE = (ModConfig)specPair.getLeft();
        SPEC = (ForgeConfigSpec)specPair.getRight();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)CONFIG_PATH).sync().autoreload().writingMode(WritingMode.REPLACE).build();
        config.load();
        config.save();
        SPEC.setConfig((CommentedConfig)config);
    }
}

