/*
 * Decompiled with CFR 0.152.
 */
package net.grupa_tkd.better_minecraft.client.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.grupa_tkd.better_minecraft.client.gui.components.BedrockButtonWhite;
import net.grupa_tkd.better_minecraft.client.gui.screens.BedrockSelectWorldScreen;
import net.grupa_tkd.better_minecraft.client.gui.screens.BedrockServerSelectionList;
import net.grupa_tkd.better_minecraft.client.gui.screens.BedrockTitleScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DirectJoinServerScreen;
import net.minecraft.client.gui.screens.EditServerScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.ServerStatusPinger;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.server.LanServer;
import net.minecraft.client.server.LanServerDetection;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class BedrockJoinMultiplayerScreen
extends Screen {
    private static final ResourceLocation SING_TEXTURE = new ResourceLocation("better_minecraft:textures/gui/bedrock_ui/icons/singleplayer.png");
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ServerStatusPinger pinger = new ServerStatusPinger();
    private final Screen lastScreen;
    protected BedrockServerSelectionList serverSelectionList;
    private ServerList servers;
    private BedrockButtonWhite editButton;
    private BedrockButtonWhite selectButton;
    private BedrockButtonWhite deleteButton;
    @Nullable
    private List<Component> toolTip;
    private ServerData editingServer;
    private LanServerDetection.LanServerList lanServerList;
    @Nullable
    private LanServerDetection.LanServerDetector lanServerDetector;
    private boolean initedOnce;

    public BedrockJoinMultiplayerScreen(Screen p_99688_) {
        super((Component)Component.m_237115_((String)"multiplayer.title"));
        this.lastScreen = p_99688_;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_96541_.f_91068_.m_90926_(true);
        if (this.initedOnce) {
            this.serverSelectionList.m_93437_(this.f_96543_, this.f_96544_, 32, this.f_96544_ - 64);
        } else {
            this.initedOnce = true;
            this.servers = new ServerList(this.f_96541_);
            this.servers.m_105431_();
            this.lanServerList = new LanServerDetection.LanServerList();
            try {
                this.lanServerDetector = new LanServerDetection.LanServerDetector(this.lanServerList);
                this.lanServerDetector.start();
            }
            catch (Exception exception) {
                LOGGER.warn("Unable to start LAN server detection: {}", (Object)exception.getMessage());
            }
            this.serverSelectionList = new BedrockServerSelectionList(this, this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 64, 36);
            this.serverSelectionList.updateOnlineServers(this.servers);
        }
        this.m_7787_((GuiEventListener)this.serverSelectionList);
        this.selectButton = (BedrockButtonWhite)this.m_142416_(new BedrockButtonWhite(this.f_96543_ / 2 - 154, this.f_96544_ - 52, 100, 20, (Component)Component.m_237115_((String)"selectServer.select").m_130940_(ChatFormatting.GRAY), p_99728_ -> this.joinSelectedServer()));
        this.m_142416_(new BedrockButtonWhite(this.f_96543_ / 2 - 50, this.f_96544_ - 52, 100, 20, (Component)Component.m_237115_((String)"selectServer.direct").m_130940_(ChatFormatting.GRAY), p_99724_ -> {
            this.editingServer = new ServerData(I18n.m_118938_((String)"selectServer.defaultName", (Object[])new Object[0]), "", false);
            this.f_96541_.m_91152_((Screen)new DirectJoinServerScreen((Screen)this, this::directJoinCallback, this.editingServer));
        }));
        this.m_142416_(new BedrockButtonWhite(this.f_96543_ / 2 + 4 + 50, this.f_96544_ - 52, 100, 20, (Component)Component.m_237115_((String)"selectServer.add").m_130940_(ChatFormatting.GRAY), p_99720_ -> {
            this.editingServer = new ServerData(I18n.m_118938_((String)"selectServer.defaultName", (Object[])new Object[0]), "", false);
            this.f_96541_.m_91152_((Screen)new EditServerScreen((Screen)this, this::addServerCallback, this.editingServer));
        }));
        this.editButton = (BedrockButtonWhite)this.m_142416_(new BedrockButtonWhite(this.f_96543_ / 2 - 154, this.f_96544_ - 28, 70, 20, (Component)Component.m_237115_((String)"selectServer.edit").m_130940_(ChatFormatting.GRAY), p_99715_ -> {
            BedrockServerSelectionList.Entry serverselectionlist$entry = (BedrockServerSelectionList.Entry)this.serverSelectionList.m_93511_();
            if (serverselectionlist$entry instanceof BedrockServerSelectionList.OnlineServerEntry) {
                ServerData serverdata = ((BedrockServerSelectionList.OnlineServerEntry)serverselectionlist$entry).getServerData();
                this.editingServer = new ServerData(serverdata.f_105362_, serverdata.f_105363_, false);
                this.editingServer.m_105381_(serverdata);
                this.f_96541_.m_91152_((Screen)new EditServerScreen((Screen)this, this::editServerCallback, this.editingServer));
            }
        }));
        this.deleteButton = (BedrockButtonWhite)this.m_142416_(new BedrockButtonWhite(this.f_96543_ / 2 - 74, this.f_96544_ - 28, 70, 20, (Component)Component.m_237115_((String)"selectServer.delete").m_130940_(ChatFormatting.GRAY), p_99710_ -> {
            String s;
            BedrockServerSelectionList.Entry serverselectionlist$entry = (BedrockServerSelectionList.Entry)this.serverSelectionList.m_93511_();
            if (serverselectionlist$entry instanceof BedrockServerSelectionList.OnlineServerEntry && (s = ((BedrockServerSelectionList.OnlineServerEntry)serverselectionlist$entry).getServerData().f_105362_) != null) {
                MutableComponent component = Component.m_237115_((String)"selectServer.deleteQuestion");
                MutableComponent component1 = Component.m_237110_((String)"selectServer.deleteWarning", (Object[])new Object[]{s});
                MutableComponent component2 = Component.m_237115_((String)"selectServer.deleteButton");
                Component component3 = CommonComponents.f_130656_;
                this.f_96541_.m_91152_((Screen)new ConfirmScreen(this::deleteCallback, (Component)component, (Component)component1, (Component)component2, component3));
            }
        }));
        this.m_142416_(new BedrockButtonWhite(this.f_96543_ / 2 + 4, this.f_96544_ - 28, 70, 20, (Component)Component.m_237115_((String)"selectServer.refresh").m_130940_(ChatFormatting.GRAY), p_99706_ -> this.refreshServerList()));
        this.m_142416_(new BedrockButtonWhite(this.f_96543_ / 2 + 4 + 76, this.f_96544_ - 28, 75, 20, (Component)Component.m_237115_((String)"gui.cancel").m_130940_(ChatFormatting.GRAY), p_99699_ -> this.f_96541_.m_91152_((Screen)new BedrockTitleScreen())));
        this.m_142416_((GuiEventListener)new ImageButton(this.f_96543_ / 2 - 190, this.f_96544_ - 28, 20, 20, 0, 0, 20, SING_TEXTURE, 32, 64, p_96784_ -> Minecraft.m_91087_().m_91152_((Screen)new BedrockSelectWorldScreen(this)), (Component)Component.m_237115_((String)"menu.singleplayer")));
        this.onSelectedChange();
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.lanServerList.m_120095_()) {
            List list = this.lanServerList.m_120100_();
            this.lanServerList.m_120099_();
            this.serverSelectionList.updateNetworkServers(list);
        }
        this.pinger.m_105453_();
    }

    public void m_7861_() {
        this.f_96541_.f_91068_.m_90926_(false);
        if (this.lanServerDetector != null) {
            this.lanServerDetector.interrupt();
            this.lanServerDetector = null;
        }
        this.pinger.m_105465_();
    }

    private void refreshServerList() {
        this.f_96541_.m_91152_((Screen)new BedrockJoinMultiplayerScreen(this.lastScreen));
    }

    private void deleteCallback(boolean p_99712_) {
        BedrockServerSelectionList.Entry serverselectionlist$entry = (BedrockServerSelectionList.Entry)this.serverSelectionList.m_93511_();
        if (p_99712_ && serverselectionlist$entry instanceof BedrockServerSelectionList.OnlineServerEntry) {
            this.servers.m_105440_(((BedrockServerSelectionList.OnlineServerEntry)serverselectionlist$entry).getServerData());
            this.servers.m_105442_();
            this.serverSelectionList.setSelected(null);
            this.serverSelectionList.updateOnlineServers(this.servers);
        }
        this.f_96541_.m_91152_((Screen)this);
    }

    private void editServerCallback(boolean p_99717_) {
        BedrockServerSelectionList.Entry serverselectionlist$entry = (BedrockServerSelectionList.Entry)this.serverSelectionList.m_93511_();
        if (p_99717_ && serverselectionlist$entry instanceof BedrockServerSelectionList.OnlineServerEntry) {
            ServerData serverdata = ((BedrockServerSelectionList.OnlineServerEntry)serverselectionlist$entry).getServerData();
            serverdata.f_105362_ = this.editingServer.f_105362_;
            serverdata.f_105363_ = this.editingServer.f_105363_;
            serverdata.m_105381_(this.editingServer);
            this.servers.m_105442_();
            this.serverSelectionList.updateOnlineServers(this.servers);
        }
        this.f_96541_.m_91152_((Screen)this);
    }

    private void addServerCallback(boolean p_99722_) {
        if (p_99722_) {
            this.servers.m_233842_(this.editingServer, false);
            this.servers.m_105442_();
            this.serverSelectionList.setSelected(null);
            this.serverSelectionList.updateOnlineServers(this.servers);
        }
        this.f_96541_.m_91152_((Screen)this);
    }

    private void directJoinCallback(boolean p_99726_) {
        if (p_99726_) {
            this.join(this.editingServer);
        } else {
            this.f_96541_.m_91152_((Screen)this);
        }
    }

    public boolean m_7933_(int p_99690_, int p_99691_, int p_99692_) {
        if (super.m_7933_(p_99690_, p_99691_, p_99692_)) {
            return true;
        }
        if (p_99690_ == 294) {
            this.refreshServerList();
            return true;
        }
        if (this.serverSelectionList.m_93511_() != null) {
            if (p_99690_ != 257 && p_99690_ != 335) {
                return this.serverSelectionList.m_7933_(p_99690_, p_99691_, p_99692_);
            }
            this.joinSelectedServer();
            return true;
        }
        return false;
    }

    public void m_6305_(PoseStack p_99694_, int p_99695_, int p_99696_, float p_99697_) {
        this.toolTip = null;
        this.m_7333_(p_99694_);
        this.serverSelectionList.m_6305_(p_99694_, p_99695_, p_99696_, p_99697_);
        BedrockJoinMultiplayerScreen.m_93215_((PoseStack)p_99694_, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        super.m_6305_(p_99694_, p_99695_, p_99696_, p_99697_);
        if (this.toolTip != null) {
            this.m_96597_(p_99694_, this.toolTip, p_99695_, p_99696_);
        }
    }

    public void joinSelectedServer() {
        BedrockServerSelectionList.Entry serverselectionlist$entry = (BedrockServerSelectionList.Entry)this.serverSelectionList.m_93511_();
        if (serverselectionlist$entry instanceof BedrockServerSelectionList.OnlineServerEntry) {
            this.join(((BedrockServerSelectionList.OnlineServerEntry)serverselectionlist$entry).getServerData());
        } else if (serverselectionlist$entry instanceof BedrockServerSelectionList.NetworkServerEntry) {
            LanServer lanserver = ((BedrockServerSelectionList.NetworkServerEntry)serverselectionlist$entry).getServerData();
            this.join(new ServerData(lanserver.m_120078_(), lanserver.m_120079_(), true));
        }
    }

    private void join(ServerData p_99703_) {
        ConnectScreen.m_169267_((Screen)this, (Minecraft)this.f_96541_, (ServerAddress)ServerAddress.m_171864_((String)p_99703_.f_105363_), (ServerData)p_99703_);
    }

    public void setSelected(BedrockServerSelectionList.Entry p_99701_) {
        this.serverSelectionList.setSelected(p_99701_);
        this.onSelectedChange();
    }

    protected void onSelectedChange() {
        this.selectButton.active = false;
        this.editButton.active = false;
        this.deleteButton.active = false;
        BedrockServerSelectionList.Entry serverselectionlist$entry = (BedrockServerSelectionList.Entry)this.serverSelectionList.m_93511_();
        if (serverselectionlist$entry != null && !(serverselectionlist$entry instanceof BedrockServerSelectionList.LANHeader)) {
            this.selectButton.active = true;
            if (serverselectionlist$entry instanceof BedrockServerSelectionList.OnlineServerEntry) {
                this.editButton.active = true;
                this.deleteButton.active = true;
            }
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
    }

    public ServerStatusPinger getPinger() {
        return this.pinger;
    }

    public void setToolTip(List<Component> p_99708_) {
        this.toolTip = p_99708_;
    }

    public ServerList getServers() {
        return this.servers;
    }
}

