/*
 * Decompiled with CFR 0.152.
 */
package net.grupa_tkd.better_minecraft.client.gui.screens;

import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nullable;
import net.grupa_tkd.better_minecraft.client.gui.screens.BedrockJoinMultiplayerScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.server.LanServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class BedrockServerSelectionList
extends ObjectSelectionList<Entry> {
    static final Logger LOGGER = LogUtils.getLogger();
    static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER)).build());
    static final ResourceLocation ICON_MISSING = new ResourceLocation("textures/misc/unknown_server.png");
    static final ResourceLocation ICON_OVERLAY_LOCATION = new ResourceLocation("textures/gui/server_selection.png");
    static final Component SCANNING_LABEL = Component.m_237115_((String)"lanServer.scanning");
    static final Component CANT_RESOLVE_TEXT = Component.m_237115_((String)"multiplayer.status.cannot_resolve").m_130940_(ChatFormatting.DARK_RED);
    static final Component CANT_CONNECT_TEXT = Component.m_237115_((String)"multiplayer.status.cannot_connect").m_130940_(ChatFormatting.DARK_RED);
    static final Component INCOMPATIBLE_TOOLTIP = Component.m_237115_((String)"multiplayer.status.incompatible");
    static final Component NO_CONNECTION_TOOLTIP = Component.m_237115_((String)"multiplayer.status.no_connection");
    static final Component PINGING_TOOLTIP = Component.m_237115_((String)"multiplayer.status.pinging");
    private final BedrockJoinMultiplayerScreen screen;
    private final List<OnlineServerEntry> onlineServers = Lists.newArrayList();
    private final Entry lanHeader = new LANHeader();
    private final List<NetworkServerEntry> networkServers = Lists.newArrayList();

    public BedrockServerSelectionList(BedrockJoinMultiplayerScreen p_99771_, Minecraft p_99772_, int p_99773_, int p_99774_, int p_99775_, int p_99776_, int p_99777_) {
        super(p_99772_, p_99773_, p_99774_, p_99775_, p_99776_, p_99777_);
        this.screen = p_99771_;
    }

    private void refreshEntries() {
        this.m_93516_();
        this.onlineServers.forEach(p_169979_ -> this.m_7085_((AbstractSelectionList.Entry)p_169979_));
        this.m_7085_((AbstractSelectionList.Entry)this.lanHeader);
        this.networkServers.forEach(p_169976_ -> this.m_7085_((AbstractSelectionList.Entry)p_169976_));
    }

    public void setSelected(@Nullable Entry p_99790_) {
        super.m_6987_((AbstractSelectionList.Entry)p_99790_);
        this.screen.onSelectedChange();
    }

    public boolean m_7933_(int p_99782_, int p_99783_, int p_99784_) {
        Entry BedrockServerSelectionList$entry = (Entry)this.m_93511_();
        return BedrockServerSelectionList$entry != null && BedrockServerSelectionList$entry.m_7933_(p_99782_, p_99783_, p_99784_) || super.m_7933_(p_99782_, p_99783_, p_99784_);
    }

    protected void m_6778_(AbstractSelectionList.SelectionDirection p_99788_) {
        this.m_93464_(p_99788_, p_169973_ -> !(p_169973_ instanceof LANHeader));
    }

    public void updateOnlineServers(ServerList p_99798_) {
        this.onlineServers.clear();
        for (int i = 0; i < p_99798_.m_105445_(); ++i) {
            this.onlineServers.add(new OnlineServerEntry(this.screen, p_99798_.m_105432_(i)));
        }
        this.refreshEntries();
    }

    public void updateNetworkServers(List<LanServer> p_99800_) {
        this.networkServers.clear();
        for (LanServer lanserver : p_99800_) {
            this.networkServers.add(new NetworkServerEntry(this.screen, lanserver));
        }
        this.refreshEntries();
    }

    protected int m_5756_() {
        return super.m_5756_() + 30;
    }

    public int m_5759_() {
        return super.m_5759_() + 85;
    }

    protected boolean m_5694_() {
        return this.screen.m_7222_() == this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LANHeader
    extends Entry {
        private final Minecraft minecraft = Minecraft.m_91087_();

        public void m_6311_(PoseStack p_99818_, int p_99819_, int p_99820_, int p_99821_, int p_99822_, int p_99823_, int p_99824_, int p_99825_, boolean p_99826_, float p_99827_) {
            int i = p_99820_ + p_99823_ / 2 - 4;
            this.minecraft.f_91062_.m_92889_(p_99818_, SCANNING_LABEL, (float)(this.minecraft.f_91080_.f_96543_ / 2 - this.minecraft.f_91062_.m_92852_((FormattedText)SCANNING_LABEL) / 2), (float)i, 0xFFFFFF);
            String s = switch ((int)(Util.m_137550_() / 300L % 4L)) {
                default -> "O o o";
                case 1, 3 -> "o O o";
                case 2 -> "o o O";
            };
            this.minecraft.f_91062_.m_92883_(p_99818_, s, (float)(this.minecraft.f_91080_.f_96543_ / 2 - this.minecraft.f_91062_.m_92895_(s) / 2), (float)(i + 9), 0x808080);
        }

        public Component m_142172_() {
            return Component.m_237119_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry> {
    }

    @OnlyIn(value=Dist.CLIENT)
    public class OnlineServerEntry
    extends Entry {
        private static final int ICON_WIDTH = 32;
        private static final int ICON_HEIGHT = 32;
        private static final int ICON_OVERLAY_X_MOVE_RIGHT = 0;
        private static final int ICON_OVERLAY_X_MOVE_LEFT = 32;
        private static final int ICON_OVERLAY_X_MOVE_DOWN = 64;
        private static final int ICON_OVERLAY_X_MOVE_UP = 96;
        private static final int ICON_OVERLAY_Y_UNSELECTED = 0;
        private static final int ICON_OVERLAY_Y_SELECTED = 32;
        private final BedrockJoinMultiplayerScreen screen;
        private final Minecraft minecraft;
        private final ServerData serverData;
        private final ResourceLocation iconLocation;
        @Nullable
        private String lastIconB64;
        @Nullable
        private DynamicTexture icon;
        private long lastClickTime;

        protected OnlineServerEntry(BedrockJoinMultiplayerScreen p_99864_, ServerData p_99865_) {
            this.screen = p_99864_;
            this.serverData = p_99865_;
            this.minecraft = Minecraft.m_91087_();
            this.iconLocation = new ResourceLocation("servers/" + Hashing.sha1().hashUnencodedChars((CharSequence)p_99865_.f_105363_) + "/icon");
            AbstractTexture abstracttexture = this.minecraft.m_91097_().m_174786_(this.iconLocation, (AbstractTexture)MissingTextureAtlasSprite.m_118080_());
            if (abstracttexture != MissingTextureAtlasSprite.m_118080_() && abstracttexture instanceof DynamicTexture) {
                this.icon = (DynamicTexture)abstracttexture;
            }
        }

        public void m_6311_(PoseStack p_99879_, int p_99880_, int p_99881_, int p_99882_, int p_99883_, int p_99884_, int p_99885_, int p_99886_, boolean p_99887_, float p_99888_) {
            List list1;
            Component component;
            int l;
            if (!this.serverData.f_105369_) {
                this.serverData.f_105369_ = true;
                this.serverData.f_105366_ = -2L;
                this.serverData.f_105365_ = Component.m_237119_();
                this.serverData.f_105364_ = Component.m_237119_();
                THREAD_POOL.submit(() -> {
                    try {
                        this.screen.getPinger().m_105459_(this.serverData, () -> this.minecraft.execute(this::updateServerList));
                    }
                    catch (UnknownHostException unknownhostexception) {
                        this.serverData.f_105366_ = -1L;
                        this.serverData.f_105365_ = CANT_RESOLVE_TEXT;
                    }
                    catch (Exception exception) {
                        this.serverData.f_105366_ = -1L;
                        this.serverData.f_105365_ = CANT_CONNECT_TEXT;
                    }
                });
            }
            boolean flag = this.serverData.f_105367_ != SharedConstants.m_183709_().getProtocolVersion();
            this.minecraft.f_91062_.m_92883_(p_99879_, this.serverData.f_105362_, (float)(p_99882_ + 32 + 3), (float)(p_99881_ + 1), 0xFFFFFF);
            List list = this.minecraft.f_91062_.m_92923_((FormattedText)this.serverData.f_105365_, p_99883_ - 32 - 2);
            for (int i = 0; i < Math.min(list.size(), 2); ++i) {
                this.minecraft.f_91062_.m_92877_(p_99879_, (FormattedCharSequence)list.get(i), (float)(p_99882_ + 32 + 3), (float)(p_99881_ + 12 + 9 * i), 0x808080);
            }
            Component component1 = flag ? this.serverData.f_105368_.m_6881_().m_130940_(ChatFormatting.RED) : this.serverData.f_105364_;
            int j = this.minecraft.f_91062_.m_92852_((FormattedText)component1);
            this.minecraft.f_91062_.m_92889_(p_99879_, component1, (float)(p_99882_ + p_99883_ - j - 15 - 2), (float)(p_99881_ + 1), 0x808080);
            int k = 0;
            if (flag) {
                l = 5;
                component = INCOMPATIBLE_TOOLTIP;
                list1 = this.serverData.f_105370_;
            } else if (this.serverData.f_105369_ && this.serverData.f_105366_ != -2L) {
                l = this.serverData.f_105366_ < 0L ? 5 : (this.serverData.f_105366_ < 150L ? 0 : (this.serverData.f_105366_ < 300L ? 1 : (this.serverData.f_105366_ < 600L ? 2 : (this.serverData.f_105366_ < 1000L ? 3 : 4))));
                if (this.serverData.f_105366_ < 0L) {
                    component = NO_CONNECTION_TOOLTIP;
                    list1 = Collections.emptyList();
                } else {
                    component = Component.m_237110_((String)"multiplayer.status.ping", (Object[])new Object[]{this.serverData.f_105366_});
                    list1 = this.serverData.f_105370_;
                }
            } else {
                k = 1;
                l = (int)(Util.m_137550_() / 100L + (long)(p_99880_ * 2) & 7L);
                if (l > 4) {
                    l = 8 - l;
                }
                component = PINGING_TOOLTIP;
                list1 = Collections.emptyList();
            }
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
            GuiComponent.m_93133_((PoseStack)p_99879_, (int)(p_99882_ + p_99883_ - 15), (int)p_99881_, (float)(k * 10), (float)(176 + l * 8), (int)10, (int)8, (int)256, (int)256);
            String s = this.serverData.m_105388_();
            if (!Objects.equals(s, this.lastIconB64)) {
                if (this.uploadServerIcon(s)) {
                    this.lastIconB64 = s;
                } else {
                    this.serverData.m_105383_((String)null);
                    this.updateServerList();
                }
            }
            if (this.icon == null) {
                this.drawIcon(p_99879_, p_99882_, p_99881_, ICON_MISSING);
            } else {
                this.drawIcon(p_99879_, p_99882_, p_99881_, this.iconLocation);
            }
            int i1 = p_99885_ - p_99882_;
            int j1 = p_99886_ - p_99881_;
            if (i1 >= p_99883_ - 15 && i1 <= p_99883_ - 5 && j1 >= 0 && j1 <= 8) {
                this.screen.setToolTip(Collections.singletonList(component));
            } else if (i1 >= p_99883_ - j - 15 - 2 && i1 <= p_99883_ - 15 - 2 && j1 >= 0 && j1 <= 8) {
                this.screen.setToolTip(list1);
            }
        }

        public void updateServerList() {
            this.screen.getServers().m_105442_();
        }

        protected void drawIcon(PoseStack p_99890_, int p_99891_, int p_99892_, ResourceLocation p_99893_) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)p_99893_);
            RenderSystem.m_69478_();
            GuiComponent.m_93133_((PoseStack)p_99890_, (int)p_99891_, (int)p_99892_, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            RenderSystem.m_69461_();
        }

        private boolean canJoin() {
            return true;
        }

        private boolean uploadServerIcon(@Nullable String p_99897_) {
            if (p_99897_ == null) {
                this.minecraft.m_91097_().m_118513_(this.iconLocation);
                if (this.icon != null && this.icon.m_117991_() != null) {
                    this.icon.m_117991_().close();
                }
                this.icon = null;
            } else {
                try {
                    NativeImage nativeimage = NativeImage.m_85060_((String)p_99897_);
                    Validate.validState((nativeimage.m_84982_() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                    Validate.validState((nativeimage.m_85084_() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                    if (this.icon == null) {
                        this.icon = new DynamicTexture(nativeimage);
                    } else {
                        this.icon.m_117988_(nativeimage);
                        this.icon.m_117985_();
                    }
                    this.minecraft.m_91097_().m_118495_(this.iconLocation, (AbstractTexture)this.icon);
                }
                catch (Throwable throwable) {
                    LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.serverData.f_105362_, this.serverData.f_105363_, throwable});
                    return false;
                }
            }
            return true;
        }

        public boolean m_7933_(int p_99875_, int p_99876_, int p_99877_) {
            if (Screen.m_96638_()) {
                BedrockServerSelectionList BedrockServerSelectionList2 = this.screen.serverSelectionList;
                int i = BedrockServerSelectionList2.m_6702_().indexOf((Object)this);
                if (i == -1) {
                    return true;
                }
                if (p_99875_ == 264 && i < this.screen.getServers().m_105445_() - 1 || p_99875_ == 265 && i > 0) {
                    this.swap(i, p_99875_ == 264 ? i + 1 : i - 1);
                    return true;
                }
            }
            return super.m_7933_(p_99875_, p_99876_, p_99877_);
        }

        private void swap(int p_99872_, int p_99873_) {
            this.screen.getServers().m_105434_(p_99872_, p_99873_);
            this.screen.serverSelectionList.updateOnlineServers(this.screen.getServers());
            Entry BedrockServerSelectionList$entry = (Entry)((Object)this.screen.serverSelectionList.m_6702_().get(p_99873_));
            this.screen.serverSelectionList.setSelected(BedrockServerSelectionList$entry);
            BedrockServerSelectionList.this.m_93498_((AbstractSelectionList.Entry)BedrockServerSelectionList$entry);
        }

        public boolean m_6375_(double p_99868_, double p_99869_, int p_99870_) {
            double d0 = p_99868_ - (double)BedrockServerSelectionList.this.m_5747_();
            double d1 = p_99869_ - (double)BedrockServerSelectionList.this.m_7610_(BedrockServerSelectionList.this.m_6702_().indexOf((Object)this));
            if (d0 <= 32.0) {
                if (d0 < 32.0 && d0 > 16.0 && this.canJoin()) {
                    this.screen.setSelected(this);
                    this.screen.joinSelectedServer();
                    return true;
                }
                int i = this.screen.serverSelectionList.m_6702_().indexOf((Object)this);
                if (d0 < 16.0 && d1 < 16.0 && i > 0) {
                    this.swap(i, i - 1);
                    return true;
                }
                if (d0 < 16.0 && d1 > 16.0 && i < this.screen.getServers().m_105445_() - 1) {
                    this.swap(i, i + 1);
                    return true;
                }
            }
            this.screen.setSelected(this);
            if (Util.m_137550_() - this.lastClickTime < 250L) {
                this.screen.joinSelectedServer();
            }
            this.lastClickTime = Util.m_137550_();
            return false;
        }

        public ServerData getServerData() {
            return this.serverData;
        }

        public Component m_142172_() {
            return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.serverData.f_105362_});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class NetworkServerEntry
    extends Entry {
        private static final int ICON_WIDTH = 32;
        private static final Component LAN_SERVER_HEADER = Component.m_237115_((String)"lanServer.title");
        private static final Component HIDDEN_ADDRESS_TEXT = Component.m_237115_((String)"selectServer.hiddenAddress");
        private final BedrockJoinMultiplayerScreen screen;
        protected final Minecraft minecraft;
        protected final LanServer serverData;
        private long lastClickTime;

        protected NetworkServerEntry(BedrockJoinMultiplayerScreen p_99836_, LanServer p_99837_) {
            this.screen = p_99836_;
            this.serverData = p_99837_;
            this.minecraft = Minecraft.m_91087_();
        }

        public void m_6311_(PoseStack p_99844_, int p_99845_, int p_99846_, int p_99847_, int p_99848_, int p_99849_, int p_99850_, int p_99851_, boolean p_99852_, float p_99853_) {
            this.minecraft.f_91062_.m_92889_(p_99844_, LAN_SERVER_HEADER, (float)(p_99847_ + 32 + 3), (float)(p_99846_ + 1), 0xFFFFFF);
            this.minecraft.f_91062_.m_92883_(p_99844_, this.serverData.m_120078_(), (float)(p_99847_ + 32 + 3), (float)(p_99846_ + 12), 0x808080);
            if (this.minecraft.f_91066_.f_92124_) {
                this.minecraft.f_91062_.m_92889_(p_99844_, HIDDEN_ADDRESS_TEXT, (float)(p_99847_ + 32 + 3), (float)(p_99846_ + 12 + 11), 0x303030);
            } else {
                this.minecraft.f_91062_.m_92883_(p_99844_, this.serverData.m_120079_(), (float)(p_99847_ + 32 + 3), (float)(p_99846_ + 12 + 11), 0x303030);
            }
        }

        public boolean m_6375_(double p_99840_, double p_99841_, int p_99842_) {
            this.screen.setSelected(this);
            if (Util.m_137550_() - this.lastClickTime < 250L) {
                this.screen.joinSelectedServer();
            }
            this.lastClickTime = Util.m_137550_();
            return false;
        }

        public LanServer getServerData() {
            return this.serverData;
        }

        public Component m_142172_() {
            return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{Component.m_237113_((String)"").m_7220_(LAN_SERVER_HEADER).m_130946_(" ").m_130946_(this.serverData.m_120078_())});
        }
    }
}

