/*
 * Decompiled with CFR 0.152.
 */
package net.grupa_tkd.better_minecraft.client.gui.screens;

import com.google.common.util.concurrent.Runnables;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.exception.RealmsServiceException;
import java.io.IOException;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.grupa_tkd.better_minecraft.client.gui.ConfigScreen;
import net.grupa_tkd.better_minecraft.client.gui.components.BedrockButtonWhite;
import net.grupa_tkd.better_minecraft.client.gui.screens.BedrockSelectWorldScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.AccessibilityOptionsScreen;
import net.minecraft.client.gui.screens.LanguageSelectScreen;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.multiplayer.Realms32bitWarningScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ModListScreen;
import net.minecraftforge.internal.BrandingControl;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class BedrockTitleScreen
extends Screen {
    private float xMouse;
    private float yMouse;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String DEMO_LEVEL_ID = "Demo_World";
    public static final Component COPYRIGHT_TEXT = Component.m_237113_((String)"Copyright Mojang AB. Do not distribute!");
    public static final CubeMap CUBE_MAP = new CubeMap(new ResourceLocation("better_minecraft:textures/gui/title/background/panorama"));
    private static final ResourceLocation PANORAMA_OVERLAY = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private static final ResourceLocation EXOTEL_PORTAL_TEXTURE = new ResourceLocation("better_minecraft:textures/gui/portal_bedrock.png");
    private static final ResourceLocation LANG_TEXTURE = new ResourceLocation("better_minecraft:textures/gui/bedrock_ui/icons/lang.png");
    private static final ResourceLocation ASC_TEXTURE = new ResourceLocation("better_minecraft:textures/gui/bedrock_ui/icons/dostepnosc.png");
    private final boolean minceraftEasterEgg;
    @Nullable
    private String splash;
    private Button resetDemoButton;
    private static final ResourceLocation MINECRAFT_LOGO = new ResourceLocation("better_minecraft:textures/gui/bedrock_ui/title.png");
    private static final ResourceLocation MINECRAFT_EDITION = new ResourceLocation("better_minecraft:textures/gui/bedrock_ui/edition.png");
    private Screen realmsNotificationsScreen;
    private final PanoramaRenderer panorama = new PanoramaRenderer(CUBE_MAP);
    private final boolean fading;
    private long fadeInStart;
    @Nullable
    private Warning32Bit warning32Bit;
    private RealmsClient realmsClient;
    private boolean realms32bitWarningShown = false;
    private int leftPos;
    private int topPos;

    public BedrockTitleScreen() {
        this(false);
    }

    public BedrockTitleScreen(boolean p_96733_) {
        super((Component)Component.m_237115_((String)"narrator.screen.title"));
        this.fading = p_96733_;
        this.minceraftEasterEgg = (double)new Random().nextFloat() < 1.0E-4;
        this.realmsClient = RealmsClient.m_87169_();
    }

    private void showRealms32BitWarningIfNeeded() {
        try {
            if (this.warning32Bit != null && !Minecraft.m_91087_().f_91066_.f_210816_ && !this.realms32bitWarningShown && this.warning32Bit.realmsSubscriptionFuture.getNow(false).booleanValue()) {
                this.realms32bitWarningShown = true;
                Minecraft.m_91087_().m_91152_((Screen)new Realms32bitWarningScreen((Screen)this));
            }
        }
        catch (CompletionException completionexception) {
            LOGGER.warn("Failed to retrieve realms subscriptions", (Throwable)completionexception);
            this.realms32bitWarningShown = true;
        }
    }

    public static CompletableFuture<Void> preloadResources(TextureManager p_96755_, Executor p_96756_) {
        return CompletableFuture.allOf(p_96755_.m_118501_(MINECRAFT_LOGO, p_96756_), p_96755_.m_118501_(MINECRAFT_EDITION, p_96756_), p_96755_.m_118501_(PANORAMA_OVERLAY, p_96756_), CUBE_MAP.m_108854_(p_96755_, p_96756_));
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6913_() {
        return false;
    }

    protected void m_7856_() {
        if (this.splash == null) {
            this.splash = Minecraft.m_91087_().m_91310_().m_118867_();
        }
        int i = this.f_96547_.m_92852_((FormattedText)COPYRIGHT_TEXT);
        int j = this.f_96543_ - i - 2;
        int k = 24;
        int l = this.f_96544_ / 4 + 48;
        Button modButton = null;
        this.createNormalMenuOptions(l, 24);
        modButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100000, l + 48, 98, 20, (Component)Component.m_237115_((String)"fml.menu.mods"), button -> Minecraft.m_91087_().m_91152_((Screen)new ModListScreen((Screen)this))));
        this.m_142416_(new BedrockButtonWhite(this.f_96543_ / 2 - 65, this.topPos / 2 + 91, 131, 20, (Component)Component.m_237115_((String)"menu.play").m_130940_(ChatFormatting.GRAY), p_96784_ -> Minecraft.m_91087_().m_91152_((Screen)new BedrockSelectWorldScreen(this))));
        this.m_142416_(new BedrockButtonWhite(this.f_96543_ / 2 - 65, this.topPos / 2 + 119, 131, 20, (Component)Component.m_237115_((String)"menu.options").m_130940_(ChatFormatting.GRAY), p_96784_ -> Minecraft.m_91087_().m_91152_((Screen)new OptionsScreen((Screen)this, Minecraft.m_91087_().f_91066_))));
        this.m_142416_(new BedrockButtonWhite(this.f_96543_ / 2 - 65, this.topPos / 2 + 147, 131, 20, (Component)Component.m_237115_((String)"fml.menu.mods").m_130940_(ChatFormatting.GRAY), button -> Minecraft.m_91087_().m_91152_((Screen)new ModListScreen((Screen)this))));
        this.m_142416_((GuiEventListener)new ImageButton(this.f_96543_ / 2 - 150, 147, 20, 20, 0, 0, 20, EXOTEL_PORTAL_TEXTURE, 32, 64, p_96784_ -> Minecraft.m_91087_().m_91152_((Screen)new ConfigScreen(this)), (Component)Component.m_237115_((String)"better_minecraft.configGui.title")));
        this.m_142416_((GuiEventListener)new ImageButton(this.f_96543_ / 2 - 174, 147, 20, 20, 0, 0, 20, LANG_TEXTURE, 32, 64, p_96784_ -> Minecraft.m_91087_().m_91152_((Screen)new LanguageSelectScreen((Screen)this, Minecraft.m_91087_().f_91066_, Minecraft.m_91087_().m_91102_())), (Component)Component.m_237115_((String)"narrator.button.language")));
        this.m_142416_((GuiEventListener)new ImageButton(this.f_96543_ / 2 - 126, 147, 20, 20, 0, 0, 20, ASC_TEXTURE, 32, 64, p_96784_ -> Minecraft.m_91087_().m_91152_((Screen)new AccessibilityOptionsScreen((Screen)this, Minecraft.m_91087_().f_91066_)), (Component)Component.m_237115_((String)"narrator.button.accessibility")));
        this.m_142416_((GuiEventListener)new PlainTextButton(j, this.f_96544_ - 10, i, 10, COPYRIGHT_TEXT, p_211790_ -> Minecraft.m_91087_().m_91152_((Screen)new WinScreen(false, Runnables.doNothing())), this.f_96547_));
        Minecraft.m_91087_().m_91372_(false);
        if (!Minecraft.m_91087_().m_91103_()) {
            CompletableFuture<Boolean> completablefuture = this.warning32Bit != null ? this.warning32Bit.realmsSubscriptionFuture : CompletableFuture.supplyAsync(this::hasRealmsSubscription, Util.m_183991_());
            this.warning32Bit = new Warning32Bit(MultiLineLabel.m_94345_((Font)this.f_96547_, (FormattedText)Component.m_237115_((String)"title.32bit.deprecation"), (int)350, (int)2), this.f_96543_ / 2, l - 24, completablefuture);
        }
    }

    private boolean hasRealmsSubscription() {
        try {
            return this.realmsClient.m_87235_().f_87573_.stream().anyMatch(p_211781_ -> p_211781_.f_87479_ != null && !p_211781_.f_87482_ && p_211781_.f_87479_.equals(Minecraft.m_91087_().m_91094_().m_92545_()));
        }
        catch (RealmsServiceException realmsserviceexception) {
            return false;
        }
    }

    private void createNormalMenuOptions(int p_96764_, int p_96765_) {
    }

    public Font getFontRenderer() {
        return this.f_96547_;
    }

    private void realmsButtonClicked() {
        Minecraft.m_91087_().m_91152_((Screen)new RealmsMainScreen((Screen)this));
    }

    public void m_6305_(PoseStack p_96739_, int p_96740_, int p_96741_, float p_96742_) {
        if (this.fadeInStart == 0L && this.fading) {
            this.fadeInStart = Util.m_137550_();
        }
        this.xMouse = p_96740_;
        this.yMouse = p_96740_;
        float f = this.fading ? (float)(Util.m_137550_() - this.fadeInStart) / 1000.0f : 1.0f;
        this.panorama.m_110003_(p_96742_, Mth.m_14036_((float)f, (float)0.0f, (float)1.0f));
        int i = 274;
        int j = this.f_96543_ / 2 - 137;
        int k = 30;
        int a = this.leftPos;
        int b = this.topPos;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)PANORAMA_OVERLAY);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.fading ? (float)Mth.m_14167_((float)Mth.m_14036_((float)f, (float)0.0f, (float)1.0f)) : 1.0f));
        BedrockTitleScreen.m_93160_((PoseStack)p_96739_, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128);
        float f1 = this.fading ? Mth.m_14036_((float)(f - 1.0f), (float)0.0f, (float)1.0f) : 1.0f;
        int l = Mth.m_14167_((float)(f1 * 255.0f)) << 24;
        if ((l & 0xFC000000) != 0) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)MINECRAFT_LOGO);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)f1);
            if (this.minceraftEasterEgg) {
                this.m_93101_(j, 30, (p_210862_, p_210863_) -> {
                    this.m_93228_(p_96739_, p_210862_ + 0, (int)p_210863_, 0, 0, 99, 44);
                    this.m_93228_(p_96739_, p_210862_ + 99, (int)p_210863_, 129, 0, 27, 44);
                    this.m_93228_(p_96739_, p_210862_ + 99 + 26, (int)p_210863_, 126, 0, 3, 44);
                    this.m_93228_(p_96739_, p_210862_ + 99 + 26 + 3, (int)p_210863_, 99, 0, 26, 44);
                    this.m_93228_(p_96739_, p_210862_ + 155, (int)p_210863_, 0, 45, 155, 44);
                });
            } else {
                this.m_93101_(j, 30, (p_211778_, p_211779_) -> {
                    this.m_93228_(p_96739_, p_211778_ + 0, (int)p_211779_, 0, 0, 155, 44);
                    this.m_93228_(p_96739_, p_211778_ + 155, (int)p_211779_, 0, 45, 155, 44);
                });
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)MINECRAFT_EDITION);
            BedrockTitleScreen.m_93133_((PoseStack)p_96739_, (int)(j + 88), (int)67, (float)0.0f, (float)0.0f, (int)98, (int)14, (int)128, (int)16);
            if (this.warning32Bit != null) {
                this.warning32Bit.label.m_207298_(p_96739_, this.warning32Bit.x, this.warning32Bit.y, 9, 2, 0x55200000);
                this.warning32Bit.label.m_6514_(p_96739_, this.warning32Bit.x, this.warning32Bit.y, 9, 0xFFFFFF | l);
            }
            String s = "Minecraft " + SharedConstants.m_183709_().getName();
            s = Minecraft.m_91087_().m_91402_() ? s + " Demo" : s + (String)("release".equalsIgnoreCase(Minecraft.m_91087_().m_91389_()) ? "" : "/" + Minecraft.m_91087_().m_91389_());
            if (Minecraft.m_193589_().m_184597_()) {
                s = s + I18n.m_118938_((String)"menu.modded", (Object[])new Object[0]);
            }
            BrandingControl.forEachLine((boolean)true, (boolean)true, (brdline, brd) -> {
                int n = brdline;
                Objects.requireNonNull(this.f_96547_);
                BedrockTitleScreen.m_93236_((PoseStack)p_96739_, (Font)this.f_96547_, (String)brd, (int)2, (int)(this.f_96544_ - (10 + n * (9 + 1))), (int)(0xFFFFFF | l));
            });
            BrandingControl.forEachAboveCopyrightLine((brdline, brd) -> {
                int n = this.f_96543_ - this.f_96547_.m_92895_(brd);
                int n2 = brdline + 1;
                Objects.requireNonNull(this.f_96547_);
                BedrockTitleScreen.m_93236_((PoseStack)p_96739_, (Font)this.f_96547_, (String)brd, (int)n, (int)(this.f_96544_ - (10 + n2 * (9 + 1))), (int)(0xFFFFFF | l));
            });
            for (GuiEventListener guieventlistener : this.m_6702_()) {
                if (!(guieventlistener instanceof AbstractWidget)) continue;
                ((AbstractWidget)guieventlistener).m_93650_(f1);
            }
            super.m_6305_(p_96739_, p_96740_, p_96741_, p_96742_);
        }
    }

    public boolean m_6375_(double p_96735_, double p_96736_, int p_96737_) {
        if (super.m_6375_(p_96735_, p_96736_, p_96737_)) {
            return true;
        }
        return true;
    }

    public void m_7861_() {
        if (this.realmsNotificationsScreen != null) {
            this.realmsNotificationsScreen.m_7861_();
        }
    }

    private void confirmDemo(boolean p_96778_) {
        if (p_96778_) {
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = Minecraft.m_91087_().m_91392_().m_78260_(DEMO_LEVEL_ID);){
                levelstoragesource$levelstorageaccess.m_78311_();
            }
            catch (IOException ioexception) {
                SystemToast.m_94866_((Minecraft)Minecraft.m_91087_(), (String)DEMO_LEVEL_ID);
                LOGGER.warn("Failed to delete demo world", (Throwable)ioexception);
            }
        }
        Minecraft.m_91087_().m_91152_((Screen)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    record Warning32Bit(MultiLineLabel label, int x, int y, CompletableFuture<Boolean> realmsSubscriptionFuture) {
    }
}

