/*
 * Decompiled with CFR 0.152.
 */
package net.grupa_tkd.better_minecraft.client.gui.screens;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.grupa_tkd.better_minecraft.client.gui.screens.BedrockSelectWorldScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.LoadingDotsText;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.EditWorldScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.WorldStem;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class BedrockWorldSelectionList
extends ObjectSelectionList<Entry> {
    static final Logger LOGGER = LogUtils.getLogger();
    static final DateFormat DATE_FORMAT = new SimpleDateFormat();
    static final ResourceLocation ICON_MISSING = new ResourceLocation("textures/misc/unknown_server.png");
    static final ResourceLocation ICON_OVERLAY_LOCATION = new ResourceLocation("better_minecraft:textures/gui/world_selection.png");
    private static final ResourceLocation FORGE_EXPERIMENTAL_WARNING_ICON = new ResourceLocation("better_minecraft:textures/gui/experimental_warning.png");
    static final Component FROM_NEWER_TOOLTIP_1 = Component.m_237115_((String)"selectWorld.tooltip.fromNewerVersion1").m_130940_(ChatFormatting.RED);
    static final Component FROM_NEWER_TOOLTIP_2 = Component.m_237115_((String)"selectWorld.tooltip.fromNewerVersion2").m_130940_(ChatFormatting.RED);
    static final Component SNAPSHOT_TOOLTIP_1 = Component.m_237115_((String)"selectWorld.tooltip.snapshot1").m_130940_(ChatFormatting.GOLD);
    static final Component SNAPSHOT_TOOLTIP_2 = Component.m_237115_((String)"selectWorld.tooltip.snapshot2").m_130940_(ChatFormatting.GOLD);
    static final Component WORLD_LOCKED_TOOLTIP = Component.m_237115_((String)"selectWorld.locked").m_130940_(ChatFormatting.RED);
    static final Component WORLD_REQUIRES_CONVERSION = Component.m_237115_((String)"selectWorld.conversion.tooltip").m_130940_(ChatFormatting.RED);
    private static final Duration MAX_LOAD_BLOCK_TIME = Duration.ofMillis(100L);
    private final BedrockSelectWorldScreen screen;
    @Nullable
    private CompletableFuture<List<LevelSummary>> levelsFuture;
    private final LoadingHeader loadingHeader;

    public BedrockWorldSelectionList(BedrockSelectWorldScreen p_101658_, Minecraft p_101659_, int p_101660_, int p_101661_, int p_101662_, int p_101663_, int p_101664_, Supplier<String> p_101665_, @Nullable BedrockWorldSelectionList p_101666_) {
        super(p_101659_, p_101660_, p_101661_, p_101662_, p_101663_, p_101664_);
        this.screen = p_101658_;
        this.loadingHeader = new LoadingHeader(p_101659_);
        if (p_101666_ != null) {
            this.levelsFuture = p_101666_.levelsFuture;
            this.refreshList(p_101665_.get());
        } else {
            this.reloadLevels(p_101665_);
        }
    }

    public void reloadLevels(Supplier<String> p_233207_) {
        this.levelsFuture = this.loadLevels();
        List<LevelSummary> list = this.pollReadyLevels(this.levelsFuture, MAX_LOAD_BLOCK_TIME);
        if (list != null) {
            this.fillLevels(p_233207_.get(), list);
        } else {
            this.fillLoadingLevels();
            this.levelsFuture.thenAcceptAsync(p_233210_ -> this.fillLevels((String)p_233207_.get(), (List<LevelSummary>)p_233210_), (Executor)this.f_93386_);
        }
    }

    public void refreshList(String p_233194_) {
        if (this.levelsFuture == null) {
            this.m_93516_();
        } else {
            List<LevelSummary> list = this.pollReadyLevels(this.levelsFuture, Duration.ZERO);
            if (list != null) {
                this.fillLevels(p_233194_, list);
            } else {
                this.fillLoadingLevels();
            }
        }
    }

    private CompletableFuture<List<LevelSummary>> loadLevels() {
        LevelStorageSource.LevelCandidates levelstoragesource$levelcandidates;
        try {
            levelstoragesource$levelcandidates = this.f_93386_.m_91392_().m_230833_();
        }
        catch (LevelStorageException levelstorageexception) {
            LOGGER.error("Couldn't load level list", (Throwable)levelstorageexception);
            this.handleLevelLoadFailure(levelstorageexception.m_230806_());
            return CompletableFuture.completedFuture(List.of());
        }
        if (levelstoragesource$levelcandidates.m_230843_()) {
            CreateWorldScreen.m_232896_((Minecraft)this.f_93386_, (Screen)null);
            return CompletableFuture.completedFuture(List.of());
        }
        return this.f_93386_.m_91392_().m_230813_(levelstoragesource$levelcandidates).exceptionally(p_233202_ -> {
            this.f_93386_.m_231412_(CrashReport.m_127521_((Throwable)p_233202_, (String)"Couldn't load level list"));
            return List.of();
        });
    }

    @Nullable
    private List<LevelSummary> pollReadyLevels(CompletableFuture<List<LevelSummary>> p_233204_, Duration p_233205_) {
        List<LevelSummary> list = null;
        try {
            list = p_233204_.get(p_233205_.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            // empty catch block
        }
        return list;
    }

    private void fillLevels(String p_233199_, List<LevelSummary> p_233200_) {
        this.m_93516_();
        p_233199_ = p_233199_.toLowerCase(Locale.ROOT);
        for (LevelSummary levelsummary : p_233200_) {
            if (!this.filterAccepts(p_233199_, levelsummary)) continue;
            this.m_7085_((AbstractSelectionList.Entry)new WorldListEntry(this, levelsummary));
        }
        this.notifyListUpdated();
    }

    private boolean filterAccepts(String p_233196_, LevelSummary p_233197_) {
        return p_233197_.m_78361_().toLowerCase(Locale.ROOT).contains(p_233196_) || p_233197_.m_78358_().toLowerCase(Locale.ROOT).contains(p_233196_);
    }

    private void fillLoadingLevels() {
        this.m_93516_();
        this.m_7085_((AbstractSelectionList.Entry)this.loadingHeader);
        this.notifyListUpdated();
    }

    private void notifyListUpdated() {
        this.screen.m_169407_(true);
    }

    private void handleLevelLoadFailure(Component p_233212_) {
        this.f_93386_.m_91152_((Screen)new ErrorScreen((Component)Component.m_237115_((String)"selectWorld.unable_to_load"), p_233212_));
    }

    protected int m_5756_() {
        return super.m_5756_() + 20;
    }

    public int m_5759_() {
        return super.m_5759_() + 50;
    }

    protected boolean m_5694_() {
        return this.screen.m_7222_() == this;
    }

    public void setSelected(@Nullable Entry p_233190_) {
        super.m_6987_((AbstractSelectionList.Entry)p_233190_);
        this.screen.updateButtonStatus(p_233190_ != null && p_233190_.isSelectable());
    }

    protected void m_6778_(AbstractSelectionList.SelectionDirection p_101673_) {
        this.m_93464_(p_101673_, Entry::isSelectable);
    }

    public Optional<WorldListEntry> getSelectedOpt() {
        Entry worldselectionlist$entry = (Entry)this.m_93511_();
        if (worldselectionlist$entry instanceof WorldListEntry) {
            WorldListEntry worldselectionlist$worldlistentry = (WorldListEntry)worldselectionlist$entry;
            return Optional.of(worldselectionlist$worldlistentry);
        }
        return Optional.empty();
    }

    public BedrockSelectWorldScreen getScreen() {
        return this.screen;
    }

    public void m_142291_(NarrationElementOutput p_233188_) {
        if (this.m_6702_().contains(this.loadingHeader)) {
            this.loadingHeader.m_142291_(p_233188_);
        } else {
            super.m_142291_(p_233188_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LoadingHeader
    extends Entry {
        private static final Component LOADING_LABEL = Component.m_237115_((String)"selectWorld.loading_list");
        private final Minecraft minecraft;

        public LoadingHeader(Minecraft p_233222_) {
            this.minecraft = p_233222_;
        }

        public void m_6311_(PoseStack p_233225_, int p_233226_, int p_233227_, int p_233228_, int p_233229_, int p_233230_, int p_233231_, int p_233232_, boolean p_233233_, float p_233234_) {
            int i = (this.minecraft.f_91080_.f_96543_ - this.minecraft.f_91062_.m_92852_((FormattedText)LOADING_LABEL)) / 2;
            int j = p_233227_ + (p_233230_ - 9) / 2;
            this.minecraft.f_91062_.m_92889_(p_233225_, LOADING_LABEL, (float)i, (float)j, 0xFFFFFF);
            String s = LoadingDotsText.m_232744_((long)Util.m_137550_());
            int k = (this.minecraft.f_91080_.f_96543_ - this.minecraft.f_91062_.m_92895_(s)) / 2;
            int l = j + 9;
            this.minecraft.f_91062_.m_92883_(p_233225_, s, (float)k, (float)l, 0x808080);
        }

        public Component m_142172_() {
            return LOADING_LABEL;
        }

        @Override
        public boolean isSelectable() {
            return false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public final class WorldListEntry
    extends Entry
    implements AutoCloseable {
        private static final int ICON_WIDTH = 32;
        private static final int ICON_HEIGHT = 32;
        private static final int ICON_OVERLAY_X_JOIN = 0;
        private static final int ICON_OVERLAY_X_JOIN_WITH_NOTIFY = 32;
        private static final int ICON_OVERLAY_X_WARNING = 64;
        private static final int ICON_OVERLAY_X_ERROR = 96;
        private static final int ICON_OVERLAY_Y_UNSELECTED = 0;
        private static final int ICON_OVERLAY_Y_SELECTED = 32;
        private final Minecraft minecraft;
        private final BedrockSelectWorldScreen screen;
        private final LevelSummary summary;
        private final ResourceLocation iconLocation;
        @Nullable
        private Path iconFile;
        @Nullable
        private final DynamicTexture icon;
        private long lastClickTime;

        public WorldListEntry(BedrockWorldSelectionList p_101702_, LevelSummary p_101703_) {
            this.minecraft = p_101702_.f_93386_;
            this.screen = p_101702_.getScreen();
            this.summary = p_101703_;
            String s = p_101703_.m_78358_();
            this.iconLocation = new ResourceLocation("minecraft", "worlds/" + Util.m_137483_((String)s, ResourceLocation::m_135828_) + "/" + Hashing.sha1().hashUnencodedChars((CharSequence)s) + "/icon");
            this.iconFile = p_101703_.m_230875_();
            if (!Files.isRegularFile(this.iconFile, new LinkOption[0])) {
                this.iconFile = null;
            }
            this.icon = this.loadServerIcon();
        }

        public Component m_142172_() {
            MutableComponent component = Component.m_237110_((String)"narrator.select.world", (Object[])new Object[]{this.summary.m_78361_(), new Date(this.summary.m_78366_()), this.summary.m_78368_() ? Component.m_237115_((String)"gameMode.hardcore") : Component.m_237115_((String)("gameMode." + this.summary.m_78367_().m_46405_())), this.summary.m_78369_() ? Component.m_237115_((String)"selectWorld.cheats") : CommonComponents.f_237098_, this.summary.m_78370_()});
            MutableComponent component1 = this.summary.m_78375_() ? CommonComponents.m_178398_((Component)component, (Component)WORLD_LOCKED_TOOLTIP) : component;
            return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{component1});
        }

        public void m_6311_(PoseStack p_101721_, int p_101722_, int p_101723_, int p_101724_, int p_101725_, int p_101726_, int p_101727_, int p_101728_, boolean p_101729_, float p_101730_) {
            Object s = this.summary.m_78361_();
            String s1 = this.summary.m_78358_() + " (" + DATE_FORMAT.format(new Date(this.summary.m_78366_())) + ")";
            if (StringUtils.isEmpty((CharSequence)s)) {
                s = I18n.m_118938_((String)"selectWorld.world", (Object[])new Object[0]) + " " + (p_101722_ + 1);
            }
            Component component = this.summary.m_78376_();
            this.minecraft.f_91062_.m_92883_(p_101721_, (String)s, (float)(p_101724_ + 32 + 3), (float)(p_101723_ + 1), 0xFFFFFF);
            this.minecraft.f_91062_.m_92883_(p_101721_, s1, (float)(p_101724_ + 32 + 3), (float)(p_101723_ + 9 + 3), 0x808080);
            this.minecraft.f_91062_.m_92889_(p_101721_, component, (float)(p_101724_ + 32 + 3), (float)(p_101723_ + 9 + 9 + 3), 0x808080);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)(this.icon != null ? this.iconLocation : ICON_MISSING));
            RenderSystem.m_69478_();
            GuiComponent.m_93133_((PoseStack)p_101721_, (int)p_101724_, (int)p_101723_, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            RenderSystem.m_69461_();
            this.renderExperimentalWarning(p_101721_, p_101727_, p_101728_, p_101723_, p_101724_);
            if (((Boolean)this.minecraft.f_91066_.m_231828_().m_231551_()).booleanValue() || p_101729_) {
                int j;
                RenderSystem.m_157456_((int)0, (ResourceLocation)ICON_OVERLAY_LOCATION);
                GuiComponent.m_93172_((PoseStack)p_101721_, (int)p_101724_, (int)p_101723_, (int)(p_101724_ + 32), (int)(p_101723_ + 32), (int)-1601138544);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int i = p_101727_ - p_101724_;
                boolean flag = i < 32;
                int n = j = flag ? 32 : 0;
                if (this.summary.m_78375_()) {
                    GuiComponent.m_93133_((PoseStack)p_101721_, (int)p_101724_, (int)p_101723_, (float)96.0f, (float)j, (int)32, (int)32, (int)256, (int)256);
                    if (flag) {
                        this.screen.setToolTip(this.minecraft.f_91062_.m_92923_((FormattedText)WORLD_LOCKED_TOOLTIP, 175));
                    }
                } else if (this.summary.m_193020_()) {
                    GuiComponent.m_93133_((PoseStack)p_101721_, (int)p_101724_, (int)p_101723_, (float)96.0f, (float)j, (int)32, (int)32, (int)256, (int)256);
                    if (flag) {
                        this.screen.setToolTip(this.minecraft.f_91062_.m_92923_((FormattedText)WORLD_REQUIRES_CONVERSION, 175));
                    }
                } else if (this.summary.m_78372_()) {
                    GuiComponent.m_93133_((PoseStack)p_101721_, (int)p_101724_, (int)p_101723_, (float)32.0f, (float)j, (int)32, (int)32, (int)256, (int)256);
                    if (this.summary.m_78373_()) {
                        GuiComponent.m_93133_((PoseStack)p_101721_, (int)p_101724_, (int)p_101723_, (float)96.0f, (float)j, (int)32, (int)32, (int)256, (int)256);
                        if (flag) {
                            this.screen.setToolTip((List<FormattedCharSequence>)ImmutableList.of((Object)FROM_NEWER_TOOLTIP_1.m_7532_(), (Object)FROM_NEWER_TOOLTIP_2.m_7532_()));
                        }
                    } else if (!SharedConstants.m_183709_().isStable()) {
                        GuiComponent.m_93133_((PoseStack)p_101721_, (int)p_101724_, (int)p_101723_, (float)64.0f, (float)j, (int)32, (int)32, (int)256, (int)256);
                        if (flag) {
                            this.screen.setToolTip((List<FormattedCharSequence>)ImmutableList.of((Object)SNAPSHOT_TOOLTIP_1.m_7532_(), (Object)SNAPSHOT_TOOLTIP_2.m_7532_()));
                        }
                    }
                } else {
                    GuiComponent.m_93133_((PoseStack)p_101721_, (int)p_101724_, (int)p_101723_, (float)0.0f, (float)j, (int)32, (int)32, (int)256, (int)256);
                }
            }
        }

        public boolean m_6375_(double p_101706_, double p_101707_, int p_101708_) {
            if (this.summary.m_164916_()) {
                return true;
            }
            BedrockWorldSelectionList.this.setSelected(this);
            this.screen.updateButtonStatus(BedrockWorldSelectionList.this.getSelectedOpt().isPresent());
            if (p_101706_ - (double)BedrockWorldSelectionList.this.m_5747_() <= 32.0) {
                this.joinWorld();
                return true;
            }
            if (Util.m_137550_() - this.lastClickTime < 250L) {
                this.joinWorld();
                return true;
            }
            this.lastClickTime = Util.m_137550_();
            return false;
        }

        public void joinWorld() {
            if (!this.summary.m_164916_()) {
                LevelSummary.BackupStatus levelsummary$backupstatus = this.summary.m_164914_();
                if (levelsummary$backupstatus.m_164931_()) {
                    String s = "selectWorld.backupQuestion." + levelsummary$backupstatus.m_164933_();
                    String s1 = "selectWorld.backupWarning." + levelsummary$backupstatus.m_164933_();
                    MutableComponent mutablecomponent = Component.m_237115_((String)s);
                    if (levelsummary$backupstatus.m_164932_()) {
                        mutablecomponent.m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED});
                    }
                    MutableComponent component = Component.m_237110_((String)s1, (Object[])new Object[]{this.summary.m_78370_(), SharedConstants.m_183709_().getName()});
                    this.minecraft.m_91152_((Screen)new BackupConfirmScreen((Screen)this.screen, (p_101736_, p_101737_) -> {
                        if (p_101736_) {
                            String s2 = this.summary.m_78358_();
                            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.minecraft.m_91392_().m_78260_(s2);){
                                EditWorldScreen.m_101258_((LevelStorageSource.LevelStorageAccess)levelstoragesource$levelstorageaccess);
                            }
                            catch (IOException ioexception) {
                                SystemToast.m_94852_((Minecraft)this.minecraft, (String)s2);
                                LOGGER.error("Failed to backup level {}", (Object)s2, (Object)ioexception);
                            }
                        }
                        this.loadWorld();
                    }, (Component)mutablecomponent, (Component)component, false));
                } else if (this.summary.m_78373_()) {
                    this.minecraft.m_91152_((Screen)new ConfirmScreen(p_101741_ -> {
                        if (p_101741_) {
                            try {
                                this.loadWorld();
                            }
                            catch (Exception exception) {
                                LOGGER.error("Failure to open 'future world'", (Throwable)exception);
                                this.minecraft.m_91152_((Screen)new AlertScreen(() -> this.minecraft.m_91152_((Screen)this.screen), (Component)Component.m_237115_((String)"selectWorld.futureworld.error.title"), (Component)Component.m_237115_((String)"selectWorld.futureworld.error.text")));
                            }
                        } else {
                            this.minecraft.m_91152_((Screen)this.screen);
                        }
                    }, (Component)Component.m_237115_((String)"selectWorld.versionQuestion"), (Component)Component.m_237110_((String)"selectWorld.versionWarning", (Object[])new Object[]{this.summary.m_78370_()}), (Component)Component.m_237115_((String)"selectWorld.versionJoinButton"), CommonComponents.f_130656_));
                } else {
                    this.loadWorld();
                }
            }
        }

        public void deleteWorld() {
            this.minecraft.m_91152_((Screen)new ConfirmScreen(p_170322_ -> {
                if (p_170322_) {
                    this.minecraft.m_91152_((Screen)new ProgressScreen(true));
                    this.doDeleteWorld();
                }
                this.minecraft.m_91152_((Screen)this.screen);
            }, (Component)Component.m_237115_((String)"selectWorld.deleteQuestion"), (Component)Component.m_237110_((String)"selectWorld.deleteWarning", (Object[])new Object[]{this.summary.m_78361_()}), (Component)Component.m_237115_((String)"selectWorld.deleteButton"), CommonComponents.f_130656_));
        }

        public void doDeleteWorld() {
            LevelStorageSource levelstoragesource = this.minecraft.m_91392_();
            String s = this.summary.m_78358_();
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = levelstoragesource.m_78260_(s);){
                levelstoragesource$levelstorageaccess.m_78311_();
            }
            catch (IOException ioexception) {
                SystemToast.m_94866_((Minecraft)this.minecraft, (String)s);
                LOGGER.error("Failed to delete world {}", (Object)s, (Object)ioexception);
            }
            BedrockWorldSelectionList.this.reloadLevels(this.screen.getFilterSupplier());
        }

        public void editWorld() {
            this.queueLoadScreen();
            String s = this.summary.m_78358_();
            try {
                LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.minecraft.m_91392_().m_78260_(s);
                this.minecraft.m_91152_((Screen)new EditWorldScreen(p_233244_ -> {
                    try {
                        levelstoragesource$levelstorageaccess.close();
                    }
                    catch (IOException ioexception1) {
                        LOGGER.error("Failed to unlock level {}", (Object)s, (Object)ioexception1);
                    }
                    if (p_233244_) {
                        BedrockWorldSelectionList.this.reloadLevels(this.screen.getFilterSupplier());
                    }
                    this.minecraft.m_91152_((Screen)this.screen);
                }, levelstoragesource$levelstorageaccess));
            }
            catch (IOException ioexception) {
                SystemToast.m_94852_((Minecraft)this.minecraft, (String)s);
                LOGGER.error("Failed to access level {}", (Object)s, (Object)ioexception);
                BedrockWorldSelectionList.this.reloadLevels(this.screen.getFilterSupplier());
            }
        }

        public void recreateWorld() {
            this.queueLoadScreen();
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.minecraft.m_91392_().m_78260_(this.summary.m_78358_());
                 WorldStem worldstem = this.minecraft.m_231466_().m_233119_(levelstoragesource$levelstorageaccess, false);){
                WorldGenSettings worldgensettings = worldstem.f_206895_().m_5961_();
                Path path = CreateWorldScreen.m_100906_((Path)levelstoragesource$levelstorageaccess.m_78283_(LevelResource.f_78180_), (Minecraft)this.minecraft);
                if (worldgensettings.m_64670_()) {
                    this.minecraft.m_91152_((Screen)new ConfirmScreen(p_233240_ -> this.minecraft.m_91152_((Screen)(p_233240_ ? CreateWorldScreen.m_205426_((Screen)this.screen, (WorldStem)worldstem, (Path)path) : this.screen)), (Component)Component.m_237115_((String)"selectWorld.recreate.customized.title"), (Component)Component.m_237115_((String)"selectWorld.recreate.customized.text"), CommonComponents.f_130659_, CommonComponents.f_130656_));
                } else {
                    this.minecraft.m_91152_((Screen)CreateWorldScreen.m_205426_((Screen)this.screen, (WorldStem)worldstem, (Path)path));
                }
            }
            catch (Exception exception) {
                LOGGER.error("Unable to recreate world", (Throwable)exception);
                this.minecraft.m_91152_((Screen)new AlertScreen(() -> this.minecraft.m_91152_((Screen)this.screen), (Component)Component.m_237115_((String)"selectWorld.recreate.error.title"), (Component)Component.m_237115_((String)"selectWorld.recreate.error.text")));
            }
        }

        private void loadWorld() {
            this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            if (this.minecraft.m_91392_().m_78255_(this.summary.m_78358_())) {
                this.queueLoadScreen();
                this.minecraft.m_231466_().m_233133_((Screen)this.screen, this.summary.m_78358_());
            }
        }

        private void queueLoadScreen() {
            this.minecraft.m_91346_((Screen)new GenericDirtMessageScreen((Component)Component.m_237115_((String)"selectWorld.data_read")));
        }

        @Nullable
        private DynamicTexture loadServerIcon() {
            boolean flag;
            boolean bl = flag = this.iconFile != null && Files.isRegularFile(this.iconFile, new LinkOption[0]);
            if (flag) {
                try {
                    DynamicTexture dynamictexture1;
                    try (InputStream inputstream = Files.newInputStream(this.iconFile, new OpenOption[0]);){
                        NativeImage nativeimage = NativeImage.m_85058_((InputStream)inputstream);
                        Validate.validState((nativeimage.m_84982_() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                        Validate.validState((nativeimage.m_85084_() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                        DynamicTexture dynamictexture = new DynamicTexture(nativeimage);
                        this.minecraft.m_91097_().m_118495_(this.iconLocation, (AbstractTexture)dynamictexture);
                        dynamictexture1 = dynamictexture;
                    }
                    return dynamictexture1;
                }
                catch (Throwable throwable2) {
                    LOGGER.error("Invalid icon for world {}", (Object)this.summary.m_78358_(), (Object)throwable2);
                    this.iconFile = null;
                    return null;
                }
            }
            this.minecraft.m_91097_().m_118513_(this.iconLocation);
            return null;
        }

        @Override
        public void close() {
            if (this.icon != null) {
                this.icon.close();
            }
        }

        public String getLevelName() {
            return this.summary.m_78361_();
        }

        @Override
        public boolean isSelectable() {
            return !this.summary.m_164916_();
        }

        private void renderExperimentalWarning(PoseStack stack, int mouseX, int mouseY, int top, int left) {
            if (this.summary.isExperimental()) {
                int leftStart = left + BedrockWorldSelectionList.this.m_5759_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)FORGE_EXPERIMENTAL_WARNING_ICON);
                GuiComponent.m_93133_((PoseStack)stack, (int)(leftStart - 36), (int)top, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
                RenderSystem.m_157456_((int)0, (ResourceLocation)(this.icon != null ? this.iconLocation : ICON_MISSING));
                if (BedrockWorldSelectionList.this.m_93412_(mouseX, mouseY) == this && mouseX > leftStart - 36 && mouseX < leftStart) {
                    List tooltip = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237115_((String)"forge.experimentalsettings.tooltip"), 200);
                    BedrockWorldSelectionList.this.screen.m_96617_(stack, tooltip, mouseX, mouseY);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry>
    implements AutoCloseable {
        public abstract boolean isSelectable();

        @Override
        public void close() {
        }
    }
}

