/*
 * Decompiled with CFR 0.152.
 */
package net.grupa_tkd.better_minecraft.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.grupa_tkd.better_minecraft.entity.Stalker;
import net.minecraft.client.animation.definitions.WardenAnimation;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class StalkerModel<T extends Stalker>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("better_minecraft", "stalkermodel"), "main");
    private static final float DEFAULT_ARM_X_Y = 13.0f;
    private static final float DEFAULT_ARM_Z = 1.0f;
    public final ModelPart body;
    public final ModelPart left_arm;
    public final ModelPart right_arm;
    public final ModelPart left_leg;
    public final ModelPart right_leg;
    public final ModelPart head;

    public StalkerModel(ModelPart root) {
        super(RenderType::m_110458_);
        this.body = root.m_171324_("body");
        this.left_arm = root.m_171324_("left_arm");
        this.right_arm = root.m_171324_("right_arm");
        this.left_leg = root.m_171324_("left_leg");
        this.right_leg = root.m_171324_("right_leg");
        this.head = root.m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r1 = body.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, 15.0f, -3.0f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-3.1416f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = body.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(3.0f, -30.0f, -3.0f, 4.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-3.0f, -30.0f, -3.0f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-7.0f, -30.0f, -3.0f, 4.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)7.0f, (float)-6.0f, (float)0.0f));
        PartDefinition cube_r3 = left_arm.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(20, 48).m_171488_(-6.0f, 0.0f, -3.0f, 6.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-7.0f, (float)-3.0f, (float)0.0f));
        PartDefinition cube_r4 = right_arm.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(26, 21).m_171488_(0.0f, 1.0f, -3.0f, 6.0f, 21.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.0f, (float)9.0f, (float)0.0f));
        PartDefinition cube_r5 = left_leg.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(44, 42).m_171488_(-4.0f, 0.0f, -3.0f, 7.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)9.0f, (float)0.0f));
        PartDefinition cube_r6 = right_leg.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-3.0f, 0.0f, -3.0f, 7.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(112, 0).m_171488_(-7.0f, -19.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(112, 0).m_171488_(4.0f, -21.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-6.0f, (float)0.0f));
        PartDefinition Glowa = head.m_171599_("Glowa", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-4.0f, -25.0f, -3.0f, 7.0f, 25.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition bb_main = body.m_171599_("bb_main", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -21.0f, -2.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(1.0f, -21.0f, -2.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(1.0f, -26.0f, -2.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-2.0f, -26.0f, -2.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-3.0f, -23.0f, -2.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(1.0f, -23.0f, -2.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(1.0f, -21.0f, 1.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-2.0f, -21.0f, 1.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-2.0f, -26.0f, 1.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(1.0f, -26.0f, 1.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(1.0f, -23.0f, 1.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-3.0f, -23.0f, 1.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_arm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_arm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.body;
    }

    public void setupAnim(T p_233531_, float p_233532_, float p_233533_, float p_233534_, float p_233535_, float p_233536_) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        float f = p_233534_ - (float)((Stalker)((Object)p_233531_)).f_19797_;
        this.animateHeadLookTarget(p_233535_, p_233536_);
        this.animateWalk(p_233532_, p_233533_);
        this.animateIdlePose(p_233534_);
        this.m_233381_(((Stalker)((Object)p_233531_)).f_219313_, WardenAnimation.f_232347_, p_233534_);
        this.m_233381_(((Stalker)((Object)p_233531_)).f_219314_, WardenAnimation.f_232348_, p_233534_);
        this.m_233381_(((Stalker)((Object)p_233531_)).f_219347_, WardenAnimation.f_232344_, p_233534_);
        this.m_233381_(((Stalker)((Object)p_233531_)).f_219346_, WardenAnimation.f_232343_, p_233534_);
        this.m_233381_(((Stalker)((Object)p_233531_)).f_219312_, WardenAnimation.f_232345_, p_233534_);
        this.m_233381_(((Stalker)((Object)p_233531_)).f_219316_, WardenAnimation.f_232346_, p_233534_);
    }

    private void animateHeadLookTarget(float p_233517_, float p_233518_) {
        this.head.f_104203_ = p_233518_ * ((float)Math.PI / 180);
        this.head.f_104204_ = p_233517_ * ((float)Math.PI / 180);
    }

    private void animateIdlePose(float p_233515_) {
        float f = p_233515_ * 0.1f;
        float f1 = Mth.m_14089_((float)f);
        float f2 = Mth.m_14031_((float)f);
        this.head.f_104205_ += 0.06f * f1;
        this.head.f_104203_ += 0.06f * f2;
        this.body.f_104205_ += 0.025f * f2;
        this.body.f_104203_ += 0.025f * f1;
    }

    private void animateWalk(float p_233539_, float p_233540_) {
        float f = Math.min(0.5f, 3.0f * p_233540_);
        float f1 = p_233539_ * 0.8662f;
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Math.min(0.35f, f);
        this.head.f_104205_ += 0.3f * f3 * f;
        this.head.f_104203_ += 1.2f * Mth.m_14089_((float)(f1 + 1.5707964f)) * f4;
        this.body.f_104205_ = 0.1f * f3 * f;
        this.body.f_104203_ = 1.0f * f2 * f4;
        this.left_leg.f_104203_ = 1.0f * f2 * f;
        this.right_leg.f_104203_ = 1.0f * Mth.m_14089_((float)(f1 + (float)Math.PI)) * f;
        this.left_arm.f_104203_ = -(0.8f * f2 * f);
        this.left_arm.f_104205_ = 0.0f;
        this.right_arm.f_104203_ = -(0.8f * f3 * f);
        this.right_arm.f_104205_ = 0.0f;
        this.resetArmPoses();
    }

    private void resetArmPoses() {
        this.left_arm.f_104204_ = 0.0f;
        this.left_arm.f_104202_ = 1.0f;
        this.left_arm.f_104200_ = 7.0f;
        this.left_arm.f_104201_ = -7.0f;
        this.right_arm.f_104204_ = 0.0f;
        this.right_arm.f_104202_ = 1.0f;
        this.right_arm.f_104200_ = -7.0f;
        this.right_arm.f_104201_ = -7.0f;
    }
}

