/*
 * Decompiled with CFR 0.152.
 */
package net.grupa_tkd.better_minecraft.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModSignRenderer
implements BlockEntityRenderer<SignBlockEntity> {
    public static final int MAX_LINE_WIDTH = 90;
    private static final int LINE_HEIGHT = 10;
    private static final String STICK = "stick";
    private static final int BLACK_TEXT_OUTLINE_COLOR = -988212;
    private static final int OUTLINE_RENDER_DISTANCE = Mth.m_144944_((int)16);
    private final Map<WoodType, SignModel> signModels = (Map)WoodType.m_61843_().collect(ImmutableMap.toImmutableMap(p_173645_ -> p_173645_, p_173651_ -> new SignModel(p_173636_.m_173582_(ModelLayers.m_171291_((WoodType)p_173651_)))));
    private final Font font;

    public ModSignRenderer(BlockEntityRendererProvider.Context p_173636_) {
        this.font = p_173636_.m_173586_();
    }

    public void render(SignBlockEntity p_112497_, float p_112498_, PoseStack p_112499_, MultiBufferSource p_112500_, int p_112501_, int p_112502_) {
        int l;
        boolean flag;
        int k;
        BlockState blockstate = p_112497_.m_58900_();
        p_112499_.m_85836_();
        float f = 0.6666667f;
        WoodType woodtype = ModSignRenderer.getWoodType(blockstate.m_60734_());
        SignModel signrenderer$signmodel = this.signModels.get(woodtype);
        if (blockstate.m_60734_() instanceof StandingSignBlock) {
            p_112499_.m_85837_(0.5, 0.5, 0.5);
            float f1 = -((float)((Integer)blockstate.m_61143_((Property)StandingSignBlock.f_56987_) * 360) / 16.0f);
            p_112499_.m_85845_(Vector3f.f_122225_.m_122240_(f1));
            signrenderer$signmodel.stick.f_104207_ = true;
        } else {
            p_112499_.m_85837_(0.5, 0.5, 0.5);
            float f4 = -((Direction)blockstate.m_61143_((Property)WallSignBlock.f_58064_)).m_122435_();
            p_112499_.m_85845_(Vector3f.f_122225_.m_122240_(f4));
            p_112499_.m_85837_(0.0, -0.3125, -0.4375);
            signrenderer$signmodel.stick.f_104207_ = false;
        }
        p_112499_.m_85836_();
        p_112499_.m_85841_(0.6666667f, -0.6666667f, -0.6666667f);
        Material material = Sheets.m_173381_((WoodType)woodtype);
        VertexConsumer vertexconsumer = material.m_119194_(p_112500_, arg_0 -> ((SignModel)signrenderer$signmodel).m_103119_(arg_0));
        signrenderer$signmodel.root.m_104301_(p_112499_, vertexconsumer, p_112501_, p_112502_);
        p_112499_.m_85849_();
        float f2 = 0.010416667f;
        p_112499_.m_85837_(0.0, 0.3333333432674408, 0.046666666865348816);
        p_112499_.m_85841_(0.010416667f, -0.010416667f, 0.010416667f);
        int i = ModSignRenderer.getDarkColor(p_112497_);
        int j = 20;
        FormattedCharSequence[] aformattedcharsequence = p_112497_.m_155717_(Minecraft.m_91087_().m_167974_(), p_173653_ -> {
            List list = this.font.m_92923_((FormattedText)p_173653_, 90);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        if (p_112497_.m_155727_()) {
            k = p_112497_.m_59753_().m_41071_();
            flag = ModSignRenderer.isOutlineVisible(p_112497_, k);
            l = 0xF000F0;
        } else {
            k = i;
            flag = false;
            l = p_112501_;
        }
        for (int i1 = 0; i1 < 4; ++i1) {
            FormattedCharSequence formattedcharsequence = aformattedcharsequence[i1];
            float f3 = -this.font.m_92724_(formattedcharsequence) / 2;
            if (flag) {
                this.font.m_168645_(formattedcharsequence, f3, (float)(i1 * 10 - 20), k, i, p_112499_.m_85850_().m_85861_(), p_112500_, l);
                continue;
            }
            this.font.m_92733_(formattedcharsequence, f3, (float)(i1 * 10 - 20), k, false, p_112499_.m_85850_().m_85861_(), p_112500_, false, 0, l);
        }
        p_112499_.m_85849_();
    }

    private static boolean isOutlineVisible(SignBlockEntity p_173642_, int p_173643_) {
        if (p_173643_ == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localplayer = minecraft.f_91074_;
        if (localplayer != null && minecraft.f_91066_.m_92176_().m_90612_() && localplayer.m_150108_()) {
            return true;
        }
        Entity entity = minecraft.m_91288_();
        return entity != null && entity.m_20238_(Vec3.m_82512_((Vec3i)p_173642_.m_58899_())) < (double)OUTLINE_RENDER_DISTANCE;
    }

    private static int getDarkColor(SignBlockEntity p_173640_) {
        int i = p_173640_.m_59753_().m_41071_();
        double d0 = 0.4;
        int j = (int)((double)NativeImage.m_85085_((int)i) * 0.4);
        int k = (int)((double)NativeImage.m_85103_((int)i) * 0.4);
        int l = (int)((double)NativeImage.m_85119_((int)i) * 0.4);
        return i == DyeColor.BLACK.m_41071_() && p_173640_.m_155727_() ? -988212 : NativeImage.m_84992_((int)0, (int)l, (int)k, (int)j);
    }

    public static WoodType getWoodType(Block p_173638_) {
        WoodType woodtype = p_173638_ instanceof SignBlock ? ((SignBlock)p_173638_).m_56297_() : WoodType.f_61830_;
        return woodtype;
    }

    public static SignModel createSignModel(EntityModelSet p_173647_, WoodType p_173648_) {
        return new SignModel(p_173647_.m_171103_(ModelLayers.m_171291_((WoodType)p_173648_)));
    }

    public static LayerDefinition createSignLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("sign", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-12.0f, -14.0f, -1.0f, 24.0f, 12.0f, 2.0f), PartPose.f_171404_);
        partdefinition.m_171599_(STICK, CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-1.0f, -2.0f, -1.0f, 2.0f, 14.0f, 2.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class SignModel
    extends Model {
        public final ModelPart root;
        public final ModelPart stick;

        public SignModel(ModelPart p_173657_) {
            super(RenderType::m_110458_);
            this.root = p_173657_;
            this.stick = p_173657_.m_171324_(ModSignRenderer.STICK);
        }

        public void m_7695_(PoseStack p_112510_, VertexConsumer p_112511_, int p_112512_, int p_112513_, float p_112514_, float p_112515_, float p_112516_, float p_112517_) {
            this.root.m_104306_(p_112510_, p_112511_, p_112512_, p_112513_, p_112514_, p_112515_, p_112516_, p_112517_);
        }
    }
}

