/*
 * Decompiled with CFR 0.152.
 */
package net.grupa_tkd.better_minecraft.client.renderer;

import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.grupa_tkd.better_minecraft.block.ModBlocks;
import net.grupa_tkd.better_minecraft.block.entity.ModTrappedChestBlockEntity;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.ChestType;

public class ModTrappedChestRenderer<T extends ModTrappedChestBlockEntity>
extends ChestRenderer<T> {
    public static final Map<Block, EnumMap<ChestType, Material>> MATERIALS;

    public ModTrappedChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected Material getMaterial(T blockEntity, ChestType chestType) {
        EnumMap<ChestType, Material> b = MATERIALS.get(blockEntity.m_58900_().m_60734_());
        if (b == null) {
            return super.getMaterial(blockEntity, chestType);
        }
        Material material = b.get(chestType);
        return material != null ? material : super.getMaterial(blockEntity, chestType);
    }

    private static EnumMap<ChestType, Material> chestMaterial(String type) {
        EnumMap<ChestType, Material> map = new EnumMap<ChestType, Material>(ChestType.class);
        map.put(ChestType.SINGLE, new Material(Sheets.f_110740_, new ResourceLocation("better_minecraft:entity/chest/" + type + "/" + type)));
        map.put(ChestType.LEFT, new Material(Sheets.f_110740_, new ResourceLocation("better_minecraft:entity/chest/" + type + "/left")));
        map.put(ChestType.RIGHT, new Material(Sheets.f_110740_, new ResourceLocation("better_minecraft:entity/chest/" + type + "/right")));
        return map;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)((Block)ModBlocks.TRAPPED_BLOGRE_CHEST.get()), ModTrappedChestRenderer.chestMaterial("trapped_blogre"));
        builder.put((Object)((Block)ModBlocks.TRAPPED_REDIGRE_CHEST.get()), ModTrappedChestRenderer.chestMaterial("trapped_redigre"));
        builder.put((Object)((Block)ModBlocks.TRAPPED_FLONRE_CHEST.get()), ModTrappedChestRenderer.chestMaterial("trapped_flonre"));
        builder.put((Object)((Block)ModBlocks.TRAPPED_CHERRY_CHEST.get()), ModTrappedChestRenderer.chestMaterial("trapped_cherry"));
        builder.put((Object)((Block)ModBlocks.TRAPPED_FIRSUN_CHEST.get()), ModTrappedChestRenderer.chestMaterial("trapped_firsun"));
        MATERIALS = builder.build();
        ModelBakery.f_119234_.addAll(MATERIALS.values().stream().flatMap(e -> e.values().stream()).collect(Collectors.toList()));
    }
}

