/*
 * Decompiled with CFR 0.152.
 */
package net.grupa_tkd.better_minecraft.data.worldgen.features;

import com.mojang.serialization.Codec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.grupa_tkd.better_minecraft.ModTags;
import net.grupa_tkd.better_minecraft.block.ModBlocks;
import net.grupa_tkd.better_minecraft.data.worldgen.features.ExotelDripstoneUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.LargeDripstoneConfiguration;
import net.minecraft.world.phys.Vec3;

public class ExotelLargeDripstoneFeature
extends Feature<LargeDripstoneConfiguration> {
    public ExotelLargeDripstoneFeature(Codec<LargeDripstoneConfiguration> p_159960_) {
        super(p_159960_);
    }

    public boolean m_142674_(FeaturePlaceContext<LargeDripstoneConfiguration> p_159967_) {
        WorldGenLevel worldgenlevel = p_159967_.m_159774_();
        BlockPos blockpos = p_159967_.m_159777_();
        LargeDripstoneConfiguration largedripstoneconfiguration = (LargeDripstoneConfiguration)p_159967_.m_159778_();
        RandomSource random = p_159967_.m_225041_();
        if (!ExotelDripstoneUtils.isEmptyOrWater((LevelAccessor)worldgenlevel, blockpos)) {
            return false;
        }
        Optional optional = Column.m_158175_((LevelSimulatedReader)worldgenlevel, (BlockPos)blockpos, (int)largedripstoneconfiguration.f_160945_, ExotelDripstoneUtils::isEmptyOrWater, ExotelDripstoneUtils::isDripstoneBaseOrLava);
        if (optional.isPresent() && optional.get() instanceof Column.Range) {
            Column.Range column$range = (Column.Range)optional.get();
            if (column$range.m_158214_() < 4) {
                return false;
            }
            int i = (int)((float)column$range.m_158214_() * largedripstoneconfiguration.f_160948_);
            int j = Mth.m_14045_((int)i, (int)largedripstoneconfiguration.f_160946_.m_142739_(), (int)largedripstoneconfiguration.f_160946_.m_142737_());
            int k = Mth.m_216287_((RandomSource)random, (int)largedripstoneconfiguration.f_160946_.m_142739_(), (int)j);
            LargeDripstone largedripstonefeature$largedripstone = ExotelLargeDripstoneFeature.makeDripstone(blockpos.m_175288_(column$range.m_158212_() - 1), false, random, k, largedripstoneconfiguration.f_160949_, largedripstoneconfiguration.f_160947_);
            LargeDripstone largedripstonefeature$largedripstone1 = ExotelLargeDripstoneFeature.makeDripstone(blockpos.m_175288_(column$range.m_158213_() + 1), true, random, k, largedripstoneconfiguration.f_160950_, largedripstoneconfiguration.f_160947_);
            WindOffsetter largedripstonefeature$windoffsetter = largedripstonefeature$largedripstone.isSuitableForWind(largedripstoneconfiguration) && largedripstonefeature$largedripstone1.isSuitableForWind(largedripstoneconfiguration) ? new WindOffsetter(blockpos.m_123342_(), random, largedripstoneconfiguration.f_160951_) : WindOffsetter.noWind();
            boolean flag = largedripstonefeature$largedripstone.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldgenlevel, largedripstonefeature$windoffsetter);
            boolean flag1 = largedripstonefeature$largedripstone1.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldgenlevel, largedripstonefeature$windoffsetter);
            if (flag) {
                largedripstonefeature$largedripstone.placeBlocks(worldgenlevel, random, largedripstonefeature$windoffsetter);
            }
            if (flag1) {
                largedripstonefeature$largedripstone1.placeBlocks(worldgenlevel, random, largedripstonefeature$windoffsetter);
            }
            return true;
        }
        return false;
    }

    private static LargeDripstone makeDripstone(BlockPos p_197109_, boolean p_197110_, RandomSource p_197111_, int p_197112_, FloatProvider p_197113_, FloatProvider p_197114_) {
        return new LargeDripstone(p_197109_, p_197110_, p_197112_, p_197113_.m_214084_(p_197111_), p_197114_.m_214084_(p_197111_));
    }

    private void placeDebugMarkers(WorldGenLevel p_159962_, BlockPos p_159963_, Column.Range p_159964_, WindOffsetter p_159965_) {
        p_159962_.m_7731_(p_159965_.offset(p_159963_.m_175288_(p_159964_.m_158212_() - 1)), Blocks.f_50090_.m_49966_(), 2);
        p_159962_.m_7731_(p_159965_.offset(p_159963_.m_175288_(p_159964_.m_158213_() + 1)), Blocks.f_50074_.m_49966_(), 2);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_159963_.m_175288_(p_159964_.m_158213_() + 2).m_122032_();
        while (blockpos$mutableblockpos.m_123342_() < p_159964_.m_158212_() - 1) {
            BlockPos blockpos = p_159965_.offset((BlockPos)blockpos$mutableblockpos);
            if (ExotelDripstoneUtils.isEmptyOrWater((LevelAccessor)p_159962_, blockpos) || p_159962_.m_8055_(blockpos).m_60713_((Block)ModBlocks.EXOTEL_DRIPSTONE_BLOCK.get())) {
                p_159962_.m_7731_(blockpos, Blocks.f_50318_.m_49966_(), 2);
            }
            blockpos$mutableblockpos.m_122173_(Direction.UP);
        }
    }

    static final class LargeDripstone {
        private BlockPos root;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        LargeDripstone(BlockPos p_197116_, boolean p_197117_, int p_197118_, double p_197119_, double p_197120_) {
            this.root = p_197116_;
            this.pointingUp = p_197117_;
            this.radius = p_197118_;
            this.bluntness = p_197119_;
            this.scale = p_197120_;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        private int getMinY() {
            return this.pointingUp ? this.root.m_123342_() : this.root.m_123342_() - this.getHeight();
        }

        private int getMaxY() {
            return !this.pointingUp ? this.root.m_123342_() : this.root.m_123342_() + this.getHeight();
        }

        boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(WorldGenLevel p_159990_, WindOffsetter p_159991_) {
            while (this.radius > 1) {
                BlockPos.MutableBlockPos blockpos$mutableblockpos = this.root.m_122032_();
                int i = Math.min(10, this.getHeight());
                for (int j = 0; j < i; ++j) {
                    if (p_159990_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60713_(Blocks.f_49991_)) {
                        return false;
                    }
                    if (ExotelDripstoneUtils.isCircleMostlyEmbeddedInStone(p_159990_, p_159991_.offset((BlockPos)blockpos$mutableblockpos), this.radius)) {
                        this.root = blockpos$mutableblockpos;
                        return true;
                    }
                    blockpos$mutableblockpos.m_122173_(this.pointingUp ? Direction.DOWN : Direction.UP);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float p_159988_) {
            return (int)ExotelDripstoneUtils.getDripstoneHeight(p_159988_, this.radius, this.scale, this.bluntness);
        }

        void placeBlocks(WorldGenLevel p_159993_, RandomSource p_159994_, WindOffsetter p_159995_) {
            for (int i = -this.radius; i <= this.radius; ++i) {
                block1: for (int j = -this.radius; j <= this.radius; ++j) {
                    int k;
                    float f = Mth.m_14116_((float)(i * i + j * j));
                    if (f > (float)this.radius || (k = this.getHeightAtRadius(f)) <= 0) continue;
                    if ((double)p_159994_.m_188501_() < 0.2) {
                        k = (int)((float)k * Mth.m_216283_((RandomSource)p_159994_, (float)0.8f, (float)1.0f));
                    }
                    BlockPos.MutableBlockPos blockpos$mutableblockpos = this.root.m_7918_(i, 0, j).m_122032_();
                    boolean flag = false;
                    int l = this.pointingUp ? p_159993_.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, blockpos$mutableblockpos.m_123341_(), blockpos$mutableblockpos.m_123343_()) : Integer.MAX_VALUE;
                    for (int i1 = 0; i1 < k && blockpos$mutableblockpos.m_123342_() < l; ++i1) {
                        BlockPos blockpos = p_159995_.offset((BlockPos)blockpos$mutableblockpos);
                        if (ExotelDripstoneUtils.isEmptyOrWaterOrLava((LevelAccessor)p_159993_, blockpos)) {
                            flag = true;
                            Block block = (Block)ModBlocks.EXOTEL_DRIPSTONE_BLOCK.get();
                            p_159993_.m_7731_(blockpos, block.m_49966_(), 2);
                        } else if (flag && p_159993_.m_8055_(blockpos).m_204336_(ModTags.BASE_STONE_EXOTEL)) continue block1;
                        blockpos$mutableblockpos.m_122173_(this.pointingUp ? Direction.UP : Direction.DOWN);
                    }
                }
            }
        }

        boolean isSuitableForWind(LargeDripstoneConfiguration p_159997_) {
            return this.radius >= p_159997_.f_160952_ && this.bluntness >= (double)p_159997_.f_160953_;
        }
    }

    static final class WindOffsetter {
        private final int originY;
        @Nullable
        private final Vec3 windSpeed;

        WindOffsetter(int p_160004_, RandomSource p_160005_, FloatProvider p_160006_) {
            this.originY = p_160004_;
            float f = p_160006_.m_214084_(p_160005_);
            float f1 = Mth.m_216283_((RandomSource)p_160005_, (float)0.0f, (float)((float)Math.PI));
            this.windSpeed = new Vec3((double)(Mth.m_14089_((float)f1) * f), 0.0, (double)(Mth.m_14031_((float)f1) * f));
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        static WindOffsetter noWind() {
            return new WindOffsetter();
        }

        BlockPos offset(BlockPos p_160009_) {
            if (this.windSpeed == null) {
                return p_160009_;
            }
            int i = this.originY - p_160009_.m_123342_();
            Vec3 vec3 = this.windSpeed.m_82490_((double)i);
            return p_160009_.m_7637_(vec3.f_82479_, 0.0, vec3.f_82481_);
        }
    }
}

