/*
 * Decompiled with CFR 0.152.
 */
package net.grupa_tkd.better_minecraft.entity;

import net.grupa_tkd.better_minecraft.block.ModBlocks;
import net.grupa_tkd.better_minecraft.entity.ModEntities;
import net.grupa_tkd.better_minecraft.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;

public class ModBoat
extends Boat {
    private static final EntityDataAccessor<Integer> BOAT_TYPE = SynchedEntityData.m_135353_(ModBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ModBoat(EntityType<? extends Boat> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
    }

    public ModBoat(Level worldIn, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)ModEntities.BOAT_ENTITY.get()), worldIn);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public Type getModBoatType() {
        return Type.byId((Integer)this.f_19804_.m_135370_(BOAT_TYPE));
    }

    protected void m_7840_(double p_38307_, boolean p_38308_, BlockState p_38309_, BlockPos p_38310_) {
        this.f_38281_ = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            if (p_38308_) {
                if (this.f_19789_ > 3.0f) {
                    if (this.f_38279_ != Boat.Status.ON_LAND) {
                        this.m_183634_();
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, DamageSource.f_19315_);
                    if (!this.f_19853_.f_46443_ && !this.m_213877_()) {
                        this.m_6074_();
                        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            for (int i = 0; i < 3; ++i) {
                                this.m_19998_((ItemLike)this.m_38387_().m_38434_());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.m_19998_((ItemLike)Items.f_42398_);
                            }
                        }
                    }
                }
                this.m_183634_();
            } else if (!this.f_19853_.m_6425_(this.m_20183_().m_7495_()).m_205070_(FluidTags.f_13131_) && p_38307_ < 0.0) {
                this.f_19789_ -= (float)p_38307_;
            }
        }
    }

    public Item m_38369_() {
        switch (this.getModBoatType()) {
            default: {
                return (Item)ModItems.BLOGRE_BOAT.get();
            }
            case REDIGRE: {
                return (Item)ModItems.REDIGRE_BOAT.get();
            }
            case FLONRE: {
                return (Item)ModItems.FLONRE_BOAT.get();
            }
            case CHERRY: {
                return (Item)ModItems.CHERRY_BOAT.get();
            }
            case FIRSUN: 
        }
        return (Item)ModItems.FIRSUN_BOAT.get();
    }

    public void setBoatType(Type boatType) {
        this.f_19804_.m_135381_(BOAT_TYPE, (Object)boatType.ordinal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOAT_TYPE, (Object)Type.BLOGRE.ordinal());
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128359_("Type", this.getModBoatType().getName());
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128425_("Type", 8)) {
            this.setBoatType(Type.getTypeFromString(compound.m_128461_("Type")));
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum Type {
        BLOGRE((Block)ModBlocks.BLOGRE_PLANKS.get(), "blogre"),
        REDIGRE((Block)ModBlocks.REDIGRE_PLANKS.get(), "redigre"),
        FLONRE((Block)ModBlocks.FLONRE_PLANKS.get(), "flonre"),
        CHERRY((Block)ModBlocks.CHERRY_PLANKS.get(), "cherry"),
        FIRSUN((Block)ModBlocks.FIRSUN_PLANKS.get(), "firsun");

        private final String name;
        private final Block block;

        private Type(Block block, String name) {
            this.name = name;
            this.block = block;
        }

        public String getName() {
            return this.name;
        }

        public Block asPlank() {
            return this.block;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            Type[] aModBoatEntity$type = Type.values();
            if (id < 0 || id >= aModBoatEntity$type.length) {
                id = 0;
            }
            return aModBoatEntity$type[id];
        }

        public static Type getTypeFromString(String nameIn) {
            Type[] boatTypeArray;
            for (Type type : boatTypeArray = Type.values()) {
                if (!type.getName().equals(nameIn)) continue;
                return type;
            }
            return boatTypeArray[0];
        }
    }
}

