/*
 * Decompiled with CFR 0.152.
 */
package net.grupa_tkd.better_minecraft.world.dimension;

import java.util.stream.Stream;
import net.grupa_tkd.better_minecraft.world.dimension.OreVeinifier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.TerrainProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class ExotelNoiseRouterData {
    public static final float GLOBAL_OFFSET = -0.50375f;
    private static final float ORE_THICKNESS = 0.08f;
    private static final double VEININESS_FREQUENCY = 1.5;
    private static final double NOODLE_SPACING_AND_STRAIGHTNESS = 1.5;
    private static final double SURFACE_DENSITY_THRESHOLD = 1.5625;
    private static final double CHEESE_NOISE_TARGET = -0.703125;
    public static final int ISLAND_CHUNK_DISTANCE = 64;
    public static final long ISLAND_CHUNK_DISTANCE_SQR = 4096L;
    private static final DensityFunction BLENDING_FACTOR = DensityFunctions.m_208264_((double)10.0);
    private static final DensityFunction BLENDING_JAGGEDNESS = DensityFunctions.m_208263_();
    private static final ResourceKey<DensityFunction> ZERO = ExotelNoiseRouterData.createKey("zero");
    private static final ResourceKey<DensityFunction> Y = ExotelNoiseRouterData.createKey("y");
    private static final ResourceKey<DensityFunction> SHIFT_X = ExotelNoiseRouterData.createKey("shift_x");
    private static final ResourceKey<DensityFunction> SHIFT_Z = ExotelNoiseRouterData.createKey("shift_z");
    private static final ResourceKey<DensityFunction> BASE_3D_NOISE_OVERWORLD = ExotelNoiseRouterData.createKey("overworld/base_3d_noise");
    private static final ResourceKey<DensityFunction> BASE_3D_NOISE_NETHER = ExotelNoiseRouterData.createKey("nether/base_3d_noise");
    private static final ResourceKey<DensityFunction> BASE_3D_NOISE_END = ExotelNoiseRouterData.createKey("end/base_3d_noise");
    public static final ResourceKey<DensityFunction> CONTINENTS = ExotelNoiseRouterData.createKey("overworld/continents");
    public static final ResourceKey<DensityFunction> EROSION = ExotelNoiseRouterData.createKey("overworld/erosion");
    public static final ResourceKey<DensityFunction> RIDGES = ExotelNoiseRouterData.createKey("overworld/ridges");
    public static final ResourceKey<DensityFunction> RIDGES_FOLDED = ExotelNoiseRouterData.createKey("overworld/ridges_folded");
    public static final ResourceKey<DensityFunction> OFFSET = ExotelNoiseRouterData.createKey("overworld/offset");
    public static final ResourceKey<DensityFunction> FACTOR = ExotelNoiseRouterData.createKey("overworld/factor");
    public static final ResourceKey<DensityFunction> JAGGEDNESS = ExotelNoiseRouterData.createKey("overworld/jaggedness");
    public static final ResourceKey<DensityFunction> DEPTH = ExotelNoiseRouterData.createKey("overworld/depth");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE = ExotelNoiseRouterData.createKey("overworld/sloped_cheese");
    public static final ResourceKey<DensityFunction> CONTINENTS_LARGE = ExotelNoiseRouterData.createKey("overworld_large_biomes/continents");
    public static final ResourceKey<DensityFunction> EROSION_LARGE = ExotelNoiseRouterData.createKey("overworld_large_biomes/erosion");
    private static final ResourceKey<DensityFunction> OFFSET_LARGE = ExotelNoiseRouterData.createKey("overworld_large_biomes/offset");
    private static final ResourceKey<DensityFunction> FACTOR_LARGE = ExotelNoiseRouterData.createKey("overworld_large_biomes/factor");
    private static final ResourceKey<DensityFunction> JAGGEDNESS_LARGE = ExotelNoiseRouterData.createKey("overworld_large_biomes/jaggedness");
    private static final ResourceKey<DensityFunction> DEPTH_LARGE = ExotelNoiseRouterData.createKey("overworld_large_biomes/depth");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE_LARGE = ExotelNoiseRouterData.createKey("overworld_large_biomes/sloped_cheese");
    private static final ResourceKey<DensityFunction> OFFSET_AMPLIFIED = ExotelNoiseRouterData.createKey("overworld_amplified/offset");
    private static final ResourceKey<DensityFunction> FACTOR_AMPLIFIED = ExotelNoiseRouterData.createKey("overworld_amplified/factor");
    private static final ResourceKey<DensityFunction> JAGGEDNESS_AMPLIFIED = ExotelNoiseRouterData.createKey("overworld_amplified/jaggedness");
    private static final ResourceKey<DensityFunction> DEPTH_AMPLIFIED = ExotelNoiseRouterData.createKey("overworld_amplified/depth");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE_AMPLIFIED = ExotelNoiseRouterData.createKey("overworld_amplified/sloped_cheese");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE_END = ExotelNoiseRouterData.createKey("end/sloped_cheese");
    private static final ResourceKey<DensityFunction> SPAGHETTI_ROUGHNESS_FUNCTION = ExotelNoiseRouterData.createKey("overworld/caves/spaghetti_roughness_function");
    private static final ResourceKey<DensityFunction> ENTRANCES = ExotelNoiseRouterData.createKey("overworld/caves/entrances");
    private static final ResourceKey<DensityFunction> NOODLE = ExotelNoiseRouterData.createKey("overworld/caves/noodle");
    private static final ResourceKey<DensityFunction> PILLARS = ExotelNoiseRouterData.createKey("overworld/caves/pillars");
    private static final ResourceKey<DensityFunction> SPAGHETTI_2D_THICKNESS_MODULATOR = ExotelNoiseRouterData.createKey("overworld/caves/spaghetti_2d_thickness_modulator");
    private static final ResourceKey<DensityFunction> SPAGHETTI_2D = ExotelNoiseRouterData.createKey("overworld/caves/spaghetti_2d");

    private static ResourceKey<DensityFunction> createKey(String p_209537_) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_211074_, (ResourceLocation)new ResourceLocation(p_209537_));
    }

    public static Holder<? extends DensityFunction> bootstrap(Registry<DensityFunction> p_224459_) {
        ExotelNoiseRouterData.register(p_224459_, ZERO, DensityFunctions.m_208263_());
        int i = DimensionType.f_156653_ * 2;
        int j = DimensionType.f_156652_ * 2;
        ExotelNoiseRouterData.register(p_224459_, Y, DensityFunctions.m_208266_((int)i, (int)j, (double)i, (double)j));
        DensityFunction densityfunction = ExotelNoiseRouterData.registerAndWrap(p_224459_, SHIFT_X, DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208373_((DensityFunction)DensityFunctions.m_208366_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189286_)))));
        DensityFunction densityfunction1 = ExotelNoiseRouterData.registerAndWrap(p_224459_, SHIFT_Z, DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208373_((DensityFunction)DensityFunctions.m_208378_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189286_)))));
        ExotelNoiseRouterData.register(p_224459_, BASE_3D_NOISE_OVERWORLD, (DensityFunction)BlendedNoise.m_230477_((double)0.25, (double)0.125, (double)80.0, (double)160.0, (double)8.0));
        ExotelNoiseRouterData.register(p_224459_, BASE_3D_NOISE_NETHER, (DensityFunction)BlendedNoise.m_230477_((double)0.25, (double)0.375, (double)80.0, (double)60.0, (double)8.0));
        ExotelNoiseRouterData.register(p_224459_, BASE_3D_NOISE_END, (DensityFunction)BlendedNoise.m_230477_((double)0.25, (double)0.25, (double)80.0, (double)160.0, (double)4.0));
        Holder<DensityFunction> holder = ExotelNoiseRouterData.register(p_224459_, CONTINENTS, DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208296_((DensityFunction)densityfunction, (DensityFunction)densityfunction1, (double)0.25, ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189279_))));
        Holder<DensityFunction> holder1 = ExotelNoiseRouterData.register(p_224459_, EROSION, DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208296_((DensityFunction)densityfunction, (DensityFunction)densityfunction1, (double)0.25, ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189280_))));
        DensityFunction densityfunction2 = ExotelNoiseRouterData.registerAndWrap(p_224459_, RIDGES, DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208296_((DensityFunction)densityfunction, (DensityFunction)densityfunction1, (double)0.25, ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189285_))));
        ExotelNoiseRouterData.register(p_224459_, RIDGES_FOLDED, ExotelNoiseRouterData.peaksAndValleys(densityfunction2));
        DensityFunction densityfunction3 = DensityFunctions.m_208368_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189255_), (double)1500.0, (double)0.0);
        ExotelNoiseRouterData.registerTerrainNoises(p_224459_, densityfunction3, holder, holder1, OFFSET, FACTOR, JAGGEDNESS, DEPTH, SLOPED_CHEESE, false);
        Holder<DensityFunction> holder2 = ExotelNoiseRouterData.register(p_224459_, CONTINENTS_LARGE, DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208296_((DensityFunction)densityfunction, (DensityFunction)densityfunction1, (double)0.25, ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189283_))));
        Holder<DensityFunction> holder3 = ExotelNoiseRouterData.register(p_224459_, EROSION_LARGE, DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208296_((DensityFunction)densityfunction, (DensityFunction)densityfunction1, (double)0.25, ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189284_))));
        ExotelNoiseRouterData.registerTerrainNoises(p_224459_, densityfunction3, holder2, holder3, OFFSET_LARGE, FACTOR_LARGE, JAGGEDNESS_LARGE, DEPTH_LARGE, SLOPED_CHEESE_LARGE, false);
        ExotelNoiseRouterData.registerTerrainNoises(p_224459_, densityfunction3, holder, holder1, OFFSET_AMPLIFIED, FACTOR_AMPLIFIED, JAGGEDNESS_AMPLIFIED, DEPTH_AMPLIFIED, SLOPED_CHEESE_AMPLIFIED, true);
        ExotelNoiseRouterData.register(p_224459_, SLOPED_CHEESE_END, DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208271_((long)0L), (DensityFunction)ExotelNoiseRouterData.getFunction(p_224459_, BASE_3D_NOISE_END)));
        ExotelNoiseRouterData.register(p_224459_, SPAGHETTI_ROUGHNESS_FUNCTION, ExotelNoiseRouterData.spaghettiRoughnessFunction());
        ExotelNoiseRouterData.register(p_224459_, SPAGHETTI_2D_THICKNESS_MODULATOR, DensityFunctions.m_208380_((DensityFunction)DensityFunctions.m_208336_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189297_), (double)2.0, (double)1.0, (double)-0.6, (double)-1.3)));
        ExotelNoiseRouterData.register(p_224459_, SPAGHETTI_2D, ExotelNoiseRouterData.spaghetti2D(p_224459_));
        ExotelNoiseRouterData.register(p_224459_, ENTRANCES, ExotelNoiseRouterData.entrances(p_224459_));
        ExotelNoiseRouterData.register(p_224459_, NOODLE, ExotelNoiseRouterData.noodle(p_224459_));
        return ExotelNoiseRouterData.register(p_224459_, PILLARS, ExotelNoiseRouterData.pillars());
    }

    private static void registerTerrainNoises(Registry<DensityFunction> p_224475_, DensityFunction p_224476_, Holder<DensityFunction> p_224477_, Holder<DensityFunction> p_224478_, ResourceKey<DensityFunction> p_224479_, ResourceKey<DensityFunction> p_224480_, ResourceKey<DensityFunction> p_224481_, ResourceKey<DensityFunction> p_224482_, ResourceKey<DensityFunction> p_224483_, boolean p_224484_) {
        DensityFunctions.Spline.Coordinate densityfunctions$spline$coordinate = new DensityFunctions.Spline.Coordinate(p_224477_);
        DensityFunctions.Spline.Coordinate densityfunctions$spline$coordinate1 = new DensityFunctions.Spline.Coordinate(p_224478_);
        DensityFunctions.Spline.Coordinate densityfunctions$spline$coordinate2 = new DensityFunctions.Spline.Coordinate(p_224475_.m_206081_(RIDGES));
        DensityFunctions.Spline.Coordinate densityfunctions$spline$coordinate3 = new DensityFunctions.Spline.Coordinate(p_224475_.m_206081_(RIDGES_FOLDED));
        DensityFunction densityfunction = ExotelNoiseRouterData.registerAndWrap(p_224475_, p_224479_, ExotelNoiseRouterData.splineWithBlending(DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-0.50375f), (DensityFunction)DensityFunctions.m_224020_((CubicSpline)TerrainProvider.m_236635_((ToFloatFunction)densityfunctions$spline$coordinate, (ToFloatFunction)densityfunctions$spline$coordinate1, (ToFloatFunction)densityfunctions$spline$coordinate3, (boolean)p_224484_))), DensityFunctions.m_208372_()));
        DensityFunction densityfunction1 = ExotelNoiseRouterData.registerAndWrap(p_224475_, p_224480_, ExotelNoiseRouterData.splineWithBlending(DensityFunctions.m_224020_((CubicSpline)TerrainProvider.m_236629_((ToFloatFunction)densityfunctions$spline$coordinate, (ToFloatFunction)densityfunctions$spline$coordinate1, (ToFloatFunction)densityfunctions$spline$coordinate2, (ToFloatFunction)densityfunctions$spline$coordinate3, (boolean)p_224484_)), BLENDING_FACTOR));
        DensityFunction densityfunction2 = ExotelNoiseRouterData.registerAndWrap(p_224475_, p_224482_, DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208266_((int)-64, (int)320, (double)1.5, (double)-1.5), (DensityFunction)densityfunction));
        DensityFunction densityfunction3 = ExotelNoiseRouterData.registerAndWrap(p_224475_, p_224481_, ExotelNoiseRouterData.splineWithBlending(DensityFunctions.m_224020_((CubicSpline)TerrainProvider.m_236642_((ToFloatFunction)densityfunctions$spline$coordinate, (ToFloatFunction)densityfunctions$spline$coordinate1, (ToFloatFunction)densityfunctions$spline$coordinate2, (ToFloatFunction)densityfunctions$spline$coordinate3, (boolean)p_224484_)), BLENDING_JAGGEDNESS));
        DensityFunction densityfunction4 = DensityFunctions.m_208363_((DensityFunction)densityfunction3, (DensityFunction)p_224476_.m_208232_());
        DensityFunction densityfunction5 = ExotelNoiseRouterData.noiseGradientDensity(densityfunction1, DensityFunctions.m_208293_((DensityFunction)densityfunction2, (DensityFunction)densityfunction4));
        ExotelNoiseRouterData.register(p_224475_, p_224483_, DensityFunctions.m_208293_((DensityFunction)densityfunction5, (DensityFunction)ExotelNoiseRouterData.getFunction(p_224475_, BASE_3D_NOISE_OVERWORLD)));
    }

    private static DensityFunction registerAndWrap(Registry<DensityFunction> p_224468_, ResourceKey<DensityFunction> p_224469_, DensityFunction p_224470_) {
        return new DensityFunctions.HolderHolder(BuiltinRegistries.m_206384_(p_224468_, p_224469_, (Object)p_224470_));
    }

    private static Holder<DensityFunction> register(Registry<DensityFunction> p_224499_, ResourceKey<DensityFunction> p_224500_, DensityFunction p_224501_) {
        return BuiltinRegistries.m_206384_(p_224499_, p_224500_, (Object)p_224501_);
    }

    private static Holder<NormalNoise.NoiseParameters> getNoise(ResourceKey<NormalNoise.NoiseParameters> p_209543_) {
        return BuiltinRegistries.f_194654_.m_206081_(p_209543_);
    }

    private static DensityFunction getFunction(Registry<DensityFunction> p_224465_, ResourceKey<DensityFunction> p_224466_) {
        return new DensityFunctions.HolderHolder(p_224465_.m_206081_(p_224466_));
    }

    private static DensityFunction peaksAndValleys(DensityFunction p_224438_) {
        return DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208293_((DensityFunction)p_224438_.m_208229_(), (DensityFunction)DensityFunctions.m_208264_((double)-0.6666666666666666)).m_208229_(), (DensityFunction)DensityFunctions.m_208264_((double)-0.3333333333333333)), (DensityFunction)DensityFunctions.m_208264_((double)-3.0));
    }

    public static float peaksAndValleys(float p_224436_) {
        return -(Math.abs(Math.abs(p_224436_) - 0.6666667f) - 0.33333334f) * 3.0f;
    }

    private static DensityFunction spaghettiRoughnessFunction() {
        DensityFunction densityfunction = DensityFunctions.m_208322_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189302_));
        DensityFunction densityfunction1 = DensityFunctions.m_208327_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189243_), (double)0.0, (double)-0.1);
        return DensityFunctions.m_208380_((DensityFunction)DensityFunctions.m_208363_((DensityFunction)densityfunction1, (DensityFunction)DensityFunctions.m_208293_((DensityFunction)densityfunction.m_208229_(), (DensityFunction)DensityFunctions.m_208264_((double)-0.4))));
    }

    private static DensityFunction entrances(Registry<DensityFunction> p_224514_) {
        DensityFunction densityfunction = DensityFunctions.m_208380_((DensityFunction)DensityFunctions.m_208368_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189300_), (double)2.0, (double)1.0));
        DensityFunction densityfunction1 = DensityFunctions.m_208327_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189301_), (double)-0.065, (double)-0.088);
        DensityFunction densityfunction2 = DensityFunctions.m_208315_((DensityFunction)densityfunction, ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189298_), (DensityFunctions.WeirdScaledSampler.RarityValueMapper)DensityFunctions.WeirdScaledSampler.RarityValueMapper.TYPE1);
        DensityFunction densityfunction3 = DensityFunctions.m_208315_((DensityFunction)densityfunction, ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189299_), (DensityFunctions.WeirdScaledSampler.RarityValueMapper)DensityFunctions.WeirdScaledSampler.RarityValueMapper.TYPE1);
        DensityFunction densityfunction4 = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208382_((DensityFunction)densityfunction2, (DensityFunction)densityfunction3), (DensityFunction)densityfunction1).m_208220_(-1.0, 1.0);
        DensityFunction densityfunction5 = ExotelNoiseRouterData.getFunction(p_224514_, SPAGHETTI_ROUGHNESS_FUNCTION);
        DensityFunction densityfunction6 = DensityFunctions.m_208368_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189244_), (double)0.75, (double)0.5);
        DensityFunction densityfunction7 = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208293_((DensityFunction)densityfunction6, (DensityFunction)DensityFunctions.m_208264_((double)0.37)), (DensityFunction)DensityFunctions.m_208266_((int)-10, (int)30, (double)0.3, (double)0.0));
        return DensityFunctions.m_208380_((DensityFunction)DensityFunctions.m_208375_((DensityFunction)densityfunction7, (DensityFunction)DensityFunctions.m_208293_((DensityFunction)densityfunction5, (DensityFunction)densityfunction4)));
    }

    private static DensityFunction noodle(Registry<DensityFunction> p_224516_) {
        DensityFunction densityfunction = ExotelNoiseRouterData.getFunction(p_224516_, Y);
        int i = -64;
        int j = -60;
        int k = 320;
        DensityFunction densityfunction1 = ExotelNoiseRouterData.yLimitedInterpolatable(densityfunction, DensityFunctions.m_208368_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189251_), (double)1.0, (double)1.0), -60, 320, -1);
        DensityFunction densityfunction2 = ExotelNoiseRouterData.yLimitedInterpolatable(densityfunction, DensityFunctions.m_208336_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189252_), (double)1.0, (double)1.0, (double)-0.05, (double)-0.1), -60, 320, 0);
        double d0 = 2.6666666666666665;
        DensityFunction densityfunction3 = ExotelNoiseRouterData.yLimitedInterpolatable(densityfunction, DensityFunctions.m_208368_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189253_), (double)2.6666666666666665, (double)2.6666666666666665), -60, 320, 0);
        DensityFunction densityfunction4 = ExotelNoiseRouterData.yLimitedInterpolatable(densityfunction, DensityFunctions.m_208368_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189254_), (double)2.6666666666666665, (double)2.6666666666666665), -60, 320, 0);
        DensityFunction densityfunction5 = DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)1.5), (DensityFunction)DensityFunctions.m_208382_((DensityFunction)densityfunction3.m_208229_(), (DensityFunction)densityfunction4.m_208229_()));
        return DensityFunctions.m_208287_((DensityFunction)densityfunction1, (double)-1000000.0, (double)0.0, (DensityFunction)DensityFunctions.m_208264_((double)64.0), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)densityfunction2, (DensityFunction)densityfunction5));
    }

    private static DensityFunction pillars() {
        double d0 = 25.0;
        double d1 = 0.3;
        DensityFunction densityfunction = DensityFunctions.m_208368_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189291_), (double)25.0, (double)0.3);
        DensityFunction densityfunction1 = DensityFunctions.m_208327_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189292_), (double)0.0, (double)-2.0);
        DensityFunction densityfunction2 = DensityFunctions.m_208327_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189293_), (double)0.0, (double)1.1);
        DensityFunction densityfunction3 = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208363_((DensityFunction)densityfunction, (DensityFunction)DensityFunctions.m_208264_((double)2.0)), (DensityFunction)densityfunction1);
        return DensityFunctions.m_208380_((DensityFunction)DensityFunctions.m_208363_((DensityFunction)densityfunction3, (DensityFunction)densityfunction2.m_208231_()));
    }

    private static DensityFunction spaghetti2D(Registry<DensityFunction> p_224518_) {
        DensityFunction densityfunction = DensityFunctions.m_208368_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189296_), (double)2.0, (double)1.0);
        DensityFunction densityfunction1 = DensityFunctions.m_208315_((DensityFunction)densityfunction, ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189294_), (DensityFunctions.WeirdScaledSampler.RarityValueMapper)DensityFunctions.WeirdScaledSampler.RarityValueMapper.TYPE2);
        DensityFunction densityfunction2 = DensityFunctions.m_208331_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189295_), (double)0.0, (double)Math.floorDiv(-64, 8), (double)8.0);
        DensityFunction densityfunction3 = ExotelNoiseRouterData.getFunction(p_224518_, SPAGHETTI_2D_THICKNESS_MODULATOR);
        DensityFunction densityfunction4 = DensityFunctions.m_208293_((DensityFunction)densityfunction2, (DensityFunction)DensityFunctions.m_208266_((int)-64, (int)320, (double)8.0, (double)-40.0)).m_208229_();
        DensityFunction densityfunction5 = DensityFunctions.m_208293_((DensityFunction)densityfunction4, (DensityFunction)densityfunction3).m_208231_();
        double d0 = 0.083;
        DensityFunction densityfunction6 = DensityFunctions.m_208293_((DensityFunction)densityfunction1, (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)0.083), (DensityFunction)densityfunction3));
        return DensityFunctions.m_208382_((DensityFunction)densityfunction6, (DensityFunction)densityfunction5).m_208220_(-1.0, 1.0);
    }

    private static DensityFunction underground(Registry<DensityFunction> p_224472_, DensityFunction p_224473_) {
        DensityFunction densityfunction = ExotelNoiseRouterData.getFunction(p_224472_, SPAGHETTI_2D);
        DensityFunction densityfunction1 = ExotelNoiseRouterData.getFunction(p_224472_, SPAGHETTI_ROUGHNESS_FUNCTION);
        DensityFunction densityfunction2 = DensityFunctions.m_208324_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189245_), (double)8.0);
        DensityFunction densityfunction3 = DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)4.0), (DensityFunction)densityfunction2.m_208230_());
        DensityFunction densityfunction4 = DensityFunctions.m_208324_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189246_), (double)0.6666666666666666);
        DensityFunction densityfunction5 = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)0.27), (DensityFunction)densityfunction4).m_208220_(-1.0, 1.0), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)1.5), (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)-0.64), (DensityFunction)p_224473_)).m_208220_(0.0, 0.5));
        DensityFunction densityfunction6 = DensityFunctions.m_208293_((DensityFunction)densityfunction3, (DensityFunction)densityfunction5);
        DensityFunction densityfunction7 = DensityFunctions.m_208375_((DensityFunction)DensityFunctions.m_208375_((DensityFunction)densityfunction6, (DensityFunction)ExotelNoiseRouterData.getFunction(p_224472_, ENTRANCES)), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)densityfunction, (DensityFunction)densityfunction1));
        DensityFunction densityfunction8 = ExotelNoiseRouterData.getFunction(p_224472_, PILLARS);
        DensityFunction densityfunction9 = DensityFunctions.m_208287_((DensityFunction)densityfunction8, (double)-1000000.0, (double)0.03, (DensityFunction)DensityFunctions.m_208264_((double)-1000000.0), (DensityFunction)densityfunction8);
        return DensityFunctions.m_208382_((DensityFunction)densityfunction7, (DensityFunction)densityfunction9);
    }

    private static DensityFunction postProcess(DensityFunction p_224493_) {
        DensityFunction densityfunction = DensityFunctions.m_208389_((DensityFunction)p_224493_);
        return DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208281_((DensityFunction)densityfunction), (DensityFunction)DensityFunctions.m_208264_((double)0.64)).m_208234_();
    }

    protected static NoiseRouter exotel(Registry<DensityFunction> p_224486_, boolean p_224487_, boolean p_224488_) {
        DensityFunction densityfunction = DensityFunctions.m_208324_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189287_), (double)0.5);
        DensityFunction densityfunction1 = DensityFunctions.m_208324_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189288_), (double)0.67);
        DensityFunction densityfunction2 = DensityFunctions.m_208324_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189290_), (double)0.7142857142857143);
        DensityFunction densityfunction3 = DensityFunctions.m_208322_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189289_));
        DensityFunction densityfunction4 = ExotelNoiseRouterData.getFunction(p_224486_, SHIFT_X);
        DensityFunction densityfunction5 = ExotelNoiseRouterData.getFunction(p_224486_, SHIFT_Z);
        DensityFunction densityfunction6 = DensityFunctions.m_208296_((DensityFunction)densityfunction4, (DensityFunction)densityfunction5, (double)0.25, ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)(p_224487_ ? Noises.f_189281_ : Noises.f_189269_)));
        DensityFunction densityfunction7 = DensityFunctions.m_208296_((DensityFunction)densityfunction4, (DensityFunction)densityfunction5, (double)0.25, ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)(p_224487_ ? Noises.f_189282_ : Noises.f_189278_)));
        DensityFunction densityfunction8 = ExotelNoiseRouterData.getFunction(p_224486_, p_224487_ ? FACTOR_LARGE : (p_224488_ ? FACTOR_AMPLIFIED : FACTOR));
        DensityFunction densityfunction9 = ExotelNoiseRouterData.getFunction(p_224486_, p_224487_ ? DEPTH_LARGE : (p_224488_ ? DEPTH_AMPLIFIED : DEPTH));
        DensityFunction densityfunction10 = ExotelNoiseRouterData.noiseGradientDensity(DensityFunctions.m_208373_((DensityFunction)densityfunction8), densityfunction9);
        DensityFunction densityfunction11 = ExotelNoiseRouterData.getFunction(p_224486_, p_224487_ ? SLOPED_CHEESE_LARGE : (p_224488_ ? SLOPED_CHEESE_AMPLIFIED : SLOPED_CHEESE));
        DensityFunction densityfunction12 = DensityFunctions.m_208375_((DensityFunction)densityfunction11, (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)5.0), (DensityFunction)ExotelNoiseRouterData.getFunction(p_224486_, ENTRANCES)));
        DensityFunction densityfunction13 = DensityFunctions.m_208287_((DensityFunction)densityfunction11, (double)-1000000.0, (double)1.5625, (DensityFunction)densityfunction12, (DensityFunction)ExotelNoiseRouterData.underground(p_224486_, densityfunction11));
        DensityFunction densityfunction14 = DensityFunctions.m_208375_((DensityFunction)ExotelNoiseRouterData.postProcess(ExotelNoiseRouterData.slideOverworld(p_224488_, densityfunction13)), (DensityFunction)ExotelNoiseRouterData.getFunction(p_224486_, NOODLE));
        DensityFunction densityfunction15 = ExotelNoiseRouterData.getFunction(p_224486_, Y);
        int i = Stream.of(OreVeinifier.VeinType.values()).mapToInt(p_224495_ -> p_224495_.minY).min().orElse(-DimensionType.f_156653_ * 2);
        int j = Stream.of(OreVeinifier.VeinType.values()).mapToInt(p_224457_ -> p_224457_.maxY).max().orElse(-DimensionType.f_156653_ * 2);
        DensityFunction densityfunction16 = ExotelNoiseRouterData.yLimitedInterpolatable(densityfunction15, DensityFunctions.m_208368_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189247_), (double)1.5, (double)1.5), i, j, 0);
        float f = 4.0f;
        DensityFunction densityfunction17 = ExotelNoiseRouterData.yLimitedInterpolatable(densityfunction15, DensityFunctions.m_208368_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189248_), (double)4.0, (double)4.0), i, j, 0).m_208229_();
        DensityFunction densityfunction18 = ExotelNoiseRouterData.yLimitedInterpolatable(densityfunction15, DensityFunctions.m_208368_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189249_), (double)4.0, (double)4.0), i, j, 0).m_208229_();
        DensityFunction densityfunction19 = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-0.08f), (DensityFunction)DensityFunctions.m_208382_((DensityFunction)densityfunction17, (DensityFunction)densityfunction18));
        DensityFunction densityfunction20 = DensityFunctions.m_208322_(ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189250_));
        return new NoiseRouter(densityfunction, densityfunction1, densityfunction2, densityfunction3, densityfunction6, densityfunction7, ExotelNoiseRouterData.getFunction(p_224486_, p_224487_ ? CONTINENTS_LARGE : CONTINENTS), ExotelNoiseRouterData.getFunction(p_224486_, p_224487_ ? EROSION_LARGE : EROSION), densityfunction9, ExotelNoiseRouterData.getFunction(p_224486_, RIDGES), ExotelNoiseRouterData.slideOverworld(p_224488_, DensityFunctions.m_208293_((DensityFunction)densityfunction10, (DensityFunction)DensityFunctions.m_208264_((double)-0.703125)).m_208220_(-64.0, 64.0)), densityfunction14, densityfunction16, densityfunction19, densityfunction20);
    }

    private static NoiseRouter noNewCaves(Registry<DensityFunction> p_224503_, DensityFunction p_224504_) {
        DensityFunction densityfunction = ExotelNoiseRouterData.getFunction(p_224503_, SHIFT_X);
        DensityFunction densityfunction1 = ExotelNoiseRouterData.getFunction(p_224503_, SHIFT_Z);
        DensityFunction densityfunction2 = DensityFunctions.m_208296_((DensityFunction)densityfunction, (DensityFunction)densityfunction1, (double)0.25, ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189269_));
        DensityFunction densityfunction3 = DensityFunctions.m_208296_((DensityFunction)densityfunction, (DensityFunction)densityfunction1, (double)0.25, ExotelNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189278_));
        DensityFunction densityfunction4 = ExotelNoiseRouterData.postProcess(p_224504_);
        return new NoiseRouter(DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), densityfunction2, densityfunction3, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), densityfunction4, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_());
    }

    private static DensityFunction slideOverworld(boolean p_224490_, DensityFunction p_224491_) {
        return ExotelNoiseRouterData.slide(p_224491_, -64, 384, p_224490_ ? 16 : 80, p_224490_ ? 0 : 64, -0.078125, 0, 24, p_224490_ ? 0.4 : 0.1171875);
    }

    private static DensityFunction slideNetherLike(Registry<DensityFunction> p_224461_, int p_224462_, int p_224463_) {
        return ExotelNoiseRouterData.slide(ExotelNoiseRouterData.getFunction(p_224461_, BASE_3D_NOISE_NETHER), p_224462_, p_224463_, 24, 0, 0.9375, -8, 24, 2.5);
    }

    private static DensityFunction slideEndLike(DensityFunction p_224440_, int p_224441_, int p_224442_) {
        return ExotelNoiseRouterData.slide(p_224440_, p_224441_, p_224442_, 72, -184, -23.4375, 4, 32, -0.234375);
    }

    protected static NoiseRouter nether(Registry<DensityFunction> p_224497_) {
        return ExotelNoiseRouterData.noNewCaves(p_224497_, ExotelNoiseRouterData.slideNetherLike(p_224497_, 0, 128));
    }

    protected static NoiseRouter caves(Registry<DensityFunction> p_224508_) {
        return ExotelNoiseRouterData.noNewCaves(p_224508_, ExotelNoiseRouterData.slideNetherLike(p_224508_, -64, 192));
    }

    protected static NoiseRouter floatingIslands(Registry<DensityFunction> p_224510_) {
        return ExotelNoiseRouterData.noNewCaves(p_224510_, ExotelNoiseRouterData.slideEndLike(ExotelNoiseRouterData.getFunction(p_224510_, BASE_3D_NOISE_END), 0, 256));
    }

    private static DensityFunction slideEnd(DensityFunction p_224506_) {
        return ExotelNoiseRouterData.slideEndLike(p_224506_, 0, 128);
    }

    protected static NoiseRouter end(Registry<DensityFunction> p_224512_) {
        DensityFunction densityfunction = DensityFunctions.m_208373_((DensityFunction)DensityFunctions.m_208271_((long)0L));
        DensityFunction densityfunction1 = ExotelNoiseRouterData.postProcess(ExotelNoiseRouterData.slideEnd(ExotelNoiseRouterData.getFunction(p_224512_, SLOPED_CHEESE_END)));
        return new NoiseRouter(DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), densityfunction, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), ExotelNoiseRouterData.slideEnd(DensityFunctions.m_208293_((DensityFunction)densityfunction, (DensityFunction)DensityFunctions.m_208264_((double)-0.703125))), densityfunction1, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_());
    }

    protected static NoiseRouter none() {
        return new NoiseRouter(DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_());
    }

    private static DensityFunction splineWithBlending(DensityFunction p_224454_, DensityFunction p_224455_) {
        DensityFunction densityfunction = DensityFunctions.m_208301_((DensityFunction)DensityFunctions.m_208360_(), (DensityFunction)p_224455_, (DensityFunction)p_224454_);
        return DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208373_((DensityFunction)densityfunction));
    }

    private static DensityFunction noiseGradientDensity(DensityFunction p_212272_, DensityFunction p_212273_) {
        DensityFunction densityfunction = DensityFunctions.m_208363_((DensityFunction)p_212273_, (DensityFunction)p_212272_);
        return DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)4.0), (DensityFunction)densityfunction.m_208233_());
    }

    private static DensityFunction yLimitedInterpolatable(DensityFunction p_209472_, DensityFunction p_209473_, int p_209474_, int p_209475_, int p_209476_) {
        return DensityFunctions.m_208281_((DensityFunction)DensityFunctions.m_208287_((DensityFunction)p_209472_, (double)p_209474_, (double)(p_209475_ + 1), (DensityFunction)p_209473_, (DensityFunction)DensityFunctions.m_208264_((double)p_209476_)));
    }

    private static DensityFunction slide(DensityFunction p_224444_, int p_224445_, int p_224446_, int p_224447_, int p_224448_, double p_224449_, int p_224450_, int p_224451_, double p_224452_) {
        DensityFunction densityfunction1 = DensityFunctions.m_208266_((int)(p_224445_ + p_224446_ - p_224447_), (int)(p_224445_ + p_224446_ - p_224448_), (double)1.0, (double)0.0);
        DensityFunction $$9 = DensityFunctions.m_224030_((DensityFunction)densityfunction1, (double)p_224449_, (DensityFunction)p_224444_);
        DensityFunction densityfunction2 = DensityFunctions.m_208266_((int)(p_224445_ + p_224450_), (int)(p_224445_ + p_224451_), (double)0.0, (double)1.0);
        return DensityFunctions.m_224030_((DensityFunction)densityfunction2, (double)p_224452_, (DensityFunction)$$9);
    }

    protected static final class QuantizedSpaghettiRarity {
        protected QuantizedSpaghettiRarity() {
        }

        protected static double getSphaghettiRarity2D(double p_209564_) {
            if (p_209564_ < -0.75) {
                return 0.5;
            }
            if (p_209564_ < -0.5) {
                return 0.75;
            }
            if (p_209564_ < 0.5) {
                return 1.0;
            }
            return p_209564_ < 0.75 ? 2.0 : 3.0;
        }

        protected static double getSpaghettiRarity3D(double p_209566_) {
            if (p_209566_ < -0.5) {
                return 0.75;
            }
            if (p_209566_ < 0.0) {
                return 1.0;
            }
            return p_209566_ < 0.5 ? 1.5 : 2.0;
        }
    }
}

