/*
 * Decompiled with CFR 0.152.
 */
package net.grupa_tkd.better_minecraft.world.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.grupa_tkd.better_minecraft.world.ore.BlueIceFeature;
import net.grupa_tkd.better_minecraft.world.ore.BlueStoneDiamondOreFeature;
import net.grupa_tkd.better_minecraft.world.ore.OpalOreFeature;
import net.grupa_tkd.better_minecraft.world.ore.RubyOreFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class ModOreGeneration {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"better_minecraft");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> OPAL_ORE = ModOreGeneration.register("opal_ore", OpalOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, OpalOreFeature.GENERATE_BIOMES, OpalOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> BLUE_STONE_DIAMOND_ORE = ModOreGeneration.register("blue_stone_diamond_ore", BlueStoneDiamondOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, BlueStoneDiamondOreFeature.GENERATE_BIOMES, BlueStoneDiamondOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> RUBY_ORE = ModOreGeneration.register("ruby_ore", RubyOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, RubyOreFeature.GENERATE_BIOMES, RubyOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> BLUE_ICE_ORE = ModOreGeneration.register("blue_ice_ore", BlueIceFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, BlueIceFeature.GENERATE_BIOMES, BlueIceFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

