/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.Config;
import capsule.StructureSaver;
import capsule.blocks.CapsuleBlocksRegistrer;
import capsule.command.CapsuleCommand;
import capsule.enchantments.Enchantments;
import capsule.items.CapsuleItemsRegistrer;
import capsule.loot.CapsuleLootTableHook;
import capsule.network.CapsuleContentPreviewAnswerHandler;
import capsule.network.CapsuleContentPreviewAnswerToClient;
import capsule.network.CapsuleContentPreviewQueryHandler;
import capsule.network.CapsuleContentPreviewQueryToServer;
import capsule.network.CapsuleThrowQueryHandler;
import capsule.network.CapsuleThrowQueryToServer;
import capsule.network.LabelEditedMessageToServer;
import capsule.network.LabelEditedMessageToServerMessageHandler;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class CommonProxy {
    public static SimpleNetworkWrapper simpleNetworkWrapper;
    public static byte CAPSULE_CHANNEL_MESSAGE_ID;

    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        Config.readConfig(config);
        Config.initLootConfigs();
        Config.initReceipeConfigs();
        Config.initEnchantsConfigs();
        Enchantments.initEnchantments();
        CapsuleItemsRegistrer.registerItems();
        CapsuleBlocksRegistrer.registerBlocks();
        simpleNetworkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("CapsuleChannel");
        byte by = CAPSULE_CHANNEL_MESSAGE_ID;
        CAPSULE_CHANNEL_MESSAGE_ID = (byte)(by + 1);
        simpleNetworkWrapper.registerMessage(LabelEditedMessageToServerMessageHandler.class, LabelEditedMessageToServer.class, (int)by, Side.SERVER);
        byte by2 = CAPSULE_CHANNEL_MESSAGE_ID;
        CAPSULE_CHANNEL_MESSAGE_ID = (byte)(by2 + 1);
        simpleNetworkWrapper.registerMessage(CapsuleContentPreviewQueryHandler.class, CapsuleContentPreviewQueryToServer.class, (int)by2, Side.SERVER);
        byte by3 = CAPSULE_CHANNEL_MESSAGE_ID;
        CAPSULE_CHANNEL_MESSAGE_ID = (byte)(by3 + 1);
        simpleNetworkWrapper.registerMessage(CapsuleThrowQueryHandler.class, CapsuleThrowQueryToServer.class, (int)by3, Side.SERVER);
        byte by4 = CAPSULE_CHANNEL_MESSAGE_ID;
        CAPSULE_CHANNEL_MESSAGE_ID = (byte)(by4 + 1);
        simpleNetworkWrapper.registerMessage(CapsuleContentPreviewAnswerHandler.class, CapsuleContentPreviewAnswerToClient.class, (int)by4, Side.CLIENT);
    }

    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)Enchantments.recallEnchant);
    }

    public void postInit(FMLPostInitializationEvent event) {
        CapsuleItemsRegistrer.registerRecipes();
        CapsuleBlocksRegistrer.registerRecipes();
        Config.initCaptureConfigs();
        Config.config.save();
        if (Config.config.hasChanged()) {
            Config.config.save();
        }
        CapsuleLootTableHook lootTableHook = new CapsuleLootTableHook();
        MinecraftForge.EVENT_BUS.register((Object)lootTableHook);
    }

    public void serverStarting(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CapsuleCommand());
        StructureSaver.loadLootList(e.getServer());
    }

    public void openGuiScreen(EntityPlayer playerIn) {
    }

    static {
        CAPSULE_CHANNEL_MESSAGE_ID = 1;
    }
}

