/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.Helpers;
import capsule.items.CapsuleItem;
import capsule.loot.LootPathData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleItem.class);
    public static Configuration config = null;
    public static List<Block> excludedBlocks;
    public static List<Block> overridableBlocks;
    public static List<Block> opExcludedBlocks;
    public static String[] lootTemplatesPaths;
    public static Map<String, LootPathData> lootTemplatesData;
    public static String rewardTemplatesPath;
    public static int upgradeLimit;
    public static String enchantRarity;
    public static String recallEnchantType;
    public static int ironCapsuleSize;
    public static int goldCapsuleSize;
    public static int diamondCapsuleSize;
    public static int opCapsuleSize;

    public static void readConfig(Configuration config) {
        try {
            Config.config = config;
            config.load();
        }
        catch (Exception e1) {
            LOGGER.error("Problem loading config file !", (Throwable)e1);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    public static void initCaptureConfigs() {
        Property upgradesLimit = config.get("Balancing", "capsuleUpgradesLimit", 10);
        upgradesLimit.setComment("Number of upgrades an empty capsules can get to improve capacity. If <= 0, the capsule won't be able to upgrade.");
        upgradeLimit = upgradesLimit.getInt();
        Block[] defaultExcludedBlocksOP = new Block[]{Blocks.field_150350_a, Blocks.field_189881_dj};
        Block[] defaultExcludedBlocks = new Block[]{Blocks.field_150357_h, Blocks.field_150474_ac, Blocks.field_150384_bq, Blocks.field_150378_br};
        Object[] excludedBlocksOP = (String[])ArrayUtils.addAll((Object[])Helpers.serializeBlockArray(defaultExcludedBlocksOP), (Object[])new String[]{"ic2:te", "opencomputers:robot", "lootbags:loot_opener", "hatchery:pen"});
        String[] excludedBlocks = (String[])ArrayUtils.addAll((Object[])Helpers.serializeBlockArray(defaultExcludedBlocks), (Object[])excludedBlocksOP);
        Property excludedBlocksProp = config.get("Balancing", "excludedBlocks", excludedBlocks);
        excludedBlocksProp.setComment("List of block ids that will never be captured by a non overpowered capsule. While capturing, the blocks will stay in place.\n Ex: minecraft:mob_spawner");
        Block[] exBlocks = null;
        exBlocks = Helpers.deserializeBlockArray(excludedBlocksProp.getStringList());
        Config.excludedBlocks = Arrays.asList(exBlocks);
        Property opExcludedBlocksProp = config.get("Balancing", "opExcludedBlocks", (String[])excludedBlocksOP);
        opExcludedBlocksProp.setComment("List of block ids that will never be captured even with an overpowered capsule. While capturing, the blocks will stay in place.\n Ex: minecraft:mob_spawner");
        Block[] opExBlocks = null;
        opExBlocks = Helpers.deserializeBlockArray(opExcludedBlocksProp.getStringList());
        opExcludedBlocks = Arrays.asList(opExBlocks);
        Block[] defaultOverridable = new Block[]{Blocks.field_150350_a, Blocks.field_150355_j, Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150329_H, Blocks.field_150328_O, Blocks.field_150327_N, Blocks.field_150431_aC, Blocks.field_150338_P, Blocks.field_150337_Q, Blocks.field_150398_cm};
        Property overridableBlocksProp = config.get("Balancing", "overridableBlocks", Helpers.serializeBlockArray(defaultOverridable));
        overridableBlocksProp.setComment("List of block ids that can be overriden while teleporting blocks.\nPut there blocks that the player don't care about (grass, leaves) so they don't prevent the capsule from deploying.");
        Block[] ovBlocks = null;
        ovBlocks = Helpers.deserializeBlockArray(overridableBlocksProp.getStringList());
        overridableBlocks = Arrays.asList(ovBlocks);
    }

    public static void initLootConfigs() {
        Property lootTemplatesPathsProp = config.get("loots", "lootTemplatesPaths", new String[]{"config/capsule/loot/common", "config/capsule/loot/uncommon", "config/capsule/loot/rare"});
        lootTemplatesPathsProp.setComment("List of paths where the mod will look for structureBlock files. Each save will have a chance to appear as a reward capsule in a dungeon chest.");
        lootTemplatesPaths = lootTemplatesPathsProp.getStringList();
        Property rewardTemplatesPathProp = config.get("loots", "rewardTemplatesPath", "config/capsule/rewards");
        rewardTemplatesPathProp.setComment("Paths where the mod will look for structureBlock files when invoking command /capsule fromStructure <structureName>.");
        rewardTemplatesPath = rewardTemplatesPathProp.getString();
        for (int i = 0; i < lootTemplatesPaths.length; ++i) {
            String path = lootTemplatesPaths[i];
            if (!lootTemplatesData.containsKey(path)) {
                lootTemplatesData.put(path, new LootPathData());
            }
            Property pathDataWeight = config.get("loots:" + path, "weight", path.endsWith("rare") ? 1 : (path.endsWith("uncommon") ? 6 : 12));
            pathDataWeight.setComment("Chances to get a capsule from this folder. Higher means more common. Default : 1 (rare), 6 (uncommon) or 12 (common)");
            Config.lootTemplatesData.get((Object)path).weigth = pathDataWeight.getInt();
        }
    }

    public static void initReceipeConfigs() {
        Property ironCapsuleSize = config.get("Balancing", "ironCapsuleSize", "1");
        ironCapsuleSize.setComment("Size of the capture cube side for an Iron Capsule. Must be an Odd Number (or it will be rounded down with error message).\n0 to disable.\nDefault: 1");
        Config.ironCapsuleSize = ironCapsuleSize.getInt();
        Property goldCapsuleSize = config.get("Balancing", "goldCapsuleSize", "3");
        goldCapsuleSize.setComment("Size of the capture cube side for a Gold Capsule. Must be an Odd Number (or it will be rounded down with error message).\n0 to disable.\nDefault: 3");
        Config.goldCapsuleSize = goldCapsuleSize.getInt();
        Property diamondCapsuleSize = config.get("Balancing", "diamondCapsuleSize", "5");
        diamondCapsuleSize.setComment("Size of the capture cube side for a Diamond Capsule. Must be an Odd Number (or it will be rounded down with error message).\n0 to disable.\nDefault: 5");
        Config.diamondCapsuleSize = diamondCapsuleSize.getInt();
        Property opCapsuleSize = config.get("Balancing", "opCapsuleSize", "1");
        opCapsuleSize.setComment("Size of the capture cube side for a Overpowered Capsule. Must be an Odd Number (or it will be rounded down with error message).\n0 to disable.\nDefault: 1");
        Config.opCapsuleSize = opCapsuleSize.getInt();
    }

    public static void initEnchantsConfigs() {
        Property enchantRarityConfig = config.get("Balancing", "recallEnchantRarity", "RARE");
        enchantRarityConfig.setComment("Rarity of the enchantmant. Possible values : COMMON, UNCOMMON, RARE, VERY_RARE. Default: RARE.");
        enchantRarity = enchantRarityConfig.getString();
        Property recallEnchantTypeConfig = config.get("Balancing", "recallEnchantType", "null");
        recallEnchantTypeConfig.setComment("Possible targets for the enchantment. By default : null.\nPossible values are ALL, ARMOR, ARMOR_FEET, ARMOR_LEGS, ARMOR_TORSO, ARMOR_HEAD, WEAPON, DIGGER, FISHING_ROD, BREAKABLE, BOW, null.\nIf null or empty, Capsules will be the only items to be able to get this Enchantment.");
        recallEnchantType = recallEnchantTypeConfig.getString();
    }

    static {
        lootTemplatesData = new HashMap<String, LootPathData>();
    }
}

