/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Helpers {
    protected static final Logger LOGGER = LogManager.getLogger(Helpers.class);

    public static BlockPos findBottomBlock(EntityItem entityItem) {
        return Helpers.findBottomBlock(entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v);
    }

    public static BlockPos findBottomBlock(double x, double y, double z) {
        Iterable blockPoss = BlockPos.func_177980_a((BlockPos)new BlockPos(x, y - 1.0, z), (BlockPos)new BlockPos(x + 1.0, y + 1.0, z + 1.0));
        BlockPos closest = null;
        double closestDistance = 1000.0;
        for (BlockPos pos : blockPoss) {
            double distance = pos.func_177957_d(x, y, z);
            if (!(distance < closestDistance)) continue;
            closest = pos;
            closestDistance = distance;
        }
        return closest;
    }

    public static RayTraceResult clientRayTracePreview(EntityPlayer thePlayer, float partialTicks) {
        int blockReachDistance = 18;
        Vec3d vec3d = thePlayer.func_174824_e(partialTicks);
        Vec3d vec3d1 = thePlayer.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * (double)blockReachDistance, vec3d1.field_72448_b * (double)blockReachDistance, vec3d1.field_72449_c * (double)blockReachDistance);
        RayTraceResult rtc = thePlayer.func_130014_f_().func_147447_a(vec3d, vec3d2, false, true, true);
        return rtc;
    }

    public static BlockPos findSpecificBlock(EntityItem entityItem, int maxRange, Class searchedBlock) {
        if (searchedBlock == null) {
            return null;
        }
        double i = entityItem.field_70165_t;
        double j = entityItem.field_70163_u;
        double k = entityItem.field_70161_v;
        for (int range = 1; range < maxRange; ++range) {
            Iterable blockPoss = BlockPos.func_177975_b((BlockPos)new BlockPos(i - (double)range, j - (double)range, k - (double)range), (BlockPos)new BlockPos(i + (double)range, j + (double)range, k + (double)range));
            for (BlockPos pos : blockPoss) {
                Block block = entityItem.field_70170_p.func_180495_p(pos).func_177230_c();
                if (!block.getClass().equals(searchedBlock)) continue;
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return null;
    }

    public static boolean hasColor(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        if (!stack.func_77978_p().func_150297_b("display", 10)) {
            return false;
        }
        return stack.func_77978_p().func_74775_l("display").func_150297_b("color", 3);
    }

    public static int getColor(ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.func_74775_l("display")).func_150297_b("color", 3)) {
            return nbttagcompound1.func_74762_e("color");
        }
        return 0xFFFFFF;
    }

    public static void setColor(ItemStack stack, int color) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            stack.func_77982_d(nbttagcompound);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
        if (!nbttagcompound.func_150297_b("display", 10)) {
            nbttagcompound.func_74782_a("display", (NBTBase)nbttagcompound1);
        }
        nbttagcompound1.func_74768_a("color", color);
    }

    public static Block[] deserializeBlockArray(String[] blockIds) {
        ArrayList<Block> states = new ArrayList<Block>();
        ArrayList<String> notfound = new ArrayList<String>();
        for (String blockId : blockIds) {
            Block b = Block.func_149684_b((String)blockId);
            if (b != null) {
                states.add(b);
                continue;
            }
            notfound.add(blockId);
        }
        if (notfound.size() > 0) {
            LOGGER.warn(String.format("Blocks not found from config name : %s. Those blocks won't be considered in the overridable or excluded blocks list when capturing with capsule.", String.join((CharSequence)", ", notfound.toArray(new CharSequence[notfound.size()]))));
        }
        Block[] output = new Block[states.size()];
        return states.toArray(output);
    }

    public static String[] serializeBlockArray(Block[] states) {
        String[] blocksNames = new String[states.length];
        for (int i = 0; i < states.length; ++i) {
            blocksNames[i] = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)states[i])).toString();
        }
        return blocksNames;
    }
}

