/*
 * Decompiled with CFR 0.152.
 */
package capsule.client;

import capsule.Config;
import capsule.Helpers;
import capsule.blocks.CaptureTESR;
import capsule.blocks.TileEntityCapture;
import capsule.items.CapsuleItem;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class CapsulePreviewHandler {
    public static final Map<String, List<BlockPos>> currentPreview = new HashMap<String, List<BlockPos>>();
    private static AxisAlignedBB boundingBox1 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static AxisAlignedBB extboundingBox1 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private int lastSize = 0;
    private int lastColor = 0;

    public static void drawDeployZone(int color) {
        Color c = new Color(color);
        int red = c.getRed();
        int green = c.getGreen();
        int blue = c.getBlue();
        int alpha = 150;
        AxisAlignedBB boundingBox = boundingBox1;
        if (color == 0xAA0000) {
            GlStateManager.func_187441_d((float)5.0f);
            boundingBox = extboundingBox1;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181669_b(red, green, blue, alpha).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181669_b(red, green, blue, alpha).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181669_b(red, green, blue, alpha).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181669_b(red, green, blue, alpha).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181669_b(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
        vertexbuffer.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181669_b(red, green, blue, alpha).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181669_b(red, green, blue, alpha).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181669_b(red, green, blue, alpha).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181669_b(red, green, blue, alpha).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181669_b(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
        vertexbuffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181669_b(red, green, blue, alpha).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181669_b(red, green, blue, alpha).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181669_b(red, green, blue, alpha).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181669_b(red, green, blue, alpha).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181669_b(red, green, blue, alpha).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181669_b(red, green, blue, alpha).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181669_b(red, green, blue, alpha).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181669_b(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_187441_d((float)1.0f);
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof EntityPlayerSP && event.phase.equals((Object)TickEvent.Phase.START)) {
            EntityPlayerSP player = (EntityPlayerSP)event.player;
            this.tryPreviewCapture(player, player.func_184614_ca());
        }
    }

    private boolean tryPreviewCapture(EntityPlayerSP player, ItemStack heldItem) {
        if (heldItem != null) {
            Item heldItemItem = heldItem.func_77973_b();
            if (heldItemItem instanceof CapsuleItem && (heldItem.func_77952_i() == 0 || heldItem.func_77952_i() == 4)) {
                CapsuleItem capsule = (CapsuleItem)heldItem.func_77973_b();
                if (heldItem.func_77942_o() && heldItem.func_77978_p().func_74764_b("size")) {
                    this.setCaptureTESizeColor(heldItem.func_77978_p().func_74762_e("size"), capsule.getColorFromItemstack(heldItem, 0), player.field_70170_p);
                    return true;
                }
            } else {
                this.setCaptureTESizeColor(0, 0, player.field_70170_p);
            }
        } else {
            this.setCaptureTESizeColor(0, 0, player.field_70170_p);
        }
        return false;
    }

    @SubscribeEvent
    public void onWorldRenderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null) {
            this.tryPreviewRecall(mc.field_71439_g.func_184614_ca());
            this.tryPreviewDeploy(mc.field_71439_g, event.getPartialTicks(), mc.field_71439_g.func_184614_ca());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryPreviewDeploy(EntityPlayerSP thePlayer, float partialTicks, ItemStack heldItemMainhand) {
        RayTraceResult rtc;
        if (heldItemMainhand != null && heldItemMainhand.func_77973_b() instanceof CapsuleItem && heldItemMainhand.func_77942_o() && (heldItemMainhand.func_77952_i() == 1 || heldItemMainhand.func_77952_i() == 6) && (rtc = Helpers.clientRayTracePreview((EntityPlayer)thePlayer, partialTicks)) != null && rtc.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos anchorPos = rtc.func_178782_a().func_177971_a(rtc.field_178784_b.func_176730_m());
            String structureName = heldItemMainhand.func_77978_p().func_74779_i("structureName");
            Map<String, List<BlockPos>> map = currentPreview;
            synchronized (map) {
                if (currentPreview.containsKey(structureName)) {
                    int extendSize = (this.getSize(heldItemMainhand) - 1) / 2;
                    List<BlockPos> blockspos = currentPreview.get(structureName);
                    if (blockspos.isEmpty()) {
                        blockspos.add(new BlockPos(extendSize, 0, extendSize));
                    }
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179090_x();
                    GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
                    GlStateManager.func_179090_x();
                    GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
                    for (BlockPos blockpos : blockspos) {
                        BlockPos destBlock = blockpos.func_177971_a((Vec3i)anchorPos).func_177982_a(-extendSize, 0, -extendSize);
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179137_b((double)((double)(anchorPos.func_177958_n() + blockpos.func_177958_n() - extendSize) - TileEntityRendererDispatcher.field_147554_b), (double)((double)(anchorPos.func_177956_o() + blockpos.func_177956_o()) + 0.01 - TileEntityRendererDispatcher.field_147555_c), (double)((double)(anchorPos.func_177952_p() + blockpos.func_177952_p() - extendSize) - TileEntityRendererDispatcher.field_147552_d));
                        int color = 0xCCCCCC;
                        if (!Config.overridableBlocks.contains(thePlayer.field_70170_p.func_180495_p(destBlock).func_177230_c())) {
                            color = 0xAA0000;
                        }
                        CapsulePreviewHandler.drawDeployZone(color);
                        GlStateManager.func_179121_F();
                    }
                    GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179132_a((boolean)true);
                    GL11.glLineWidth((float)1.0f);
                    GlStateManager.func_179121_F();
                }
            }
        }
    }

    private void tryPreviewRecall(ItemStack heldItem) {
        Item heldItemItem;
        if (heldItem != null && (heldItemItem = heldItem.func_77973_b()) instanceof CapsuleItem && heldItem.func_77952_i() == 3 && heldItem.func_77942_o() && heldItem.func_77978_p().func_74764_b("spawnPosition")) {
            this.previewRecall(heldItem);
        }
    }

    private int getSize(ItemStack capsule) {
        int size = 1;
        if (capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("size")) {
            size = capsule.func_77978_p().func_74762_e("size");
        }
        return size;
    }

    private void previewRecall(ItemStack capsule) {
        if (!capsule.func_77942_o()) {
            return;
        }
        NBTTagCompound linkPos = capsule.func_77978_p().func_74775_l("spawnPosition");
        int size = this.getSize(capsule);
        int extendSize = (size - 1) / 2;
        CapsuleItem capsuleItem = (CapsuleItem)capsule.func_77973_b();
        int color = capsuleItem.getColorFromItemstack(capsule, 0);
        CaptureTESR.drawCaptureZone((double)(linkPos.func_74762_e("x") + extendSize) - TileEntityRendererDispatcher.field_147554_b, (double)(linkPos.func_74762_e("y") - 1) - TileEntityRendererDispatcher.field_147555_c, (double)(linkPos.func_74762_e("z") + extendSize) - TileEntityRendererDispatcher.field_147552_d, size, extendSize, color);
    }

    private void setCaptureTESizeColor(int size, int color, World worldIn) {
        if (size == this.lastSize && color == this.lastColor) {
            return;
        }
        for (TileEntityCapture te : TileEntityCapture.instances) {
            if (te.func_145831_w() != worldIn) continue;
            TileEntityCapture tec = te;
            tec.getTileData().func_74768_a("size", size);
            tec.getTileData().func_74768_a("color", color);
            worldIn.func_175704_b(te.func_174877_v(), te.func_174877_v());
        }
        this.lastSize = size;
        this.lastColor = color;
    }
}

