/*
 * Decompiled with CFR 0.152.
 */
package capsule.command;

import capsule.Config;
import capsule.Helpers;
import capsule.StructureSaver;
import capsule.items.CapsuleItem;
import capsule.loot.CapsuleLootEntry;
import capsule.loot.CapsuleLootTableHook;
import capsule.structure.CapsuleTemplate;
import capsule.structure.CapsuleTemplateManager;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootContext;
import org.apache.commons.lang3.tuple.Pair;

public class CapsuleCommand
extends CommandBase {
    public static String[] COMMAND_LIST = new String[]{"giveEmpty", "exportHeldItem", "exportSeenBlock", "fromExistingReward", "fromHeldCapsule", "fromStructure", "giveRandomLoot", "reloadLootList", "setAuthor", "setBaseColor", "setMaterialColor"};

    public String func_71517_b() {
        return "capsule";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        TextComponentString msg = new TextComponentString("see Capsule commands usages at " + TextFormatting.UNDERLINE + "https://bitbucket.org/Lythom/mccapsule/wiki/Commands");
        msg.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://bitbucket.org/Lythom/mccapsule/wiki/Commands"));
        sender.func_145747_a((ITextComponent)msg);
        return "/capsule <" + Joiner.on((String)"|").join((Object[])COMMAND_LIST) + ">";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        EntityPlayerMP player = null;
        switch (args.length) {
            case 1: {
                return CapsuleCommand.func_71530_a((String[])args, (String[])COMMAND_LIST);
            }
            case 2: {
                switch (args[0]) {
                    case "giveRandomLoot": {
                        return CapsuleCommand.func_71530_a((String[])args, (String[])server.func_71213_z());
                    }
                    case "setBaseColor": {
                        return CapsuleCommand.func_71530_a((String[])args, (String[])CapsuleLootEntry.COLOR_PALETTE);
                    }
                    case "setMaterialColor": {
                        return CapsuleCommand.func_71530_a((String[])args, (String[])CapsuleLootEntry.COLOR_PALETTE);
                    }
                    case "fromStructure": {
                        try {
                            player = CapsuleCommand.func_71521_c((ICommandSender)sender);
                        }
                        catch (PlayerNotFoundException playerNotFoundException) {
                            // empty catch block
                        }
                        if (player != null) {
                            String[] structuresList = new File(player.func_71121_q().func_72860_G().func_75765_b(), "structures").list();
                            if (structuresList != null) return CapsuleCommand.func_71530_a((String[])args, (String[])structuresList);
                            return new ArrayList<String>();
                        }
                    }
                    case "fromExistingReward": {
                        try {
                            player = CapsuleCommand.func_71521_c((ICommandSender)sender);
                        }
                        catch (PlayerNotFoundException structuresList) {
                            // empty catch block
                        }
                        if (player == null) return Collections.emptyList();
                        String[] rewardsList = new File(Config.rewardTemplatesPath).list();
                        if (rewardsList != null) return CapsuleCommand.func_71530_a((String[])args, (String[])rewardsList);
                        return new ArrayList<String>();
                    }
                }
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1 || "help".equalsIgnoreCase(args[0])) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = null;
        if (sender instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)sender;
        }
        if ("giveEmpty".equalsIgnoreCase(args[0])) {
            if (player == null) return;
            ItemStack capsule = CapsuleItem.createEmptyCapsule(0xFFFFFF, 0xFFFFFF, args.length >= 2 ? Integer.decode(args[1]) : 3, args.length >= 3 && Boolean.valueOf(args[2]) != false, null, null);
            this.giveCapsule(capsule, (EntityPlayer)player);
            return;
        }
        if ("exportHeldItem".equalsIgnoreCase(args[0])) {
            ItemStack heldItem;
            if (args.length != 1) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            if (player == null || (heldItem = player.func_184614_ca()) == null) return;
            String command = "/give @p " + heldItem.func_77973_b().getRegistryName().toString() + " 1 " + heldItem.func_77952_i();
            if (heldItem.func_77942_o()) {
                command = command + " " + heldItem.func_77978_p().toString();
            }
            TextComponentString msg = new TextComponentString(command);
            msg.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Copy/Paste from client log (click to open)")));
            msg.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, "logs/latest.log"));
            player.func_145747_a((ITextComponent)msg);
            return;
        }
        if ("exportSeenBlock".equalsIgnoreCase(args[0])) {
            if (args.length != 1) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            if (player == null) return;
            if (!server.func_71262_S()) {
                RayTraceResult rtc = Helpers.clientRayTracePreview((EntityPlayer)player, Minecraft.func_71410_x().func_184121_ak());
                if (rtc == null || rtc.field_72313_a != RayTraceResult.Type.BLOCK) return;
                BlockPos position = rtc.func_178782_a();
                IBlockState state = player.func_71121_q().func_180495_p(position);
                TileEntity tileentity = player.func_71121_q().func_175625_s(position);
                String command = "/give @p " + state.func_177230_c().getRegistryName().toString() + " 1 " + state.func_177230_c().func_176201_c(state);
                if (tileentity != null) {
                    command = command + " {BlockEntityTag:" + tileentity.serializeNBT().toString() + "}";
                }
                TextComponentString msg = new TextComponentString(command);
                msg.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Copy/Paste from client log (click to open)")));
                msg.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, "logs/latest.log"));
                player.func_145747_a((ITextComponent)msg);
                return;
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString("This command only works on an integrated server, not on an dedicated one"));
            }
            return;
        }
        if ("setAuthor".equalsIgnoreCase(args[0])) {
            ItemStack heldItem;
            if (args.length != 1 && args.length != 2) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            if (player == null || (heldItem = player.func_184614_ca()) == null || !(heldItem.func_77973_b() instanceof CapsuleItem) || !heldItem.func_77942_o()) return;
            if (args.length == 2) {
                String author = args[1];
                heldItem.func_77978_p().func_74778_a("author", args[1]);
                Pair<CapsuleTemplateManager, CapsuleTemplate> templatepair = StructureSaver.getTemplate(heldItem, player.func_71121_q());
                CapsuleTemplate template = (CapsuleTemplate)templatepair.getRight();
                CapsuleTemplateManager templatemanager = (CapsuleTemplateManager)templatepair.getLeft();
                if (template == null || templatemanager == null) return;
                template.setAuthor(author);
                templatemanager.writeTemplate(server, new ResourceLocation(CapsuleItem.getStructureName(heldItem)));
                return;
            } else {
                heldItem.func_77978_p().func_82580_o("author");
                Pair<CapsuleTemplateManager, CapsuleTemplate> templatepair = StructureSaver.getTemplate(heldItem, player.func_71121_q());
                CapsuleTemplate template = (CapsuleTemplate)templatepair.getRight();
                CapsuleTemplateManager templatemanager = (CapsuleTemplateManager)templatepair.getLeft();
                if (template == null || templatemanager == null) return;
                template.setAuthor("?");
                templatemanager.writeTemplate(server, new ResourceLocation(CapsuleItem.getStructureName(heldItem)));
            }
            return;
        }
        if ("setBaseColor".equalsIgnoreCase(args[0])) {
            ItemStack heldItem;
            if (args.length != 2) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            int color = 0;
            try {
                color = Integer.decode(args[1]);
            }
            catch (NumberFormatException e) {
                throw new WrongUsageException("Color parameter must be a valid integer. ie. 0xCC3D2E or 123456", new Object[0]);
            }
            if (player == null || (heldItem = player.func_184614_ca()) == null || !(heldItem.func_77973_b() instanceof CapsuleItem)) return;
            CapsuleItem.setBaseColor(heldItem, color);
            return;
        }
        if ("setMaterialColor".equalsIgnoreCase(args[0])) {
            ItemStack heldItem;
            if (args.length != 2) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            int color = 0;
            try {
                color = Integer.decode(args[1]);
            }
            catch (NumberFormatException e) {
                throw new WrongUsageException("Color parameter must be a valid integer. ie. 0xCC3D2E or 123456", new Object[0]);
            }
            if (player == null || (heldItem = player.func_184614_ca()) == null || !(heldItem.func_77973_b() instanceof CapsuleItem)) return;
            CapsuleItem.setMaterialColor(heldItem, color);
            return;
        }
        if ("fromHeldCapsule".equalsIgnoreCase(args[0])) {
            ItemStack heldItem;
            if (args.length != 1 && args.length != 2) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            if (player == null || (heldItem = player.func_184614_ca()) == null || !(heldItem.func_77973_b() instanceof CapsuleItem) || !heldItem.func_77942_o()) return;
            String outputName = args.length == 1 ? heldItem.func_77978_p().func_74779_i("label") : args[1];
            if (Strings.isNullOrEmpty((String)outputName)) {
                throw new WrongUsageException("/capsule fromHeldCapsule [outputName]. Please label the held capsule or provide an output name to be used for output template.", new Object[0]);
            }
            Pair<CapsuleTemplateManager, CapsuleTemplate> sourcetemplatepair = StructureSaver.getTemplate(heldItem, player.func_71121_q());
            NBTTagCompound data = new NBTTagCompound();
            ((CapsuleTemplate)sourcetemplatepair.getRight()).writeToNBT(data);
            ResourceLocation destinationLocation = new ResourceLocation(Config.rewardTemplatesPath + "/" + outputName);
            CapsuleTemplateManager destManager = StructureSaver.getRewardManager(server);
            CapsuleTemplate destTemplate = destManager.getTemplate(server, destinationLocation);
            destTemplate.read(data);
            destManager.writeTemplate(server, destinationLocation);
            ItemStack capsule = CapsuleItem.createRewardCapsule(destinationLocation.toString(), CapsuleItem.getBaseColor(heldItem), CapsuleItem.getMaterialColor(heldItem), CapsuleItem.getSize(heldItem), outputName, CapsuleItem.getAuthor(heldItem));
            this.giveCapsule(capsule, (EntityPlayer)player);
            return;
        } else if ("fromStructure".equalsIgnoreCase(args[0])) {
            if (args.length == 1) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            StringBuilder structureNameB = new StringBuilder();
            for (int i = 1; i < args.length; ++i) {
                structureNameB.append(args[i]);
                if (i >= args.length - 1) continue;
                structureNameB.append(" ");
            }
            String structureName = structureNameB.toString().replaceAll(".nbt", "");
            if (player == null || structureName == null || !(player.field_70170_p instanceof WorldServer)) return;
            TemplateManager templatemanager = player.func_71121_q().func_184163_y();
            Template template = templatemanager.func_189942_b(server, new ResourceLocation(structureName));
            if (template == null) throw new CommandException("Structure \"%s\" not found ", new Object[]{structureName});
            int size = Math.max(template.func_186259_a().func_177958_n(), Math.max(template.func_186259_a().func_177956_o(), template.func_186259_a().func_177952_p()));
            if (size % 2 == 1) {
                ++size;
            }
            NBTTagCompound data = new NBTTagCompound();
            template.func_189552_a(data);
            ResourceLocation destinationLocation = new ResourceLocation(Config.rewardTemplatesPath + "/" + structureName);
            CapsuleTemplateManager destManager = StructureSaver.getRewardManager(server);
            CapsuleTemplate destTemplate = destManager.getTemplate(server, destinationLocation);
            destTemplate.read(data);
            destManager.writeTemplate(server, destinationLocation);
            ItemStack capsule = CapsuleItem.createRewardCapsule(destinationLocation.toString(), CapsuleLootEntry.getRandomColor(), CapsuleLootEntry.getRandomColor(), size, structureName, template.func_186261_b());
            this.giveCapsule(capsule, (EntityPlayer)player);
            return;
        } else if ("fromExistingReward".equalsIgnoreCase(args[0])) {
            if (args.length == 1) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            StringBuilder structureNameB = new StringBuilder();
            for (int i = 1; i < args.length; ++i) {
                structureNameB.append(args[i]);
                if (i >= args.length - 1) continue;
                structureNameB.append(" ");
            }
            String structureName = structureNameB.toString().replaceAll(".nbt", "");
            if (player == null || structureName == null || !(player.field_70170_p instanceof WorldServer)) return;
            String stucturePath = Config.rewardTemplatesPath + "/" + structureName;
            CapsuleTemplate template = (CapsuleTemplate)StructureSaver.getTemplateForReward(server, stucturePath).getRight();
            if (template == null) throw new CommandException("Reward Capsule \"%s\" not found ", new Object[]{structureName});
            int size = Math.max(template.getSize().func_177958_n(), Math.max(template.getSize().func_177956_o(), template.getSize().func_177952_p()));
            if (size % 2 == 1) {
                ++size;
            }
            ItemStack capsule = CapsuleItem.createRewardCapsule(stucturePath, CapsuleLootEntry.getRandomColor(), CapsuleLootEntry.getRandomColor(), size, structureName, template.getAuthor());
            this.giveCapsule(capsule, (EntityPlayer)player);
            return;
        } else if ("giveRandomLoot".equalsIgnoreCase(args[0])) {
            if (args.length != 1 && args.length != 2) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            if (args.length == 2) {
                player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
            }
            if (player == null) return;
            LootContext.Builder lootcontext$builder = new LootContext.Builder(player.func_71121_q());
            ArrayList loots = new ArrayList();
            CapsuleLootTableHook.capsulePool.func_186449_b(loots, new Random(), lootcontext$builder.func_186471_a());
            if (loots.size() <= 0) {
                player.func_145747_a((ITextComponent)new TextComponentString("No loot this time !"));
                return;
            } else {
                for (ItemStack loot : loots) {
                    this.giveCapsule(loot, (EntityPlayer)player);
                }
            }
            return;
        } else {
            if (!"reloadLootList".equalsIgnoreCase(args[0])) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            if (args.length != 1) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            StructureSaver.loadLootList(server);
        }
    }

    private void giveCapsule(ItemStack capsule, EntityPlayer player) {
        EntityItem entity = new EntityItem(player.field_70170_p, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), capsule);
        entity.func_174868_q();
        entity.func_70100_b_(player);
    }
}

