/*
 * Decompiled with CFR 0.152.
 */
package capsule.enchantments;

import capsule.enchantments.Enchantments;
import capsule.items.CapsuleItem;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class RecallEnchant
extends Enchantment {
    protected RecallEnchant(ResourceLocation enchName, Enchantment.Rarity rarity, EnumEnchantmentType enchType) {
        super(rarity, enchType, EntityEquipmentSlot.values());
        this.func_77322_b("recall");
        this.setRegistryName(enchName);
    }

    public boolean func_92089_a(ItemStack stack) {
        return this.canApplyAtEnchantingTable(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return stack.func_77973_b() instanceof CapsuleItem || this.field_77351_y != null && super.canApplyAtEnchantingTable(stack);
    }

    public int func_77321_a(int enchantmentLevel) {
        return 1;
    }

    public int func_77317_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + 40;
    }

    public int func_77325_b() {
        return 1;
    }

    public void pickupItemBack(EntityItem entity, EntityPlayer player) {
        if (player != null) {
            entity.func_174868_q();
            entity.func_70100_b_(player);
        }
    }

    @SubscribeEvent
    public void onWorldTickEvent(TickEvent.WorldTickEvent wte) {
        if (wte.side == Side.CLIENT || wte.phase != TickEvent.Phase.END) {
            return;
        }
        WorldServer world = (WorldServer)wte.world;
        List recallEntities = world.func_175644_a(EntityItem.class, Enchantments.hasRecallEnchant::test);
        for (EntityItem entity : recallEntities) {
            if (entity.func_145800_j() == null || !entity.field_70132_H && !entity.func_180799_ab() && !entity.func_70090_H()) continue;
            if (!entity.func_180799_ab()) {
                entity.func_70071_h_();
            }
            if (entity.field_70128_L) continue;
            this.pickupItemBack(entity, world.func_72924_a(entity.func_145800_j()));
        }
    }
}

