/*
 * Decompiled with CFR 0.152.
 */
package capsule.items;

import capsule.CommonProxy;
import capsule.Config;
import capsule.Helpers;
import capsule.Main;
import capsule.StructureSaver;
import capsule.blocks.BlockCapsuleMarker;
import capsule.items.CapsuleItemsRegistrer;
import capsule.network.CapsuleContentPreviewQueryToServer;
import capsule.network.CapsuleThrowQueryToServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleItem
extends Item {
    public static final int ACTIVE_DURATION_IN_TICKS = 60;
    public static final int STATE_EMPTY = 0;
    public static final int STATE_EMPTY_ACTIVATED = 4;
    public static final int STATE_ACTIVATED = 1;
    public static final int STATE_LINKED = 2;
    public static final int STATE_DEPLOYED = 3;
    public static final int STATE_ONE_USE = 5;
    public static final int STATE_ONE_USE_ACTIVATED = 6;
    public static final int CAPSULE_MAX_CAPTURE_SIZE = 31;
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleItem.class);
    public static final float TO_RAD = (float)Math.PI / 180;
    public static final float MAX_BLOCKS_PER_TICK_THROW = 1.2f;
    public static final float GRAVITY_PER_TICK = 0.04f;

    public CapsuleItem(String unlocalizedName) {
        this.func_77627_a(true);
        this.func_77655_b(unlocalizedName);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    public static ItemStack createEmptyCapsule(int baseColor, int materialColor, int size, boolean overpowered, @Nullable String label, @Nullable Integer upgraded) {
        ItemStack capsule = new ItemStack(CapsuleItemsRegistrer.capsule, 1, 0);
        Helpers.setColor(capsule, baseColor);
        capsule.func_77983_a("color", (NBTBase)new NBTTagInt(materialColor));
        capsule.func_77983_a("size", (NBTBase)new NBTTagInt(size));
        if (upgraded != null) {
            capsule.func_77983_a("upgraded", (NBTBase)new NBTTagInt(upgraded.intValue()));
        }
        if (overpowered) {
            capsule.func_77983_a("overpowered", (NBTBase)new NBTTagByte(1));
        }
        if (label != null) {
            capsule.func_77983_a("label", (NBTBase)new NBTTagString(label));
        }
        return capsule;
    }

    public static ItemStack createRewardCapsule(String structureName, int baseColor, int materialColor, int size, @Nullable String label, @Nullable String author) {
        ItemStack capsule = CapsuleItem.createEmptyCapsule(baseColor, materialColor, size, false, label, null);
        CapsuleItem.setIsReward(capsule);
        CapsuleItem.setOneUse(capsule);
        CapsuleItem.setStructureName(capsule, structureName);
        CapsuleItem.setAuthor(capsule, author);
        return capsule;
    }

    public static boolean isOneUse(ItemStack stack) {
        return stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("oneUse") && stack.func_77978_p().func_74767_n("oneUse");
    }

    public static void setOneUse(ItemStack capsule) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        capsule.func_77964_b(5);
        capsule.func_77978_p().func_74757_a("oneUse", true);
    }

    public static boolean isReward(ItemStack stack) {
        return stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("isReward") && stack.func_77978_p().func_74767_n("isReward") && CapsuleItem.isOneUse(stack);
    }

    public static void setIsReward(ItemStack capsule) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        capsule.func_77978_p().func_74757_a("isReward", true);
        CapsuleItem.setOneUse(capsule);
    }

    public static boolean isLinked(ItemStack stack) {
        return stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("structureName");
    }

    public static String getLabel(ItemStack stack) {
        if (stack == null) {
            return "";
        }
        if (!CapsuleItem.isLinked(stack)) {
            return I18n.func_74838_a((String)"item.capsule.content_empty");
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("label") && !"".equals(stack.func_77978_p().func_74779_i("label"))) {
            return "\u201c" + TextFormatting.ITALIC + stack.func_77978_p().func_74779_i("label") + TextFormatting.RESET + "\u201d";
        }
        return I18n.func_74838_a((String)"item.capsule.content_unlabeled");
    }

    public static void setLabel(ItemStack capsule, String label) {
        if (capsule != null && !capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        capsule.func_77978_p().func_74778_a("label", label);
    }

    public static int getSize(ItemStack itemStackIn) {
        int size = 1;
        if (itemStackIn != null && itemStackIn.func_77942_o() && itemStackIn.func_77978_p().func_74764_b("size")) {
            size = itemStackIn.func_77978_p().func_74762_e("size");
        }
        if (size > 31) {
            size = 31;
            itemStackIn.func_77978_p().func_74768_a("size", size);
            LOGGER.error("Capsule sizes are capped to 31. Resized to : " + size);
        } else if (size % 2 == 0) {
            itemStackIn.func_77978_p().func_74768_a("size", --size);
            LOGGER.error("Capsule size must be an odd number to achieve consistency on deployment. Resized to : " + size);
        }
        return size;
    }

    public static void setSize(ItemStack capsule, int size) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        if (size > 31) {
            size = 31;
            LOGGER.warn("Capsule sizes are capped to 31. Resized to : " + size);
        } else if (size % 2 == 0) {
            LOGGER.warn("Capsule size must be an odd number to achieve consistency on deployment. Resized to : " + --size);
        }
        capsule.func_77978_p().func_74768_a("size", size);
    }

    public static String getStructureName(ItemStack capsule) {
        String name = null;
        if (capsule != null && capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("structureName")) {
            name = capsule.func_77978_p().func_74779_i("structureName");
        }
        return name;
    }

    public static void setStructureName(ItemStack capsule, String structureName) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        capsule.func_77978_p().func_74778_a("structureName", structureName);
    }

    public static String getAuthor(ItemStack capsule) {
        String name = null;
        if (capsule != null && capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("author")) {
            name = capsule.func_77978_p().func_74779_i("author");
        }
        return name;
    }

    public static void setAuthor(ItemStack capsule, String author) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        if (!Strings.isNullOrEmpty((String)author)) {
            capsule.func_77978_p().func_74778_a("author", author);
        }
    }

    public static int getBaseColor(ItemStack capsule) {
        return Helpers.getColor(capsule);
    }

    public static void setBaseColor(ItemStack capsule, int color) {
        Helpers.setColor(capsule, color);
    }

    public static int getMaterialColor(ItemStack capsule) {
        int color = 0;
        if (capsule != null && capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("color")) {
            color = capsule.func_77978_p().func_74762_e("color");
        }
        return color;
    }

    public static void setMaterialColor(ItemStack capsule, int color) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        capsule.func_77978_p().func_74768_a("color", color);
    }

    public static int getUpgradeLevel(ItemStack stack) {
        int upgradeLevel = 0;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("upgraded")) {
            upgradeLevel = stack.func_77978_p().func_74762_e("upgraded");
        }
        return upgradeLevel;
    }

    public static void setUpgradeLevel(ItemStack capsule, int upgrades) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        capsule.func_77978_p().func_74768_a("upgraded", upgrades);
    }

    public static Integer getDimension(ItemStack capsule) {
        Integer dim = null;
        if (capsule != null && capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("spawnPosition")) {
            dim = capsule.func_77978_p().func_74775_l("spawnPosition").func_74762_e("dim");
        }
        return dim;
    }

    public static void moveEntityItemToDeployPos(EntityItem entityItem, ItemStack capsule, boolean keepMomentum) {
        if (!capsule.func_77942_o()) {
            return;
        }
        BlockPos dest = BlockPos.func_177969_a((long)capsule.func_77978_p().func_74763_f("deployAt"));
        double diffX = (double)dest.func_177958_n() + 0.5 - entityItem.field_70165_t;
        double diffZ = (double)dest.func_177952_p() + 0.5 - entityItem.field_70161_v;
        double distance = MathHelper.func_76133_a((double)(diffX * diffX + diffZ * diffZ));
        double requiredVelocity = distance / 10.0;
        double velocity = Math.min(requiredVelocity, (double)1.2f);
        double normalizedDiffX = diffX / distance;
        double normalizedDiffZ = diffZ / distance;
        entityItem.field_70159_w = keepMomentum ? 0.9 * entityItem.field_70159_w + 0.1 * normalizedDiffX * velocity : normalizedDiffX * velocity;
        entityItem.field_70179_y = keepMomentum ? 0.9 * entityItem.field_70179_y + 0.1 * normalizedDiffZ * velocity : normalizedDiffZ * velocity;
    }

    public static void setState(ItemStack stack, int state) {
        stack.func_77964_b(state);
    }

    public static EntityItem throwCapsule(ItemStack itemStackIn, EntityPlayer playerIn, BlockPos destination) {
        double startPosition = playerIn.field_70163_u - 0.3 + (double)playerIn.func_70047_e();
        EntityItem entityitem = new EntityItem(playerIn.field_70170_p, playerIn.field_70165_t, startPosition, playerIn.field_70161_v, itemStackIn);
        entityitem.func_174867_a(20);
        entityitem.func_145799_b(playerIn.func_70005_c_());
        entityitem.func_174873_u();
        if (destination != null) {
            itemStackIn.func_77978_p().func_74772_a("deployAt", destination.func_177986_g());
            CapsuleItem.moveEntityItemToDeployPos(entityitem, itemStackIn, false);
            BlockPos playerPos = playerIn.func_180425_c();
            double diffX = (double)destination.func_177958_n() + 0.5 - (double)playerPos.func_177958_n();
            double diffZ = (double)destination.func_177952_p() + 0.5 - (double)playerPos.func_177952_p();
            double flatDistance = MathHelper.func_76133_a((double)(diffX * diffX + diffZ * diffZ));
            double diffY = (double)(destination.func_177956_o() - playerPos.func_177956_o()) + Math.min(1.0, flatDistance / 3.0);
            double yVelocity = diffY / 10.0 - -0.19999999552965164;
            entityitem.field_70181_x = Math.max(0.05, yVelocity);
        } else {
            float f = 0.5f;
            entityitem.field_70159_w = (double)(-MathHelper.func_76126_a((float)(playerIn.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(playerIn.field_70125_A * ((float)Math.PI / 180))) * f) + playerIn.field_70159_w;
            entityitem.field_70179_y = (double)(MathHelper.func_76134_b((float)(playerIn.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(playerIn.field_70125_A * ((float)Math.PI / 180))) * f) + playerIn.field_70179_y;
            entityitem.field_70181_x = (double)(-MathHelper.func_76126_a((float)(playerIn.field_70125_A * ((float)Math.PI / 180))) * f + 0.1f) + playerIn.field_70181_x;
        }
        playerIn.func_184816_a(entityitem);
        playerIn.field_71071_by.field_70462_a[playerIn.field_71071_by.field_70461_c] = null;
        playerIn.func_130014_f_().func_184133_a(null, entityitem.func_180425_c(), SoundEvents.field_187737_v, SoundCategory.BLOCKS, 0.2f, 0.1f);
        return entityitem;
    }

    public String func_77653_i(ItemStack stack) {
        String content;
        String name = I18n.func_74838_a((String)"item.capsule.name");
        String state = "";
        switch (stack.func_77952_i()) {
            case 1: 
            case 4: 
            case 6: {
                state = TextFormatting.DARK_GREEN + I18n.func_74838_a((String)"item.capsule.state_activated") + TextFormatting.RESET;
                break;
            }
            case 2: {
                state = "";
                break;
            }
            case 3: {
                state = I18n.func_74838_a((String)"item.capsule.state_deployed");
                break;
            }
            case 5: {
                state = CapsuleItem.isReward(stack) ? I18n.func_74838_a((String)"item.capsule.state_one_use") : I18n.func_74838_a((String)"item.capsule.state_recovery");
            }
        }
        if (state.length() > 0) {
            state = state + " ";
        }
        if ((content = CapsuleItem.getLabel(stack)).length() > 0) {
            content = content + " ";
        }
        return TextFormatting.RESET + state + content + name;
    }

    public int func_77619_b() {
        return 5;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.func_77619_b();
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.isOverpowered(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List tooltip, boolean advanced) {
        if (this.isOverpowered(stack)) {
            tooltip.add(TextFormatting.DARK_PURPLE + I18n.func_74838_a((String)"capsule.tooltip.overpowered") + TextFormatting.RESET);
        }
        int size = CapsuleItem.getSize(stack);
        String author = CapsuleItem.getAuthor(stack);
        if (author != null) {
            tooltip.add(TextFormatting.DARK_AQUA + "" + TextFormatting.ITALIC + I18n.func_74838_a((String)"capsule.tooltip.author") + " " + author + TextFormatting.RESET);
        }
        int upgradeLevel = CapsuleItem.getUpgradeLevel(stack);
        String sizeTxt = String.valueOf(size) + "\u00d7" + String.valueOf(size) + "\u00d7" + String.valueOf(size);
        if (upgradeLevel > 0) {
            sizeTxt = sizeTxt + " (" + upgradeLevel + "/" + Config.upgradeLimit + " " + I18n.func_74838_a((String)"capsule.tooltip.upgraded") + ")";
        }
        tooltip.add(I18n.func_74838_a((String)"capsule.tooltip.size") + ": " + sizeTxt);
        if (stack.func_77952_i() == 5) {
            tooltip.add(I18n.func_74838_a((String)"capsule.tooltip.one_use").trim());
        }
    }

    public boolean isOverpowered(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("overpowered") && stack.func_77978_p().func_74771_c("overpowered") == 1;
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List subItems) {
        ItemStack ironCapsule = new ItemStack(CapsuleItemsRegistrer.capsule, 1, 0);
        ironCapsule.func_77983_a("color", (NBTBase)new NBTTagInt(0xCCCCCC));
        ironCapsule.func_77983_a("size", (NBTBase)new NBTTagInt(Config.ironCapsuleSize));
        ItemStack goldCapsule = new ItemStack(CapsuleItemsRegistrer.capsule, 1, 0);
        goldCapsule.func_77983_a("color", (NBTBase)new NBTTagInt(16766720));
        goldCapsule.func_77983_a("size", (NBTBase)new NBTTagInt(Config.goldCapsuleSize));
        ItemStack diamondCapsule = new ItemStack(CapsuleItemsRegistrer.capsule, 1, 0);
        diamondCapsule.func_77983_a("color", (NBTBase)new NBTTagInt(65522));
        diamondCapsule.func_77983_a("size", (NBTBase)new NBTTagInt(Config.diamondCapsuleSize));
        ItemStack opCapsule = new ItemStack(CapsuleItemsRegistrer.capsule, 1, 0);
        opCapsule.func_77983_a("color", (NBTBase)new NBTTagInt(0xFFFFFF));
        opCapsule.func_77983_a("size", (NBTBase)new NBTTagInt(Config.opCapsuleSize));
        opCapsule.func_77983_a("overpowered", (NBTBase)new NBTTagByte(1));
        ItemStack unlabelledCapsule = ironCapsule.func_77946_l();
        unlabelledCapsule.func_77964_b(2);
        unlabelledCapsule.func_77978_p().func_74778_a("structureName", "(C-CreativeLinkedCapsule)");
        ItemStack recoveryCapsule = ironCapsule.func_77946_l();
        CapsuleItem.setOneUse(recoveryCapsule);
        unlabelledCapsule.func_77978_p().func_74778_a("structureName", "(C-CreativeOneUseCapsule)");
        subItems.add(ironCapsule);
        subItems.add(goldCapsule);
        subItems.add(diamondCapsule);
        subItems.add(opCapsule);
        subItems.add(unlabelledCapsule);
        subItems.add(recoveryCapsule);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        if (playerIn.func_70093_af() && (itemStackIn.func_77952_i() == 2 || itemStackIn.func_77952_i() == 3 || itemStackIn.func_77952_i() == 5)) {
            Main.proxy.openGuiScreen(playerIn);
        } else if (!worldIn.field_72995_K) {
            if (itemStackIn.func_77952_i() == 0 || itemStackIn.func_77952_i() == 2 || itemStackIn.func_77952_i() == 5) {
                if (itemStackIn.func_77952_i() == 0) {
                    CapsuleItem.setState(itemStackIn, 4);
                }
                if (itemStackIn.func_77952_i() == 2) {
                    CapsuleItem.setState(itemStackIn, 1);
                }
                if (itemStackIn.func_77952_i() == 5) {
                    CapsuleItem.setState(itemStackIn, 6);
                }
                NBTTagCompound timer = itemStackIn.func_179543_a("activetimer", true);
                timer.func_74768_a("starttime", playerIn.field_70173_aa);
                worldIn.func_184133_a(null, playerIn.func_180425_c(), SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.2f, 0.9f);
            } else if (itemStackIn.func_77952_i() == 3) {
                try {
                    this.resentToCapsule(itemStackIn, playerIn);
                    worldIn.func_184133_a(null, playerIn.func_180425_c(), SoundEvents.field_187837_fU, SoundCategory.BLOCKS, 0.2f, 0.4f);
                }
                catch (Exception e) {
                    LOGGER.error("Couldn't resend the content into the capsule", (Throwable)e);
                }
            }
        }
        if (worldIn.field_72995_K) {
            BlockPos anchor;
            if (itemStackIn.func_77942_o() && (itemStackIn.func_77952_i() == 2 || itemStackIn.func_77952_i() == 5) && (anchor = Minecraft.func_71410_x().field_71476_x.func_178782_a()) != null) {
                CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new CapsuleContentPreviewQueryToServer(itemStackIn.func_77978_p().func_74779_i("structureName")));
            }
            if (this.isActivated(itemStackIn)) {
                RayTraceResult rtr = CapsuleItem.isLinked(itemStackIn) ? Helpers.clientRayTracePreview(playerIn, 0.0f) : null;
                BlockPos dest = rtr != null && rtr.field_72313_a == RayTraceResult.Type.BLOCK ? rtr.func_178782_a().func_177971_a(rtr.field_178784_b.func_176730_m()) : null;
                CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new CapsuleThrowQueryToServer(dest));
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    private boolean isActivated(ItemStack itemStackIn) {
        return itemStackIn.func_77952_i() == 1 || itemStackIn.func_77952_i() == 4 || itemStackIn.func_77952_i() == 6;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K) {
            NBTTagCompound timer = stack.func_179543_a("activetimer", false);
            if (this.isActivated(stack) && timer != null && timer.func_74764_b("starttime") && entityIn.field_70173_aa >= timer.func_74762_e("starttime") + 60) {
                this.revertStateFromActivated(stack);
                worldIn.func_184133_a(null, entityIn.func_180425_c(), SoundEvents.field_187837_fU, SoundCategory.BLOCKS, 0.2f, 0.4f);
            }
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        super.onEntityItemUpdate(entityItem);
        ItemStack capsule = entityItem.func_92059_d();
        if (capsule == null) {
            return false;
        }
        if (!entityItem.field_70170_p.field_72995_K && entityItem.field_70132_H && entityItem.field_70173_aa > 2 && this.isActivated(capsule)) {
            entityItem.field_70159_w = 0.0;
            entityItem.field_70179_y = 0.0;
            entityItem.field_70181_x = 0.0;
            int size = CapsuleItem.getSize(capsule);
            int extendLength = (size - 1) / 2;
            WorldServer itemWorld = (WorldServer)entityItem.field_70170_p;
            if (CapsuleItem.isLinked(capsule)) {
                boolean deployed = this.deployCapsule(entityItem, capsule, extendLength, itemWorld);
                if (deployed) {
                    itemWorld.func_184133_a(null, entityItem.func_180425_c(), SoundEvents.field_187596_cD, SoundCategory.BLOCKS, 0.4f, 0.1f);
                }
                if (deployed && CapsuleItem.isOneUse(capsule)) {
                    entityItem.func_70106_y();
                }
            } else {
                try {
                    this.captureContentIntoCapsule(entityItem, capsule, size, extendLength, itemWorld);
                }
                catch (Exception e) {
                    LOGGER.error("Couldn't capture the content into the capsule", (Throwable)e);
                }
            }
        }
        if (!entityItem.field_70170_p.field_72995_K && !entityItem.field_70132_H && this.isActivated(capsule) && capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("deployAt")) {
            CapsuleItem.moveEntityItemToDeployPos(entityItem, capsule, true);
        }
        return false;
    }

    private boolean captureContentIntoCapsule(EntityItem entityItem, ItemStack capsule, int size, int extendLength, WorldServer playerWorld) {
        BlockPos marker = Helpers.findSpecificBlock(entityItem, size + 2, BlockCapsuleMarker.class);
        if (marker != null) {
            BlockPos source = marker.func_177982_a(-extendLength, 1, -extendLength);
            String player = "CapsuleMod";
            if (entityItem.func_145800_j() != null) {
                player = entityItem.func_145800_j();
            }
            String capsuleID = StructureSaver.getUniqueName(playerWorld, player);
            boolean storageOK = StructureSaver.store(playerWorld, entityItem.func_145800_j(), capsuleID, source, size, this.getExcludedBlocs(capsule), null);
            if (storageOK) {
                CapsuleItem.setState(capsule, 2);
                CapsuleItem.setStructureName(capsule, capsuleID);
                return true;
            }
            this.revertStateFromActivated(capsule);
        } else {
            this.revertStateFromActivated(capsule);
            EntityPlayer player = playerWorld.func_72924_a(entityItem.func_145800_j());
            if (player != null) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.noCaptureBase", new Object[0]));
            }
        }
        return false;
    }

    private Map<BlockPos, Block> getOccupiedSourcePos(ItemStack capsule) {
        HashMap<BlockPos, Block> occupiedSources = new HashMap<BlockPos, Block>();
        if (capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("occupiedSpawnPositions")) {
            NBTTagList list = capsule.func_77978_p().func_150295_c("occupiedSpawnPositions", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound entry = list.func_150305_b(i);
                occupiedSources.put(BlockPos.func_177969_a((long)entry.func_74763_f("pos")), Block.func_149729_e((int)entry.func_74762_e("blockId")));
            }
        }
        return occupiedSources;
    }

    private Map<BlockPos, Block> setOccupiedSourcePos(ItemStack capsule, Map<BlockPos, Block> occupiedSpawnPositions) {
        HashMap<BlockPos, Block> occupiedSources = new HashMap<BlockPos, Block>();
        NBTTagList entries = new NBTTagList();
        if (occupiedSpawnPositions != null) {
            for (Map.Entry<BlockPos, Block> entry : occupiedSpawnPositions.entrySet()) {
                NBTTagCompound nbtEntry = new NBTTagCompound();
                nbtEntry.func_74772_a("pos", entry.getKey().func_177986_g());
                nbtEntry.func_74768_a("blockId", Block.func_149682_b((Block)entry.getValue()));
                entries.func_74742_a((NBTBase)nbtEntry);
            }
        }
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        capsule.func_77978_p().func_74782_a("occupiedSpawnPositions", (NBTBase)entries);
        return occupiedSources;
    }

    private void revertStateFromActivated(ItemStack capsule) {
        if (CapsuleItem.isOneUse(capsule)) {
            CapsuleItem.setState(capsule, 5);
        } else if (CapsuleItem.isLinked(capsule)) {
            CapsuleItem.setState(capsule, 2);
        } else {
            CapsuleItem.setState(capsule, 0);
        }
        if (capsule.func_77942_o()) {
            capsule.func_77978_p().func_82580_o("activetimer");
        }
    }

    private boolean deployCapsule(EntityItem entityItem, ItemStack capsule, int extendLength, WorldServer playerWorld) {
        BlockPos dest;
        boolean didSpawn = false;
        if (capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("deployAt")) {
            BlockPos centerDest = BlockPos.func_177969_a((long)capsule.func_77978_p().func_74763_f("deployAt"));
            dest = centerDest.func_177982_a(-extendLength, 0, -extendLength);
            capsule.func_77978_p().func_82580_o("deployAt");
        } else {
            BlockPos bottomBlockPos = Helpers.findBottomBlock(entityItem);
            dest = bottomBlockPos.func_177982_a(-extendLength, 1, -extendLength);
        }
        String structureName = capsule.func_77978_p().func_74779_i("structureName");
        HashMap<BlockPos, Block> occupiedSpawnPositions = new HashMap<BlockPos, Block>();
        ArrayList<String> outEntityBlocking = new ArrayList<String>();
        boolean result = StructureSaver.deploy(capsule, playerWorld, entityItem.func_145800_j(), dest, Config.overridableBlocks, occupiedSpawnPositions, outEntityBlocking);
        if (result) {
            this.setOccupiedSourcePos(capsule, occupiedSpawnPositions);
            if (!CapsuleItem.isReward(capsule)) {
                CapsuleItem.setState(capsule, 3);
                this.saveSpawnPosition(capsule, dest, entityItem.func_130014_f_().field_73011_w.getDimension());
                StructureSaver.clearTemplate(playerWorld, structureName);
            }
            didSpawn = true;
        } else {
            this.revertStateFromActivated(capsule);
        }
        return didSpawn;
    }

    private void resentToCapsule(ItemStack itemStackIn, EntityPlayer playerIn) {
        Integer dimensionId = CapsuleItem.getDimension(itemStackIn);
        MinecraftServer server = playerIn.func_184102_h();
        WorldServer capsuleWorld = dimensionId != null ? server.func_71218_a(dimensionId.intValue()) : (WorldServer)playerIn.func_130014_f_();
        NBTTagCompound spawnPos = itemStackIn.func_77978_p().func_74775_l("spawnPosition");
        BlockPos source = new BlockPos(spawnPos.func_74762_e("x"), spawnPos.func_74762_e("y"), spawnPos.func_74762_e("z"));
        int size = CapsuleItem.getSize(itemStackIn);
        boolean storageOK = StructureSaver.store(capsuleWorld, playerIn.func_70005_c_(), itemStackIn.func_77978_p().func_74779_i("structureName"), source, size, this.getExcludedBlocs(itemStackIn), this.getOccupiedSourcePos(itemStackIn));
        if (storageOK) {
            CapsuleItem.setState(itemStackIn, 2);
            itemStackIn.func_77978_p().func_82580_o("spawnPosition");
            itemStackIn.func_77978_p().func_82580_o("occupiedSpawnPositions");
        } else {
            LOGGER.error("Error occured during undeploy of capsule.");
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.technicalError", new Object[0]));
        }
    }

    public List<Block> getExcludedBlocs(ItemStack stack) {
        List<Block> excludedBlocks = Config.excludedBlocks;
        if (this.isOverpowered(stack)) {
            excludedBlocks = Config.opExcludedBlocks;
        }
        return excludedBlocks;
    }

    public int getColorFromItemstack(ItemStack stack, int renderPass) {
        int color = 0xFFFFFF;
        if (renderPass == 0) {
            color = Helpers.getColor(stack);
        } else if (renderPass == 1) {
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("color")) {
                color = stack.func_77978_p().func_74762_e("color");
            }
        } else if (renderPass == 2) {
            color = 0xFFFFFF;
        }
        return color;
    }

    private void saveSpawnPosition(ItemStack capsule, BlockPos dest, int dimID) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound pos = new NBTTagCompound();
        pos.func_74768_a("x", dest.func_177958_n());
        pos.func_74768_a("y", dest.func_177956_o());
        pos.func_74768_a("z", dest.func_177952_p());
        pos.func_74768_a("dim", dimID);
        capsule.func_77978_p().func_74782_a("spawnPosition", (NBTBase)pos);
    }

    public void clearCapsule(ItemStack capsule) {
        CapsuleItem.setState(capsule, 0);
        if (!capsule.func_77942_o()) {
            return;
        }
        capsule.func_77978_p().func_82580_o("structureName");
    }
}

