/*
 * Decompiled with CFR 0.152.
 */
package capsule.loot;

import capsule.Config;
import capsule.StructureSaver;
import capsule.items.CapsuleItem;
import capsule.loot.LootPathData;
import capsule.structure.CapsuleTemplate;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Collection;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import org.apache.commons.lang3.tuple.Pair;

public class CapsuleLootEntry
extends LootEntry {
    public static String[] COLOR_PALETTE = new String[]{"0xCCCCCC", "0x549b57", "0xe08822", "0x5e8eb7", "0x6c6c6c", "0xbd5757", "0x99c33d", "0x4a4cba", "0x7b2e89", "0x95d5e7", "0xffffff"};
    private static Random random = new Random();
    private String templatesPath = null;

    protected CapsuleLootEntry(String templatesPath, int weightIn, int qualityIn, LootCondition[] conditionsIn, String entryName) {
        super(weightIn, qualityIn, conditionsIn, entryName);
        this.templatesPath = templatesPath;
    }

    public static int getRandomColor() {
        return Integer.decode(COLOR_PALETTE[(int)(Math.random() * (double)COLOR_PALETTE.length)]);
    }

    public void func_186363_a(Collection<ItemStack> stacks, Random rand, LootContext context) {
        Pair<String, CapsuleTemplate> templatePair;
        if (this.templatesPath == null) {
            return;
        }
        if (LootConditionManager.func_186638_a((LootCondition[])this.field_186366_e, (Random)rand, (LootContext)context) && Config.lootTemplatesData.containsKey(this.templatesPath) && (templatePair = this.getRandomTemplate(context)) != null) {
            CapsuleTemplate template = (CapsuleTemplate)templatePair.getRight();
            String templatePath = (String)templatePair.getLeft();
            int size = Math.max(template.getSize().func_177958_n(), Math.max(template.getSize().func_177956_o(), template.getSize().func_177952_p()));
            String[] path = templatePath.split("/");
            if (path.length == 0) {
                return;
            }
            ItemStack capsule = CapsuleItem.createRewardCapsule(templatePath, CapsuleLootEntry.getRandomColor(), CapsuleLootEntry.getRandomColor(), size, path[path.length - 1], template.getAuthor());
            stacks.add(capsule);
        }
    }

    public Pair<String, CapsuleTemplate> getRandomTemplate(LootContext context) {
        LootPathData lpd = Config.lootTemplatesData.get(this.templatesPath);
        if (lpd == null || lpd.files == null) {
            StructureSaver.loadLootList(context.getWorld().func_73046_m());
            lpd = Config.lootTemplatesData.get(this.templatesPath);
        }
        if (lpd == null || lpd.files == null || lpd.files.isEmpty()) {
            return null;
        }
        int size = lpd.files.size();
        int initRand = random.nextInt(size);
        for (int i = 0; i < lpd.files.size(); ++i) {
            int ri = (initRand + i) % lpd.files.size();
            String structureName = lpd.files.get(ri);
            CapsuleTemplate template = (CapsuleTemplate)StructureSaver.getTemplateForReward(context.getWorld().func_73046_m(), this.templatesPath + "/" + structureName).getRight();
            if (template == null) continue;
            return Pair.of((Object)(this.templatesPath + "/" + structureName), (Object)template);
        }
        return null;
    }

    protected void func_186362_a(JsonObject json, JsonSerializationContext context) {
    }
}

