/*
 * Decompiled with CFR 0.152.
 */
package capsule.loot;

import capsule.Config;
import capsule.loot.CapsuleLootEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CapsuleLootTableHook {
    private static final int DEFAULT_WEIGHT = 3;
    public static List<String> allowedTables = Arrays.asList(LootTableList.field_186424_f.toString(), LootTableList.field_186429_k.toString(), LootTableList.field_186421_c.toString(), LootTableList.field_186431_m.toString(), LootTableList.field_186430_l.toString(), LootTableList.field_186422_d.toString(), LootTableList.field_186428_j.toString(), LootTableList.field_186427_i.toString(), LootTableList.field_186426_h.toString(), LootTableList.field_186423_e.toString(), LootTableList.field_186389_an.toString());
    public static LootPool capsulePool = null;

    @SubscribeEvent
    public void hookCapsulesOnLootTable(LootTableLoadEvent event) {
        if (!allowedTables.contains(event.getName().toString())) {
            return;
        }
        if (capsulePool == null) {
            ArrayList<CapsuleLootEntry> entries = new ArrayList<CapsuleLootEntry>();
            for (String path : Config.lootTemplatesPaths) {
                int weight = this.findConfiguredWeight(path);
                entries.add(new CapsuleLootEntry(path, weight, 0, new LootCondition[0], "capsule:capsuleLootsEntry" + path.replace("/", "_")));
            }
            capsulePool = new LootPool(entries.toArray(new LootEntry[0]), new LootCondition[0], new RandomValueRange(1.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), "capsulePool");
        }
        event.getTable().addPool(capsulePool);
    }

    public int findConfiguredWeight(String path) {
        int weight = 3;
        if (Config.lootTemplatesData.containsKey(path)) {
            weight = Config.lootTemplatesData.get((Object)path).weigth;
        }
        return weight;
    }
}

