/*
 * Decompiled with CFR 0.152.
 */
package capsule.network;

import capsule.StructureSaver;
import capsule.items.CapsuleItem;
import capsule.network.CapsuleContentPreviewAnswerToClient;
import capsule.network.CapsuleContentPreviewQueryToServer;
import capsule.structure.CapsuleTemplate;
import capsule.structure.CapsuleTemplateManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleContentPreviewQueryHandler
implements IMessageHandler<CapsuleContentPreviewQueryToServer, CapsuleContentPreviewAnswerToClient> {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleContentPreviewQueryHandler.class);

    public CapsuleContentPreviewAnswerToClient onMessage(CapsuleContentPreviewQueryToServer message, MessageContext ctx) {
        if (ctx.side != Side.SERVER) {
            LOGGER.error("AskCapsuleContentPreviewMessageToServer received on wrong side:" + ctx.side);
            return null;
        }
        if (!message.isMessageValid()) {
            LOGGER.error("AskCapsuleContentPreviewMessageToServer was invalid" + message.toString());
            return null;
        }
        EntityPlayerMP sendingPlayer = ctx.getServerHandler().field_147369_b;
        if (sendingPlayer == null) {
            LOGGER.error("EntityPlayerMP was null when AskCapsuleContentPreviewMessageToServer was received");
            return null;
        }
        ItemStack heldItem = sendingPlayer.func_184614_ca();
        if (heldItem == null || CapsuleItem.getStructureName(heldItem) == null || !(heldItem.func_77973_b() instanceof CapsuleItem)) {
            return null;
        }
        WorldServer serverworld = sendingPlayer.func_71121_q();
        Pair<CapsuleTemplateManager, CapsuleTemplate> templatepair = StructureSaver.getTemplate(heldItem, serverworld);
        CapsuleTemplate template = (CapsuleTemplate)templatepair.getRight();
        if (template != null) {
            List<Template.BlockInfo> blocksInfos = template.blocks;
            ArrayList<BlockPos> blockspos = new ArrayList<BlockPos>();
            for (Template.BlockInfo blockInfo : blocksInfos) {
                if (blockInfo.field_186243_b == Blocks.field_150350_a.func_176223_P()) continue;
                blockspos.add(blockInfo.field_186242_a);
            }
            return new CapsuleContentPreviewAnswerToClient(blockspos, message.getStructureName());
        }
        if (heldItem.func_77942_o()) {
            String structureName = heldItem.func_77978_p().func_74779_i("structureName");
            sendingPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.templateNotFound", new Object[]{structureName}));
        }
        return null;
    }
}

