/*
 * Decompiled with CFR 0.152.
 */
package capsule.network;

import capsule.items.CapsuleItem;
import capsule.network.LabelEditedMessageToServer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LabelEditedMessageToServerMessageHandler
implements IMessageHandler<LabelEditedMessageToServer, IMessage> {
    protected static final Logger LOGGER = LogManager.getLogger(LabelEditedMessageToServerMessageHandler.class);

    public IMessage onMessage(LabelEditedMessageToServer message, MessageContext ctx) {
        if (ctx.side != Side.SERVER) {
            LOGGER.error("LabelEditedMessageToServer received on wrong side:" + ctx.side);
            return null;
        }
        if (!message.isMessageValid()) {
            LOGGER.error("LabelEditedMessageToServer was invalid" + message.toString());
            return null;
        }
        EntityPlayerMP sendingPlayer = ctx.getServerHandler().field_147369_b;
        if (sendingPlayer == null) {
            LOGGER.error("EntityPlayerMP was null when LabelEditedMessageToServer was received");
            return null;
        }
        WorldServer playerWorldServer = sendingPlayer.func_71121_q();
        playerWorldServer.func_152344_a(() -> this.processMessage(message, sendingPlayer));
        return null;
    }

    void processMessage(LabelEditedMessageToServer message, EntityPlayerMP sendingPlayer) {
        ItemStack serverStack = sendingPlayer.func_184614_ca();
        if (serverStack != null && serverStack.func_77973_b() instanceof CapsuleItem) {
            CapsuleItem.setLabel(serverStack, message.getLabel());
        }
    }
}

