/*
 * Decompiled with CFR 0.152.
 */
package capsule.plugins.jei;

import capsule.Config;
import capsule.blocks.CapsuleBlocksRegistrer;
import capsule.items.CapsuleItem;
import capsule.items.CapsuleItemsRegistrer;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagInt;

@JEIPlugin
public class CapsulePlugin
extends BlankModPlugin {
    private static final int UPGRADE_STEP = 2;

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter(CapsuleItemsRegistrer.capsule, (ISubtypeRegistry.ISubtypeInterpreter)new CapsuleSubtypeInterpreter());
    }

    public void register(@Nonnull IModRegistry registry) {
        ArrayList<ShapelessRecipes> recipes = new ArrayList<ShapelessRecipes>();
        ItemStack ironCapsule = CapsuleItemsRegistrer.createCapsuleItemStack(0xCCCCCC, Config.ironCapsuleSize);
        ItemStack ironCapsuleUp = CapsuleItemsRegistrer.createCapsuleItemStack(0xCCCCCC, Config.ironCapsuleSize + 2);
        ironCapsuleUp.func_77983_a("upgraded", (NBTBase)new NBTTagInt(1));
        ItemStack ironCapsuleUpUp = CapsuleItemsRegistrer.createCapsuleItemStack(0xCCCCCC, Config.ironCapsuleSize + 4);
        ironCapsuleUpUp.func_77983_a("upgraded", (NBTBase)new NBTTagInt(2));
        ItemStack ironCapsuleUpUpUp = CapsuleItemsRegistrer.createCapsuleItemStack(0xCCCCCC, Config.ironCapsuleSize + 6);
        ironCapsuleUpUpUp.func_77983_a("upgraded", (NBTBase)new NBTTagInt(3));
        ItemStack ironCapsuleUpUpUpUp = CapsuleItemsRegistrer.createCapsuleItemStack(0xCCCCCC, Config.ironCapsuleSize + 8);
        ironCapsuleUpUpUpUp.func_77983_a("upgraded", (NBTBase)new NBTTagInt(4));
        ItemStack goldCapsule = CapsuleItemsRegistrer.createCapsuleItemStack(16766720, Config.goldCapsuleSize);
        ItemStack goldCapsuleUp = CapsuleItemsRegistrer.createCapsuleItemStack(16766720, Config.goldCapsuleSize + 2);
        goldCapsuleUp.func_77983_a("upgraded", (NBTBase)new NBTTagInt(1));
        goldCapsuleUp.func_77964_b(2);
        CapsuleItem.setStructureName(goldCapsuleUp, "JEIExemple");
        ItemStack diamondCapsule = CapsuleItemsRegistrer.createCapsuleItemStack(65522, Config.diamondCapsuleSize);
        ItemStack diamondCapsuleUp = CapsuleItemsRegistrer.createCapsuleItemStack(65522, Config.diamondCapsuleSize + 2);
        diamondCapsuleUp.func_77983_a("upgraded", (NBTBase)new NBTTagInt(1));
        diamondCapsuleUp.func_77964_b(2);
        CapsuleItem.setStructureName(diamondCapsuleUp, "JEIExemple");
        ItemStack opCapsule = CapsuleItemsRegistrer.createCapsuleItemStack(0xFFFFFF, Config.opCapsuleSize);
        opCapsule.func_77983_a("overpowered", (NBTBase)new NBTTagByte(1));
        ItemStack opCapsuleUp = CapsuleItemsRegistrer.createCapsuleItemStack(0xFFFFFF, Config.opCapsuleSize + 2);
        opCapsuleUp.func_77983_a("overpowered", (NBTBase)new NBTTagByte(1));
        opCapsuleUp.func_77964_b(2);
        CapsuleItem.setStructureName(opCapsuleUp, "JEIExemple");
        ItemStack unlabelledCapsule = ironCapsule.func_77946_l();
        unlabelledCapsule.func_77964_b(2);
        CapsuleItem.setStructureName(unlabelledCapsule, "JEIExemple");
        ItemStack unlabelledCapsuleGold = goldCapsule.func_77946_l();
        unlabelledCapsuleGold.func_77964_b(2);
        CapsuleItem.setStructureName(unlabelledCapsuleGold, "JEIExemple");
        ItemStack unlabelledCapsuleDiamond = diamondCapsule.func_77946_l();
        unlabelledCapsuleDiamond.func_77964_b(2);
        CapsuleItem.setStructureName(unlabelledCapsuleDiamond, "JEIExemple");
        ItemStack unlabelledCapsuleOP = opCapsule.func_77946_l();
        unlabelledCapsuleOP.func_77964_b(2);
        CapsuleItem.setStructureName(unlabelledCapsuleOP, "JEIExemple");
        ItemStack recoveryCapsule = ironCapsule.func_77946_l();
        CapsuleItem.setOneUse(recoveryCapsule);
        CapsuleItem.setStructureName(recoveryCapsule, "JEIExemple");
        ItemStack chorusFruitIS = new ItemStack(Items.field_185162_cT);
        if (Config.upgradeLimit > 0) {
            recipes.add(new ShapelessRecipes(ironCapsuleUp, Arrays.asList(ironCapsule, chorusFruitIS)));
        }
        if (Config.upgradeLimit > 1) {
            recipes.add(new ShapelessRecipes(ironCapsuleUpUp, Arrays.asList(ironCapsule, chorusFruitIS, chorusFruitIS)));
        }
        if (Config.upgradeLimit > 2) {
            recipes.add(new ShapelessRecipes(ironCapsuleUpUpUp, Arrays.asList(ironCapsule, chorusFruitIS, chorusFruitIS, chorusFruitIS)));
        }
        if (Config.upgradeLimit > 3) {
            recipes.add(new ShapelessRecipes(ironCapsuleUpUpUpUp, Arrays.asList(ironCapsule, chorusFruitIS, chorusFruitIS, chorusFruitIS, chorusFruitIS)));
        }
        recipes.add(new ShapelessRecipes(recoveryCapsule, Arrays.asList(unlabelledCapsule, new ItemStack(Items.field_151069_bo))));
        recipes.add(new ShapelessRecipes(ironCapsule, Arrays.asList(unlabelledCapsule)));
        registry.addRecipes(recipes);
        registry.addDescription(ironCapsule, new String[]{"jei.capsule.desc.capsule"});
        registry.addDescription(unlabelledCapsule, new String[]{"jei.capsule.desc.linkedCapsule"});
        registry.addDescription(recoveryCapsule, new String[]{"jei.capsule.desc.recoveryCapsule"});
        registry.addDescription(opCapsule, new String[]{"jei.capsule.desc.opCapsule"});
        registry.addDescription(new ItemStack((Block)CapsuleBlocksRegistrer.blockCapsuleMarker), new String[]{"jei.capsule.desc.capsuleMarker"});
    }

    private static class CapsuleSubtypeInterpreter
    implements ISubtypeRegistry.ISubtypeInterpreter {
        private CapsuleSubtypeInterpreter() {
        }

        public String getSubtypeInfo(@Nonnull ItemStack itemStack) {
            if (!(itemStack.func_77973_b() instanceof CapsuleItem)) {
                return null;
            }
            String isOP = String.valueOf(itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("overpowered") && itemStack.func_77978_p().func_74767_n("overpowered"));
            String capsuleState = String.valueOf(itemStack.func_77952_i());
            String capsuleColor = String.valueOf(CapsuleItem.getMaterialColor(itemStack));
            return capsuleState + capsuleColor + isOP;
        }
    }
}

