/*
 * Decompiled with CFR 0.152.
 */
package capsule.structure;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.PlacementSettings;

public class CapsulePlacementSettings
extends PlacementSettings {
    private Mirror mirror = Mirror.NONE;
    private Rotation rotation = Rotation.NONE;
    private boolean ignoreEntities = false;
    @Nullable
    private Block replacedBlock;
    @Nullable
    private ChunkPos chunk;
    @Nullable
    private StructureBoundingBox boundingBox;
    private boolean ignoreStructureBlock = true;
    private float field_189951_h = 1.0f;
    @Nullable
    private Random field_189952_i;
    @Nullable
    private Long field_189953_j;

    public CapsulePlacementSettings copy() {
        CapsulePlacementSettings placementsettings = new CapsulePlacementSettings();
        placementsettings.mirror = this.mirror;
        placementsettings.rotation = this.rotation;
        placementsettings.ignoreEntities = this.ignoreEntities;
        placementsettings.replacedBlock = this.replacedBlock;
        placementsettings.chunk = this.chunk;
        placementsettings.boundingBox = this.boundingBox;
        placementsettings.ignoreStructureBlock = this.ignoreStructureBlock;
        placementsettings.field_189951_h = this.field_189951_h;
        placementsettings.field_189952_i = this.field_189952_i;
        placementsettings.field_189953_j = this.field_189953_j;
        return placementsettings;
    }

    public CapsulePlacementSettings setChunk(ChunkPos chunkPosIn) {
        this.chunk = chunkPosIn;
        return this;
    }

    public Mirror func_186212_b() {
        return this.mirror;
    }

    public CapsulePlacementSettings setMirror(Mirror mirrorIn) {
        this.mirror = mirrorIn;
        return this;
    }

    public Rotation func_186215_c() {
        return this.rotation;
    }

    public CapsulePlacementSettings setRotation(Rotation rotationIn) {
        this.rotation = rotationIn;
        return this;
    }

    public boolean func_186221_e() {
        return this.ignoreEntities;
    }

    public CapsulePlacementSettings setIgnoreEntities(boolean ignoreEntitiesIn) {
        this.ignoreEntities = ignoreEntitiesIn;
        return this;
    }

    @Nullable
    public Block func_186219_f() {
        return this.replacedBlock;
    }

    public CapsulePlacementSettings setReplacedBlock(Block replacedBlockIn) {
        this.replacedBlock = replacedBlockIn;
        return this;
    }

    @Nullable
    public StructureBoundingBox func_186213_g() {
        if (this.boundingBox == null && this.chunk != null) {
            this.func_186224_i();
        }
        return this.boundingBox;
    }

    public CapsulePlacementSettings setBoundingBox(StructureBoundingBox boundingBoxIn) {
        this.boundingBox = boundingBoxIn;
        return this;
    }

    public boolean func_186227_h() {
        return this.ignoreStructureBlock;
    }

    public CapsulePlacementSettings setIgnoreStructureBlock(boolean ignoreStructureBlockIn) {
        this.ignoreStructureBlock = ignoreStructureBlockIn;
        return this;
    }

    public void func_186224_i() {
        this.boundingBox = this.getBoundingBoxFromChunk(this.chunk);
    }

    @Nullable
    private StructureBoundingBox getBoundingBoxFromChunk(@Nullable ChunkPos pos) {
        if (pos == null) {
            return null;
        }
        int i = pos.field_77276_a * 16;
        int j = pos.field_77275_b * 16;
        return new StructureBoundingBox(i, 0, j, i + 16 - 1, 255, j + 16 - 1);
    }
}

