/*
 * Decompiled with CFR 0.152.
 */
package capsule.structure;

import capsule.structure.CapsulePlacementSettings;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.Mirror;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.BlockRotationProcessor;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public class CapsuleTemplate {
    public final List<Template.BlockInfo> blocks = Lists.newArrayList();
    public final List<Template.EntityInfo> entities = Lists.newArrayList();
    public BlockPos size = BlockPos.field_177992_a;
    public String author = "?";

    public BlockPos getSize() {
        return this.size;
    }

    public void setAuthor(String authorIn) {
        this.author = authorIn;
    }

    public String getAuthor() {
        return this.author;
    }

    public void takeBlocksFromWorld(World worldIn, BlockPos startPos, BlockPos endPos, boolean takeEntities, @Nullable Block toIgnore) {
        if (endPos.func_177958_n() >= 1 && endPos.func_177956_o() >= 1 && endPos.func_177952_p() >= 1) {
            BlockPos blockpos = startPos.func_177971_a((Vec3i)endPos).func_177982_a(-1, -1, -1);
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPos blockpos1 = new BlockPos(Math.min(startPos.func_177958_n(), blockpos.func_177958_n()), Math.min(startPos.func_177956_o(), blockpos.func_177956_o()), Math.min(startPos.func_177952_p(), blockpos.func_177952_p()));
            BlockPos blockpos2 = new BlockPos(Math.max(startPos.func_177958_n(), blockpos.func_177958_n()), Math.max(startPos.func_177956_o(), blockpos.func_177956_o()), Math.max(startPos.func_177952_p(), blockpos.func_177952_p()));
            this.size = endPos;
            for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)blockpos1, (BlockPos)blockpos2)) {
                BlockPos blockpos3 = blockpos$mutableblockpos.func_177973_b((Vec3i)blockpos1);
                IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos);
                if (toIgnore != null && toIgnore == iblockstate.func_177230_c()) continue;
                TileEntity tileentity = worldIn.func_175625_s((BlockPos)blockpos$mutableblockpos);
                if (tileentity != null) {
                    NBTTagCompound nbttagcompound = tileentity.func_189515_b(new NBTTagCompound());
                    nbttagcompound.func_82580_o("x");
                    nbttagcompound.func_82580_o("y");
                    nbttagcompound.func_82580_o("z");
                    list1.add(new Template.BlockInfo(blockpos3, iblockstate, nbttagcompound));
                    continue;
                }
                if (!iblockstate.func_185913_b() && !iblockstate.func_185917_h()) {
                    list2.add(new Template.BlockInfo(blockpos3, iblockstate, (NBTTagCompound)null));
                    continue;
                }
                list.add(new Template.BlockInfo(blockpos3, iblockstate, (NBTTagCompound)null));
            }
            this.blocks.clear();
            this.blocks.addAll(list);
            this.blocks.addAll(list1);
            this.blocks.addAll(list2);
            if (takeEntities) {
                this.takeEntitiesFromWorld(worldIn, blockpos1, blockpos2.func_177982_a(1, 1, 1));
            } else {
                this.entities.clear();
            }
        }
    }

    private void takeEntitiesFromWorld(World worldIn, BlockPos startPos, BlockPos endPos) {
        List list = worldIn.func_175647_a(Entity.class, new AxisAlignedBB(startPos, endPos), (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity p_apply_1_) {
                return !(p_apply_1_ instanceof EntityPlayer);
            }
        });
        this.entities.clear();
        for (Entity entity : list) {
            Vec3d vec3d = new Vec3d(entity.field_70165_t - (double)startPos.func_177958_n(), entity.field_70163_u - (double)startPos.func_177956_o(), entity.field_70161_v - (double)startPos.func_177952_p());
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            entity.func_70039_c(nbttagcompound);
            BlockPos blockpos = entity instanceof EntityPainting ? ((EntityPainting)entity).func_174857_n().func_177973_b((Vec3i)startPos) : new BlockPos(vec3d);
            this.entities.add(new Template.EntityInfo(vec3d, blockpos, nbttagcompound));
        }
    }

    public Map<BlockPos, String> getDataBlocks(BlockPos pos, CapsulePlacementSettings placementIn) {
        HashMap map = Maps.newHashMap();
        StructureBoundingBox structureboundingbox = placementIn.func_186213_g();
        for (Template.BlockInfo template$blockinfo : this.blocks) {
            TileEntityStructure.Mode tileentitystructure$mode;
            IBlockState iblockstate;
            BlockPos blockpos = CapsuleTemplate.transformedBlockPos(placementIn, template$blockinfo.field_186242_a).func_177971_a((Vec3i)pos);
            if (structureboundingbox != null && !structureboundingbox.func_175898_b((Vec3i)blockpos) || (iblockstate = template$blockinfo.field_186243_b).func_177230_c() != Blocks.field_185779_df || template$blockinfo.field_186244_c == null || (tileentitystructure$mode = TileEntityStructure.Mode.valueOf((String)template$blockinfo.field_186244_c.func_74779_i("mode"))) != TileEntityStructure.Mode.DATA) continue;
            map.put(blockpos, template$blockinfo.field_186244_c.func_74779_i("metadata"));
        }
        return map;
    }

    public BlockPos calculateConnectedPos(CapsulePlacementSettings placementIn, BlockPos p_186262_2_, CapsulePlacementSettings p_186262_3_, BlockPos p_186262_4_) {
        BlockPos blockpos = CapsuleTemplate.transformedBlockPos(placementIn, p_186262_2_);
        BlockPos blockpos1 = CapsuleTemplate.transformedBlockPos(p_186262_3_, p_186262_4_);
        return blockpos.func_177973_b((Vec3i)blockpos1);
    }

    public static BlockPos transformedBlockPos(CapsulePlacementSettings placementIn, BlockPos p_186266_1_) {
        return CapsuleTemplate.transformedBlockPos(p_186266_1_, placementIn.func_186212_b(), placementIn.func_186215_c());
    }

    public void addBlocksToWorldChunk(World worldIn, BlockPos pos, CapsulePlacementSettings placementIn) {
        placementIn.func_186224_i();
        this.addBlocksToWorld(worldIn, pos, placementIn);
    }

    public void addBlocksToWorld(World worldIn, BlockPos pos, CapsulePlacementSettings placementIn) {
        this.addBlocksToWorld(worldIn, pos, (ITemplateProcessor)new BlockRotationProcessor(pos, (PlacementSettings)placementIn), placementIn, 2);
    }

    public void addBlocksToWorld(World worldIn, BlockPos pos, CapsulePlacementSettings placementIn, int flags) {
        this.addBlocksToWorld(worldIn, pos, (ITemplateProcessor)new BlockRotationProcessor(pos, (PlacementSettings)placementIn), placementIn, flags);
    }

    public void addBlocksToWorld(World p_189960_1_, BlockPos p_189960_2_, @Nullable ITemplateProcessor p_189960_3_, CapsulePlacementSettings p_189960_4_, int p_189960_5_) {
        if (!this.blocks.isEmpty() && this.size.func_177958_n() >= 1 && this.size.func_177956_o() >= 1 && this.size.func_177952_p() >= 1) {
            Block block = p_189960_4_.func_186219_f();
            StructureBoundingBox structureboundingbox = p_189960_4_.func_186213_g();
            for (Template.BlockInfo template$blockinfo : this.blocks) {
                TileEntity tileentity2;
                TileEntity tileentity;
                BlockPos blockpos = CapsuleTemplate.transformedBlockPos(p_189960_4_, template$blockinfo.field_186242_a).func_177971_a((Vec3i)p_189960_2_);
                Template.BlockInfo template$blockinfo1 = p_189960_3_ != null ? p_189960_3_.func_189943_a(p_189960_1_, blockpos, template$blockinfo) : template$blockinfo;
                if (template$blockinfo1 == null) continue;
                Block block1 = template$blockinfo1.field_186243_b.func_177230_c();
                if (block != null && block == block1 || p_189960_4_.func_186227_h() && block1 == Blocks.field_185779_df || structureboundingbox != null && !structureboundingbox.func_175898_b((Vec3i)blockpos)) continue;
                IBlockState iblockstate = template$blockinfo1.field_186243_b.func_185902_a(p_189960_4_.func_186212_b());
                IBlockState iblockstate1 = iblockstate.func_185907_a(p_189960_4_.func_186215_c());
                if (template$blockinfo1.field_186244_c != null && (tileentity = p_189960_1_.func_175625_s(blockpos)) != null) {
                    if (tileentity instanceof IInventory) {
                        ((IInventory)tileentity).func_174888_l();
                    }
                    p_189960_1_.func_180501_a(blockpos, Blocks.field_180401_cv.func_176223_P(), 4);
                }
                if (!p_189960_1_.func_180501_a(blockpos, iblockstate1, p_189960_5_) || template$blockinfo1.field_186244_c == null || (tileentity2 = p_189960_1_.func_175625_s(blockpos)) == null) continue;
                template$blockinfo1.field_186244_c.func_74768_a("x", blockpos.func_177958_n());
                template$blockinfo1.field_186244_c.func_74768_a("y", blockpos.func_177956_o());
                template$blockinfo1.field_186244_c.func_74768_a("z", blockpos.func_177952_p());
                tileentity2.func_145839_a(template$blockinfo1.field_186244_c);
                tileentity2.func_189668_a(p_189960_4_.func_186212_b());
                tileentity2.func_189667_a(p_189960_4_.func_186215_c());
            }
            for (Template.BlockInfo template$blockinfo2 : this.blocks) {
                TileEntity tileentity1;
                if (block != null && block == template$blockinfo2.field_186243_b.func_177230_c()) continue;
                BlockPos blockpos1 = CapsuleTemplate.transformedBlockPos(p_189960_4_, template$blockinfo2.field_186242_a).func_177971_a((Vec3i)p_189960_2_);
                if (structureboundingbox != null && !structureboundingbox.func_175898_b((Vec3i)blockpos1)) continue;
                p_189960_1_.func_175722_b(blockpos1, template$blockinfo2.field_186243_b.func_177230_c());
                if (template$blockinfo2.field_186244_c == null || (tileentity1 = p_189960_1_.func_175625_s(blockpos1)) == null) continue;
                tileentity1.func_70296_d();
            }
            if (!p_189960_4_.func_186221_e()) {
                this.addEntitiesToWorld(p_189960_1_, p_189960_2_, p_189960_4_.func_186212_b(), p_189960_4_.func_186215_c(), structureboundingbox, null);
            }
        }
    }

    private void addEntitiesToWorld(World worldIn, BlockPos pos, Mirror mirrorIn, Rotation rotationIn, @Nullable StructureBoundingBox aabb, List<Entity> spawnedEntities) {
        for (Template.EntityInfo template$entityinfo : this.entities) {
            Entity entity;
            BlockPos blockpos = CapsuleTemplate.transformedBlockPos(template$entityinfo.field_186248_b, mirrorIn, rotationIn).func_177971_a((Vec3i)pos);
            if (aabb != null && !aabb.func_175898_b((Vec3i)blockpos)) continue;
            NBTTagCompound nbttagcompound = template$entityinfo.field_186249_c;
            Vec3d vec3d = CapsuleTemplate.transformedVec3d(template$entityinfo.field_186247_a, mirrorIn, rotationIn);
            Vec3d vec3d1 = vec3d.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            NBTTagList nbttaglist = new NBTTagList();
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72450_a));
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72448_b));
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72449_c));
            nbttagcompound.func_74782_a("Pos", (NBTBase)nbttaglist);
            nbttagcompound.func_186854_a("UUID", UUID.randomUUID());
            try {
                entity = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)worldIn);
            }
            catch (Exception var15) {
                entity = null;
            }
            if (entity == null) continue;
            float f = entity.func_184217_a(mirrorIn);
            entity.func_70012_b(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, f += entity.field_70177_z - entity.func_184229_a(rotationIn), entity.field_70125_A);
            worldIn.func_72838_d(entity);
            if (spawnedEntities == null) continue;
            spawnedEntities.add(entity);
        }
    }

    public BlockPos transformedSize(Rotation rotationIn) {
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new BlockPos(this.size.func_177952_p(), this.size.func_177956_o(), this.size.func_177958_n());
            }
        }
        return this.size;
    }

    private static BlockPos transformedBlockPos(BlockPos pos, Mirror mirrorIn, Rotation rotationIn) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                k = -k;
                break;
            }
            case FRONT_BACK: {
                i = -i;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(k, j, -i);
            }
            case CLOCKWISE_90: {
                return new BlockPos(-k, j, i);
            }
            case CLOCKWISE_180: {
                return new BlockPos(-i, j, -k);
            }
        }
        return flag ? new BlockPos(i, j, k) : pos;
    }

    private static Vec3d transformedVec3d(Vec3d vec, Mirror mirrorIn, Rotation rotationIn) {
        double d0 = vec.field_72450_a;
        double d1 = vec.field_72448_b;
        double d2 = vec.field_72449_c;
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                d2 = 1.0 - d2;
                break;
            }
            case FRONT_BACK: {
                d0 = 1.0 - d0;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3d(d2, d1, 1.0 - d0);
            }
            case CLOCKWISE_90: {
                return new Vec3d(1.0 - d2, d1, d0);
            }
            case CLOCKWISE_180: {
                return new Vec3d(1.0 - d0, d1, 1.0 - d2);
            }
        }
        return flag ? new Vec3d(d0, d1, d2) : vec;
    }

    public BlockPos getZeroPositionWithTransform(BlockPos p_189961_1_, Mirror p_189961_2_, Rotation p_189961_3_) {
        int i = this.getSize().func_177958_n() - 1;
        int j = this.getSize().func_177952_p() - 1;
        int k = p_189961_2_ == Mirror.FRONT_BACK ? i : 0;
        int l = p_189961_2_ == Mirror.LEFT_RIGHT ? j : 0;
        BlockPos blockpos = p_189961_1_;
        switch (p_189961_3_) {
            case COUNTERCLOCKWISE_90: {
                blockpos = p_189961_1_.func_177982_a(l, 0, i - k);
                break;
            }
            case CLOCKWISE_90: {
                blockpos = p_189961_1_.func_177982_a(j - l, 0, k);
                break;
            }
            case CLOCKWISE_180: {
                blockpos = p_189961_1_.func_177982_a(i - k, 0, j - l);
                break;
            }
            case NONE: {
                blockpos = p_189961_1_.func_177982_a(k, 0, l);
            }
        }
        return blockpos;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        BasicPalette template$basicpalette = new BasicPalette();
        NBTTagList nbttaglist = new NBTTagList();
        for (Template.BlockInfo blockInfo : this.blocks) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74782_a("pos", (NBTBase)this.writeInts(blockInfo.field_186242_a.func_177958_n(), blockInfo.field_186242_a.func_177956_o(), blockInfo.field_186242_a.func_177952_p()));
            nbttagcompound.func_74768_a("state", template$basicpalette.idFor(blockInfo.field_186243_b));
            if (blockInfo.field_186244_c != null) {
                nbttagcompound.func_74782_a("nbt", (NBTBase)blockInfo.field_186244_c);
            }
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        NBTTagList nbttaglist1 = new NBTTagList();
        for (Template.EntityInfo template$entityinfo : this.entities) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74782_a("pos", (NBTBase)this.writeDoubles(template$entityinfo.field_186247_a.field_72450_a, template$entityinfo.field_186247_a.field_72448_b, template$entityinfo.field_186247_a.field_72449_c));
            nbttagcompound1.func_74782_a("blockPos", (NBTBase)this.writeInts(template$entityinfo.field_186248_b.func_177958_n(), template$entityinfo.field_186248_b.func_177956_o(), template$entityinfo.field_186248_b.func_177952_p()));
            if (template$entityinfo.field_186249_c != null) {
                nbttagcompound1.func_74782_a("nbt", (NBTBase)template$entityinfo.field_186249_c);
            }
            nbttaglist1.func_74742_a((NBTBase)nbttagcompound1);
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (IBlockState iblockstate : template$basicpalette) {
            nBTTagList.func_74742_a((NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)iblockstate));
        }
        nbt.func_74782_a("palette", (NBTBase)nBTTagList);
        nbt.func_74782_a("blocks", (NBTBase)nbttaglist);
        nbt.func_74782_a("entities", (NBTBase)nbttaglist1);
        nbt.func_74782_a("size", (NBTBase)this.writeInts(this.size.func_177958_n(), this.size.func_177956_o(), this.size.func_177952_p()));
        nbt.func_74768_a("version", 1);
        nbt.func_74778_a("author", this.author);
        return nbt;
    }

    public void read(NBTTagCompound compound) {
        this.blocks.clear();
        this.entities.clear();
        NBTTagList nbttaglist = compound.func_150295_c("size", 3);
        this.size = new BlockPos(nbttaglist.func_186858_c(0), nbttaglist.func_186858_c(1), nbttaglist.func_186858_c(2));
        this.author = compound.func_74779_i("author");
        BasicPalette template$basicpalette = new BasicPalette();
        NBTTagList nbttaglist1 = compound.func_150295_c("palette", 10);
        for (int i = 0; i < nbttaglist1.func_74745_c(); ++i) {
            template$basicpalette.addMapping(NBTUtil.func_190008_d((NBTTagCompound)nbttaglist1.func_150305_b(i)), i);
        }
        NBTTagList nbttaglist3 = compound.func_150295_c("blocks", 10);
        for (int j = 0; j < nbttaglist3.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound = nbttaglist3.func_150305_b(j);
            NBTTagList nbttaglist2 = nbttagcompound.func_150295_c("pos", 3);
            BlockPos blockpos = new BlockPos(nbttaglist2.func_186858_c(0), nbttaglist2.func_186858_c(1), nbttaglist2.func_186858_c(2));
            IBlockState iblockstate = template$basicpalette.stateFor(nbttagcompound.func_74762_e("state"));
            NBTTagCompound nbttagcompound1 = nbttagcompound.func_74764_b("nbt") ? nbttagcompound.func_74775_l("nbt") : null;
            this.blocks.add(new Template.BlockInfo(blockpos, iblockstate, nbttagcompound1));
        }
        NBTTagList nbttaglist4 = compound.func_150295_c("entities", 10);
        for (int k = 0; k < nbttaglist4.func_74745_c(); ++k) {
            NBTTagCompound nbttagcompound3 = nbttaglist4.func_150305_b(k);
            NBTTagList nbttaglist5 = nbttagcompound3.func_150295_c("pos", 6);
            Vec3d vec3d = new Vec3d(nbttaglist5.func_150309_d(0), nbttaglist5.func_150309_d(1), nbttaglist5.func_150309_d(2));
            NBTTagList nbttaglist6 = nbttagcompound3.func_150295_c("blockPos", 3);
            BlockPos blockpos1 = new BlockPos(nbttaglist6.func_186858_c(0), nbttaglist6.func_186858_c(1), nbttaglist6.func_186858_c(2));
            if (!nbttagcompound3.func_74764_b("nbt")) continue;
            NBTTagCompound nbttagcompound2 = nbttagcompound3.func_74775_l("nbt");
            this.entities.add(new Template.EntityInfo(vec3d, blockpos1, nbttagcompound2));
        }
    }

    private NBTTagList writeInts(int ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i : values) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagInt(i));
        }
        return nbttaglist;
    }

    private NBTTagList writeDoubles(double ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        for (double d0 : values) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(d0));
        }
        return nbttaglist;
    }

    public List<BlockPos> takeBlocksFromWorldIntoCapsule(World worldIn, BlockPos startPos, BlockPos endPos, Map<BlockPos, Block> sourceIgnorePos, List<Block> excluded, List<Entity> outCapturedEntities) {
        ArrayList<BlockPos> transferedBlocks = new ArrayList<BlockPos>();
        if (endPos.func_177958_n() >= 1 && endPos.func_177956_o() >= 1 && endPos.func_177952_p() >= 1) {
            BlockPos blockpos = startPos.func_177971_a((Vec3i)endPos).func_177982_a(-1, -1, -1);
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPos blockpos1 = new BlockPos(Math.min(startPos.func_177958_n(), blockpos.func_177958_n()), Math.min(startPos.func_177956_o(), blockpos.func_177956_o()), Math.min(startPos.func_177952_p(), blockpos.func_177952_p()));
            BlockPos blockpos2 = new BlockPos(Math.max(startPos.func_177958_n(), blockpos.func_177958_n()), Math.max(startPos.func_177956_o(), blockpos.func_177956_o()), Math.max(startPos.func_177952_p(), blockpos.func_177952_p()));
            this.size = endPos;
            for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)blockpos1, (BlockPos)blockpos2)) {
                BlockPos blockpos3 = blockpos$mutableblockpos.func_177973_b((Vec3i)blockpos1);
                IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos);
                Block iblock = iblockstate.func_177230_c();
                if (excluded.contains(iblock) || sourceIgnorePos != null && sourceIgnorePos.keySet().contains(blockpos$mutableblockpos) && sourceIgnorePos.get(blockpos$mutableblockpos).equals(iblock)) continue;
                TileEntity tileentity = worldIn.func_175625_s((BlockPos)blockpos$mutableblockpos);
                if (tileentity != null) {
                    NBTTagCompound nbttagcompound = tileentity.func_189515_b(new NBTTagCompound());
                    nbttagcompound.func_82580_o("x");
                    nbttagcompound.func_82580_o("y");
                    nbttagcompound.func_82580_o("z");
                    list1.add(new Template.BlockInfo(blockpos3, iblockstate, nbttagcompound));
                } else if (!iblockstate.func_185913_b() && !iblockstate.func_185917_h()) {
                    list2.add(new Template.BlockInfo(blockpos3, iblockstate, (NBTTagCompound)null));
                } else {
                    list.add(new Template.BlockInfo(blockpos3, iblockstate, (NBTTagCompound)null));
                }
                transferedBlocks.add(new BlockPos(blockpos$mutableblockpos.func_177958_n(), blockpos$mutableblockpos.func_177956_o(), blockpos$mutableblockpos.func_177952_p()));
            }
            this.blocks.clear();
            this.blocks.addAll(list);
            this.blocks.addAll(list1);
            this.blocks.addAll(list2);
            List<Entity> capturedEntities = this.takeNonLivingEntitiesFromWorld(worldIn, blockpos1, blockpos2.func_177982_a(1, 1, 1));
            if (outCapturedEntities != null && capturedEntities != null) {
                outCapturedEntities.addAll(capturedEntities);
            }
            return transferedBlocks;
        }
        return null;
    }

    public List<Entity> takeNonLivingEntitiesFromWorld(World worldIn, BlockPos startPos, BlockPos endPos) {
        List list = worldIn.func_175647_a(Entity.class, new AxisAlignedBB(startPos, endPos), entity -> !(entity instanceof EntityItem) && (!(entity instanceof EntityLivingBase) || entity instanceof EntityArmorStand));
        this.entities.clear();
        for (Entity entity2 : list) {
            Vec3d vec3d = new Vec3d(entity2.field_70165_t - (double)startPos.func_177958_n(), entity2.field_70163_u - (double)startPos.func_177956_o(), entity2.field_70161_v - (double)startPos.func_177952_p());
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            entity2.func_70039_c(nbttagcompound);
            BlockPos blockpos = entity2 instanceof EntityPainting ? ((EntityPainting)entity2).func_174857_n().func_177973_b((Vec3i)startPos) : new BlockPos(vec3d);
            this.entities.add(new Template.EntityInfo(vec3d, blockpos, nbttagcompound));
        }
        return list;
    }

    public void spawnBlocksAndEntities(World p_189960_1_, BlockPos p_189960_2_, CapsulePlacementSettings p_189960_4_, List<BlockPos> spawnedBlocks, List<Entity> spawnedEntities) {
        BlockRotationProcessor p_189960_3_ = new BlockRotationProcessor(p_189960_2_, (PlacementSettings)p_189960_4_);
        int p_189960_5_ = 2;
        if (this.blocks == null || this.size == null || p_189960_3_ == null) {
            return;
        }
        if (!this.blocks.isEmpty() && this.size.func_177958_n() >= 1 && this.size.func_177956_o() >= 1 && this.size.func_177952_p() >= 1) {
            Block block = p_189960_4_.func_186219_f();
            StructureBoundingBox structureboundingbox = p_189960_4_.func_186213_g();
            for (Template.BlockInfo template$blockinfo : this.blocks) {
                TileEntity tileentity2;
                TileEntity tileentity;
                BlockPos blockpos = CapsuleTemplate.transformedBlockPos(p_189960_4_, template$blockinfo.field_186242_a).func_177971_a((Vec3i)p_189960_2_);
                Template.BlockInfo template$blockinfo1 = p_189960_3_ != null ? p_189960_3_.func_189943_a(p_189960_1_, blockpos, template$blockinfo) : template$blockinfo;
                if (template$blockinfo1 == null) continue;
                Block block1 = template$blockinfo1.field_186243_b.func_177230_c();
                if (block != null && block == block1 || p_189960_4_.func_186227_h() && block1 == Blocks.field_185779_df || structureboundingbox != null && !structureboundingbox.func_175898_b((Vec3i)blockpos)) continue;
                if (spawnedBlocks != null) {
                    spawnedBlocks.add(blockpos);
                }
                IBlockState iblockstate = template$blockinfo1.field_186243_b.func_185902_a(p_189960_4_.func_186212_b());
                IBlockState iblockstate1 = iblockstate.func_185907_a(p_189960_4_.func_186215_c());
                if (template$blockinfo1.field_186244_c != null && (tileentity = p_189960_1_.func_175625_s(blockpos)) != null) {
                    if (tileentity instanceof IInventory) {
                        ((IInventory)tileentity).func_174888_l();
                    }
                    p_189960_1_.func_180501_a(blockpos, Blocks.field_180401_cv.func_176223_P(), 4);
                }
                if (!p_189960_1_.func_180501_a(blockpos, iblockstate1, p_189960_5_) || template$blockinfo1.field_186244_c == null || (tileentity2 = p_189960_1_.func_175625_s(blockpos)) == null) continue;
                template$blockinfo1.field_186244_c.func_74768_a("x", blockpos.func_177958_n());
                template$blockinfo1.field_186244_c.func_74768_a("y", blockpos.func_177956_o());
                template$blockinfo1.field_186244_c.func_74768_a("z", blockpos.func_177952_p());
                tileentity2.func_145839_a(template$blockinfo1.field_186244_c);
                tileentity2.func_189668_a(p_189960_4_.func_186212_b());
                tileentity2.func_189667_a(p_189960_4_.func_186215_c());
            }
            for (Template.BlockInfo template$blockinfo2 : this.blocks) {
                TileEntity tileentity1;
                if (block != null && block == template$blockinfo2.field_186243_b.func_177230_c()) continue;
                BlockPos blockpos1 = CapsuleTemplate.transformedBlockPos(p_189960_4_, template$blockinfo2.field_186242_a).func_177971_a((Vec3i)p_189960_2_);
                if (structureboundingbox != null && !structureboundingbox.func_175898_b((Vec3i)blockpos1)) continue;
                p_189960_1_.func_175722_b(blockpos1, template$blockinfo2.field_186243_b.func_177230_c());
                if (template$blockinfo2.field_186244_c == null || (tileentity1 = p_189960_1_.func_175625_s(blockpos1)) == null) continue;
                tileentity1.func_70296_d();
            }
            if (!p_189960_4_.func_186221_e()) {
                this.addEntitiesToWorld(p_189960_1_, p_189960_2_, p_189960_4_.func_186212_b(), p_189960_4_.func_186215_c(), structureboundingbox, spawnedEntities);
            }
        }
    }

    public void removeBlocks(List<BlockPos> couldNotBeRemoved, BlockPos startPos) {
        for (BlockPos blockPos : couldNotBeRemoved) {
            this.blocks.removeIf(blockInfo -> blockPos.func_177973_b((Vec3i)startPos).equals((Object)blockInfo.field_186242_a));
        }
    }

    public List<BlockPos> calculateDeployPositions(World world, BlockPos blockPos, CapsulePlacementSettings placementSettings) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        BlockRotationProcessor blockRotationProcessor = new BlockRotationProcessor(blockPos, (PlacementSettings)placementSettings);
        if (this.blocks == null || this.size == null || blockRotationProcessor == null) {
            return out;
        }
        if (!this.blocks.isEmpty() && this.size.func_177958_n() >= 1 && this.size.func_177956_o() >= 1 && this.size.func_177952_p() >= 1) {
            Block block = placementSettings.func_186219_f();
            StructureBoundingBox structureboundingbox = placementSettings.func_186213_g();
            for (Template.BlockInfo template$blockinfo : this.blocks) {
                BlockPos blockpos = CapsuleTemplate.transformedBlockPos(placementSettings, template$blockinfo.field_186242_a).func_177971_a((Vec3i)blockPos);
                Template.BlockInfo template$blockinfo1 = blockRotationProcessor != null ? blockRotationProcessor.func_189943_a(world, blockpos, template$blockinfo) : template$blockinfo;
                if (template$blockinfo1 == null) continue;
                Block block1 = template$blockinfo1.field_186243_b.func_177230_c();
                if (block != null && block == block1 || placementSettings.func_186227_h() && block1 == Blocks.field_185779_df || structureboundingbox != null && !structureboundingbox.func_175898_b((Vec3i)blockpos)) continue;
                out.add(blockpos);
            }
        }
        return out;
    }

    static class BasicPalette
    implements Iterable<IBlockState> {
        public static final IBlockState DEFAULT_BLOCK_STATE = Blocks.field_150350_a.func_176223_P();
        final ObjectIntIdentityMap<IBlockState> ids = new ObjectIntIdentityMap(16);
        private int lastId;

        private BasicPalette() {
        }

        public int idFor(IBlockState p_189954_1_) {
            int i = this.ids.func_148747_b((Object)p_189954_1_);
            if (i == -1) {
                i = this.lastId++;
                this.ids.func_148746_a((Object)p_189954_1_, i);
            }
            return i;
        }

        @Nullable
        public IBlockState stateFor(int p_189955_1_) {
            IBlockState iblockstate = (IBlockState)this.ids.func_148745_a(p_189955_1_);
            return iblockstate == null ? DEFAULT_BLOCK_STATE : iblockstate;
        }

        @Override
        public Iterator<IBlockState> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(IBlockState p_189956_1_, int p_189956_2_) {
            this.ids.func_148746_a((Object)p_189956_1_, p_189956_2_);
        }
    }
}

