/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.addon.itemphysic;

import doggytalents.DoggyTalents;
import doggytalents.helper.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class ItemPhysicAPI {
    public Class<?> serverPhysicClass = ReflectionUtil.getClass("com.creativemd.itemphysic.physics.ServerPhysic");
    public Class<?> sortingListClass;
    public Method addSortingBlock;
    public Method addSortingItem;
    public ArrayList addSwimItem;
    public ArrayList addBurnItem;

    public ItemPhysicAPI() {
        if ("1.8.9".equals("1.9.4")) {
            this.addSwimItem = ReflectionUtil.getField(this.serverPhysicClass, ArrayList.class, null, "swimItem");
            this.addBurnItem = ReflectionUtil.getField(this.serverPhysicClass, ArrayList.class, null, "burnItem");
        } else {
            this.sortingListClass = ReflectionUtil.getClass("com.creativemd.creativecore.common.utils.sorting.SortingList");
            this.addSortingBlock = ReflectionUtil.getMethod(this.sortingListClass, "addSortingByBlock", Block.class);
            this.addSortingItem = ReflectionUtil.getMethod(this.sortingListClass, "addSortingByItem", Item.class);
        }
    }

    public void addSortingBlocks(String sortingListName, Block ... blocks) throws Exception {
        Object sortingList = ReflectionUtil.getField(this.serverPhysicClass, sortingListName).get(null);
        for (Block block : blocks) {
            this.addSortingBlock.invoke(sortingList, block);
            DoggyTalents.LOGGER.info("Successefully registered %s in %s list", new Object[]{block, sortingListName});
        }
    }

    public void addSortingItems(String sortingListName, Item ... items) throws Exception {
        Object sortingList = ReflectionUtil.getField(this.serverPhysicClass, sortingListName).get(null);
        for (Item item : items) {
            this.addSortingItem.invoke(sortingList, item);
            DoggyTalents.LOGGER.info("Successefully registered %s in %s list", new Object[]{item, sortingListName});
        }
    }

    public void addSwimObjects(Object ... objs) throws Exception {
        for (Object obj : objs) {
            this.addSwimItem.add(obj);
        }
    }

    public void addBurnObjects(Object ... objs) throws Exception {
        for (Object obj : objs) {
            this.addBurnItem.add(obj);
        }
    }
}

