/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.base.b;

import com.google.common.collect.Lists;
import doggytalents.api.registry.DogBedRegistry;
import doggytalents.block.BlockDogBed;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BreakingFour;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DogBedModel
extends SimpleBakedModel
implements ISmartBlockModel,
ISmartItemModel {
    private final Map<List<String>, IBakedModel> cache = new HashMap<List<String>, IBakedModel>();

    public DogBedModel(List<BakedQuad> generalQuadsIn, List<List<BakedQuad>> faceQuadsIn, boolean ambientOcclusionIn, boolean gui3dIn, TextureAtlasSprite particleTexture, ItemCameraTransforms cameraTransformsIn) {
        super(generalQuadsIn, faceQuadsIn, ambientOcclusionIn, gui3dIn, particleTexture, cameraTransformsIn);
    }

    public IBakedModel handleBlockState(IBlockState blockstate) {
        if (blockstate instanceof IExtendedBlockState) {
            IExtendedBlockState exState = (IExtendedBlockState)blockstate;
            String casingId = (String)exState.getValue((IUnlistedProperty)BlockDogBed.CASING);
            String beddingId = (String)exState.getValue((IUnlistedProperty)BlockDogBed.BEDDING);
            return this.getCachedModel(casingId, beddingId);
        }
        return this;
    }

    public IBakedModel handleItemState(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("doggytalents")) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("doggytalents");
            String casingId = tag.func_74779_i("casingId");
            String beddingId = tag.func_74779_i("beddingId");
            return this.getCachedModel(casingId, beddingId);
        }
        return this;
    }

    public IBakedModel getCachedModel(String casingId, String beddingId) {
        List<String> key = Arrays.asList(casingId, beddingId);
        if (!this.cache.containsKey(key)) {
            TextureAtlasSprite casingTexture = Minecraft.func_71410_x().func_147117_R().func_110572_b(DogBedRegistry.CASINGS.getTexture(casingId));
            TextureAtlasSprite beddingTexture = Minecraft.func_71410_x().func_147117_R().func_110572_b(DogBedRegistry.BEDDINGS.getTexture(beddingId));
            this.cache.put(key, new Builder((IBakedModel)this, casingTexture, beddingTexture).makeBakedModel());
        }
        return this.cache.get(key);
    }

    public static class Builder {
        private final List<BakedQuad> builderGeneralQuads = Lists.newArrayList();
        private final List<List<BakedQuad>> builderFaceQuads = Lists.newArrayListWithCapacity((int)6);
        private final boolean builderAmbientOcclusion;
        private TextureAtlasSprite builderTexture;
        private boolean builderGui3d;
        private ItemCameraTransforms builderCameraTransforms;

        public Builder(IBakedModel orignalModel, TextureAtlasSprite casingTexture, TextureAtlasSprite beddingTexture) {
            this(orignalModel.func_177555_b(), orignalModel.func_177556_c(), orignalModel.func_177552_f());
            this.builderTexture = casingTexture;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                this.addFaceBreakingFours(orignalModel, casingTexture, beddingTexture, facing);
            }
            this.addGeneralBreakingFours(orignalModel, casingTexture, beddingTexture);
        }

        private Builder(boolean ambientOcclusionIn, boolean gui3dIn, ItemCameraTransforms cameraTransformsIn) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                this.builderFaceQuads.add(Lists.newArrayList());
            }
            this.builderAmbientOcclusion = ambientOcclusionIn;
            this.builderGui3d = gui3dIn;
            this.builderCameraTransforms = cameraTransformsIn;
        }

        private void addFaceBreakingFours(IBakedModel orignalModel, TextureAtlasSprite casingTexture, TextureAtlasSprite beddingTexture, EnumFacing facing) {
            Iterator iterator = orignalModel.func_177551_a(facing).iterator();
            int i = 0;
            while (iterator.hasNext()) {
                BakedQuad bakedquad = (BakedQuad)iterator.next();
                TextureAtlasSprite sprite = casingTexture;
                this.addFaceQuad(facing, (BakedQuad)new BreakingFour(bakedquad, sprite));
                ++i;
            }
        }

        private void addGeneralBreakingFours(IBakedModel orignalModel, TextureAtlasSprite casingTexture, TextureAtlasSprite beddingTexture) {
            Iterator iterator = orignalModel.func_177550_a().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                BakedQuad bakedquad = (BakedQuad)iterator.next();
                TextureAtlasSprite sprite = casingTexture;
                if (i == 1 || i == 2 || i == 3 || i == 4) {
                    sprite = beddingTexture;
                }
                this.addGeneralQuad((BakedQuad)new BreakingFour(bakedquad, sprite));
                ++i;
            }
        }

        public Builder addFaceQuad(EnumFacing facing, BakedQuad bakedQuad) {
            this.builderFaceQuads.get(facing.ordinal()).add(bakedQuad);
            return this;
        }

        public Builder addGeneralQuad(BakedQuad bakedQuad) {
            this.builderGeneralQuads.add(bakedQuad);
            return this;
        }

        public Builder setTexture(TextureAtlasSprite textureIn) {
            this.builderTexture = textureIn;
            return this;
        }

        public IBakedModel makeBakedModel() {
            if (this.builderTexture == null) {
                throw new RuntimeException("Missing particle!");
            }
            return new DogBedModel(this.builderGeneralQuads, this.builderFaceQuads, this.builderAmbientOcclusion, this.builderGui3d, this.builderTexture, this.builderCameraTransforms);
        }
    }
}

