/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.configuration;

import doggytalents.lib.Constants;
import java.util.ArrayList;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    public static Configuration CONFIG;
    public static final String CATEGORY_DOGGYSETTINGS = "doggySettings";
    public static final String CATEGORY_TALENT = "talents";
    public static final String CATEGORY_GENERAL = "general";

    public static void init(Configuration configuration) {
        CONFIG = configuration;
        ConfigurationHandler.loadConfig();
    }

    public static void loadConfig() {
        String[] talentIds;
        CONFIG.addCustomCategoryComment(CATEGORY_DOGGYSETTINGS, "Here you can change details about your dog.");
        CONFIG.addCustomCategoryComment(CATEGORY_TALENT, "Enable and disable talents here as you wish");
        CONFIG.addCustomCategoryComment(CATEGORY_GENERAL, "Other settings");
        ArrayList<String> orderDSetting = new ArrayList<String>();
        Constants.DOGS_IMMORTAL = CONFIG.get(CATEGORY_DOGGYSETTINGS, "isDogImmortal", true, "Determines if dogs die when their health reaches zero. If true, dogs will not die, and will instead become incapacitated.").setRequiresMcRestart(true).getBoolean(true);
        Constants.TEN_DAY_PUPS = CONFIG.get(CATEGORY_DOGGYSETTINGS, "tenDayPuppies", true, "Determines if pups take 10 days to mature.").getBoolean(true);
        Constants.IS_HUNGER_ON = CONFIG.get(CATEGORY_DOGGYSETTINGS, "isHungerOn", true, "Enables hunger mode for the dog").getBoolean(true);
        Constants.DIRE_PARTICLES = CONFIG.get(CATEGORY_DOGGYSETTINGS, "direParticles", true, "Enables the particle effect on Dire Level 30 dogs.").getBoolean(true);
        Constants.STARTING_ITEMS = CONFIG.get(CATEGORY_DOGGYSETTINGS, "isStartingItemsEnabled", true, "When enabled you will spawn with a guide, Doggy Charm and Command Emblem.").getBoolean(true);
        Constants.RENDER_BLOOD = CONFIG.get(CATEGORY_DOGGYSETTINGS, "bloodWhenIncapacitated", true, "When enabled, Dogs will bleed while incapacitated.").getBoolean(true);
        Constants.DOGGY_WINGS = CONFIG.get(CATEGORY_DOGGYSETTINGS, "doggyWings", true, "When enabled, Dogs will have wings when at level 5 pillow paw").getBoolean(true);
        orderDSetting.add("isDogImmortal");
        orderDSetting.add("tenDayPuppies");
        orderDSetting.add("isHungerOn");
        orderDSetting.add("direParticles");
        orderDSetting.add("isStartingItemsEnabled");
        orderDSetting.add("bloodWhenIncapacitated");
        orderDSetting.add("doggyWings");
        CONFIG.setCategoryPropertyOrder(CATEGORY_DOGGYSETTINGS, orderDSetting);
        Constants.DISABLED_TALENTS.clear();
        for (String talentId : talentIds = new String[]{"bedfinder", "blackpelt", "creepersweeper", "doggydash", "fisherdog", "guarddog", "happyeater", "hellhound", "hunterdog", "packpuppy", "pestfighter", "pillowpaw", "poisonfang", "puppyeyes", "quickhealer", "rescuedog", "shepherddog", "swimmerdog", "wolfmount"}) {
            boolean enabled = CONFIG.get(CATEGORY_TALENT, talentId, true).getBoolean(true);
            if (enabled) continue;
            Constants.DISABLED_TALENTS.add(talentId);
        }
        ArrayList orderDTGeneral = new ArrayList();
        CONFIG.setCategoryPropertyOrder(CATEGORY_GENERAL, orderDTGeneral);
        if (CONFIG.hasChanged()) {
            CONFIG.save();
        }
    }
}

