/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity;

import doggytalents.entity.EntityDog;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.nbt.NBTTagCompound;

public class LevelUtil {
    private EntityDog dog;
    private static UUID HEALTH_BOOST_ID = UUID.fromString("da97255c-6281-45db-8198-f79226438583");

    public LevelUtil(EntityDog dog) {
        this.dog = dog;
    }

    public void writeTalentsToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("level_normal", this.getLevel());
        tagCompound.func_74768_a("level_dire", this.getDireLevel());
    }

    public void readTalentsFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound.func_74764_b("level_normal")) {
            this.setLevel(tagCompound.func_74762_e("level_normal"));
        }
        if (tagCompound.func_74764_b("level_dire")) {
            this.setDireLevel(tagCompound.func_74762_e("level_dire"));
        }
        if (tagCompound.func_150297_b("levels", 8)) {
            String[] split = tagCompound.func_74779_i("levels").split(":");
            this.setLevel(new Integer(split[0]));
            this.setDireLevel(new Integer(split[1]));
        }
    }

    public int getLevel() {
        return this.dog.dataTracker.getLevel();
    }

    public int getDireLevel() {
        return this.dog.dataTracker.getDireLevel();
    }

    public void increaseLevel() {
        this.setLevel(this.getLevel() + 1);
    }

    public void increaseDireLevel() {
        this.setDireLevel(this.getDireLevel() + 1);
    }

    public void setLevel(int level) {
        this.dog.dataTracker.setLevel(level);
        this.updateHealthModifier();
    }

    public void setDireLevel(int level) {
        this.dog.dataTracker.setDireLevel(level);
        this.updateHealthModifier();
    }

    public void updateHealthModifier() {
        IAttributeInstance iattributeinstance = this.dog.func_110148_a(SharedMonsterAttributes.field_111267_a);
        AttributeModifier healthModifier = this.createHealthModifier(this.dog.effectiveLevel() + 1.0);
        if (iattributeinstance.func_111127_a(HEALTH_BOOST_ID) != null) {
            iattributeinstance.func_111124_b(healthModifier);
        }
        iattributeinstance.func_111121_a(healthModifier);
    }

    public AttributeModifier createHealthModifier(double health) {
        return new AttributeModifier(HEALTH_BOOST_ID, "Dog Health", health, 0);
    }

    public boolean isDireDog() {
        return this.getDireLevel() == 30;
    }
}

