/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity.ai;

import doggytalents.base.IWaterMovement;
import doggytalents.base.ObjectLib;
import doggytalents.base.VersionControl;
import doggytalents.entity.EntityDog;
import doggytalents.helper.DogUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.world.World;

public class EntityAIFollowOwner
extends EntityAIBase {
    private final EntityDog dog;
    private EntityLivingBase owner;
    private World world;
    private final double followSpeed;
    private final PathNavigate petPathfinder;
    private int timeToRecalcPath;
    private float maxDist;
    private float minDist;
    private double oldRangeSense;
    private IWaterMovement waterMovement;

    public EntityAIFollowOwner(EntityDog thePetIn, double followSpeedIn, float minDistIn, float maxDistIn) {
        this.dog = thePetIn;
        this.world = thePetIn.field_70170_p;
        this.followSpeed = followSpeedIn;
        this.petPathfinder = thePetIn.func_70661_as();
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
        this.waterMovement = VersionControl.createObject("WaterMovementHandler", IWaterMovement.class, EntityDog.class, (Object)this.dog);
        this.func_75248_a(3);
        if (!(thePetIn.func_70661_as() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.dog.func_70902_q();
        if (entitylivingbase == null) {
            return false;
        }
        if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).func_175149_v()) {
            return false;
        }
        if (this.dog.func_70906_o()) {
            return false;
        }
        if (!this.dog.mode.getMode().doesFollowOwner()) {
            return false;
        }
        if (this.dog.aiFetchBone.isPlayingFetch()) {
            return false;
        }
        int order = this.dog.masterOrder();
        double distanceAway = this.dog.func_70068_e((Entity)entitylivingbase);
        if (!this.dog.hasBone() && (order == 1 || order == 2) ? distanceAway >= 16.0 && distanceAway <= 100.0 : !this.dog.hasBone() && this.dog.func_70068_e((Entity)entitylivingbase) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        return !this.petPathfinder.func_75500_f() && this.dog.func_70068_e((Entity)this.owner) > (double)(this.maxDist * this.maxDist) && !this.dog.func_70906_o();
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.waterMovement.startExecuting();
        this.oldRangeSense = this.dog.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        this.dog.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    public void func_75251_c() {
        this.owner = null;
        this.petPathfinder.func_75499_g();
        this.waterMovement.resetTask();
        this.dog.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.oldRangeSense);
    }

    public void func_75246_d() {
        if (!this.dog.func_70906_o() && --this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            int order = this.dog.masterOrder();
            int masterX = ObjectLib.BRIDGE.floor(this.owner.field_70165_t);
            int masterY = ObjectLib.BRIDGE.floor(this.owner.field_70163_u);
            int masterZ = ObjectLib.BRIDGE.floor(this.owner.field_70161_v);
            double distanceAway = this.dog.func_70068_e((Entity)this.owner);
            if ((order == 0 || order == 3) && distanceAway >= 4.0 || this.dog.hasBone()) {
                this.dog.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.dog.func_70646_bf());
                if (!this.petPathfinder.func_75497_a((Entity)this.owner, this.followSpeed) && !this.dog.hasBone() && !this.dog.func_110167_bD() && distanceAway >= 144.0) {
                    DogUtil.teleportDogToOwner((Entity)this.owner, (Entity)this.dog, this.world, this.petPathfinder);
                }
            } else if (order == 1 || order == 2) {
                int dogX = ObjectLib.BRIDGE.floor(this.dog.field_70165_t);
                int dogY = ObjectLib.BRIDGE.floor(this.dog.field_70163_u);
                int dogZ = ObjectLib.BRIDGE.floor(this.dog.field_70161_v);
                int dPosX = dogX - masterX;
                int dPosZ = dogZ - masterZ;
                int j3 = masterX + dPosX * 2;
                int k3 = masterZ + dPosZ * 2;
                int l3 = masterX + dPosX / 2;
                int i4 = masterZ + dPosZ / 2;
                if (distanceAway < 25.0) {
                    if (this.petPathfinder.func_75492_a((double)j3, (double)dogY, (double)k3, this.followSpeed)) {
                        this.dog.func_70671_ap().func_75650_a((double)j3, (double)(dogY + 1), (double)k3, 10.0f, (float)this.dog.func_70646_bf());
                    }
                } else if (distanceAway > 100.0) {
                    if (!this.dog.func_70661_as().func_75492_a((double)l3, (double)dogY, (double)i4, this.followSpeed)) {
                        if (!this.dog.func_110167_bD() && distanceAway >= 350.0) {
                            DogUtil.teleportDogToOwner((Entity)this.owner, (Entity)this.dog, this.world, this.petPathfinder);
                        }
                    } else {
                        this.dog.func_70671_ap().func_75650_a((double)l3, (double)(dogY + 1), (double)i4, 10.0f, (float)this.dog.func_70646_bf());
                    }
                }
            }
        }
    }
}

