/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.proxy;

import doggytalents.base.ObjectLib;
import doggytalents.base.ObjectLibClient;
import doggytalents.base.VersionControl;
import doggytalents.client.gui.GuiDogInfo;
import doggytalents.client.renderer.entity.RenderDog;
import doggytalents.client.renderer.entity.RenderDogBeam;
import doggytalents.entity.EntityDog;
import doggytalents.handler.KeyState;
import doggytalents.proxy.CommonProxy;
import doggytalents.tileentity.TileEntityFoodBowl;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        ObjectLibClient.INITIALIZATION.preInit(event);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyState.come);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyState.stay);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyState.ok);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyState.heel);
        RenderingRegistry.registerEntityRenderingHandler(ObjectLib.ENTITY_DOG_CLASS, RenderDog::new);
        RenderingRegistry.registerEntityRenderingHandler(ObjectLib.ENTITY_DOGGY_BEAM_CLASS, RenderDogBeam::new);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        ObjectLibClient.INITIALIZATION.init(event);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        ObjectLibClient.INITIALIZATION.postInit(event);
    }

    @Override
    protected void registerEventHandlers() {
        super.registerEventHandlers();
        MinecraftForge.EVENT_BUS.register(VersionControl.createObject("WorldRender"));
        MinecraftForge.EVENT_BUS.register((Object)new KeyState());
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == 1) {
            Entity target = player.field_70170_p.func_73045_a(x);
            if (!(target instanceof EntityDog)) {
                return null;
            }
            EntityDog dog = (EntityDog)target;
            return new GuiDogInfo(dog, player);
        }
        if (ID == 2) {
            Entity target = player.field_70170_p.func_73045_a(x);
            if (!(target instanceof EntityDog)) {
                return null;
            }
            EntityDog dog = (EntityDog)target;
            return ObjectLibClient.createGuiPackPuppy(player, dog);
        }
        if (ID == 3) {
            TileEntity target = ObjectLib.BRIDGE.getTileEntity(world, x, y, z);
            if (!(target instanceof TileEntityFoodBowl)) {
                return null;
            }
            TileEntityFoodBowl foodBowl = (TileEntityFoodBowl)target;
            return ObjectLibClient.createGuiFoodBowl(player.field_71071_by, foodBowl);
        }
        if (ID == 4) {
            return ObjectLibClient.createGuiTreatBag(player, x, player.field_71071_by.func_70301_a(x));
        }
        return null;
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerEntity(ctx);
    }

    @Override
    public EntityPlayer getPlayerEntity() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public IThreadListener getThreadFromContext(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x() : super.getThreadFromContext(ctx);
    }

    @Override
    public void spawnCrit(World world, Entity entity) {
        FMLClientHandler.instance().getClient().field_71452_i.func_178926_a(entity, EnumParticleTypes.CRIT);
    }

    @Override
    public void spawnCustomParticle(EntityPlayer player, Object pos, Random rand, float posX, float posY, float posZ, int numberOfParticles, float particleSpeed) {
        ObjectLibClient.METHODS.spawnCustomParticle(player, pos, rand, posX, posY, posZ, numberOfParticles, particleSpeed);
    }
}

