/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.ClientHandler;
import com.mrcrayfish.backpacked.client.gui.screen.inventory.BackpackScreen;
import com.mrcrayfish.backpacked.client.model.BackpackModel;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.BackpackLayer;
import com.mrcrayfish.backpacked.common.BackpackModelProperty;
import com.mrcrayfish.backpacked.common.data.PickpocketChallenge;
import com.mrcrayfish.backpacked.integration.Curios;
import com.mrcrayfish.backpacked.inventory.ExtendedPlayerInventory;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageEntityBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenBackpack;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import com.mrcrayfish.backpacked.util.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEvents {
    public static final ResourceLocation EMPTY_BACKPACK_SLOT = new ResourceLocation("backpacked", "item/empty_backpack_slot");
    private static ItemGroup currentGroup = null;

    @SubscribeEvent
    public void onPlayerLogin(ClientPlayerNetworkEvent.LoggedInEvent event) {
        Backpacked.updateBannedItemsList();
    }

    @SubscribeEvent
    public void onPlayerRenderScreen(GuiContainerEvent.DrawBackground event) {
        CreativeScreen creativeScreen;
        if (Backpacked.isCuriosLoaded()) {
            return;
        }
        ContainerScreen screen = event.getGuiContainer();
        if (screen instanceof InventoryScreen) {
            InventoryScreen inventoryScreen = (InventoryScreen)screen;
            int left = inventoryScreen.getGuiLeft();
            int top = inventoryScreen.getGuiTop();
            inventoryScreen.getMinecraft().func_110434_K().func_110577_a(ContainerScreen.field_147001_a);
            Screen.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)(left + 76), (int)(top + 43), (float)7.0f, (float)7.0f, (int)18, (int)18, (int)256, (int)256);
        } else if (screen instanceof CreativeScreen && (creativeScreen = (CreativeScreen)screen).func_147056_g() == ItemGroup.field_78036_m.func_78021_a()) {
            int left = creativeScreen.getGuiLeft();
            int top = creativeScreen.getGuiTop();
            creativeScreen.getMinecraft().func_110434_K().func_110577_a(ContainerScreen.field_147001_a);
            Screen.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)(left + 126), (int)(top + 19), (float)7.0f, (float)7.0f, (int)18, (int)18, (int)256, (int)256);
        }
    }

    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            event.addSprite(EMPTY_BACKPACK_SLOT);
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71462_r instanceof BackpackScreen) {
            if (event.getAction() == 1 && event.getKey() == ClientHandler.KEY_BACKPACK.getKey().func_197937_c()) {
                minecraft.field_71439_g.func_71053_j();
            }
        } else if (minecraft.field_71439_g != null && minecraft.field_71462_r == null) {
            ClientPlayerEntity player = minecraft.field_71439_g;
            if (ClientHandler.KEY_BACKPACK.func_151470_d() && ClientHandler.KEY_BACKPACK.func_151468_f() && !Backpacked.getBackpackStack((PlayerEntity)player).func_190926_b()) {
                Network.getPlayChannel().sendToServer((Object)new MessageOpenBackpack());
            }
        }
    }

    @SubscribeEvent
    public void onClientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        List players = mc.field_71441_e.func_217394_a(EntityType.field_200729_aH, mc.field_71439_g.func_174813_aQ().func_186662_g(16.0), player -> true);
        for (PlayerEntity player2 : players) {
            ItemStack stack;
            if (Backpacked.isCuriosLoaded() && !Curios.isBackpackVisible(player2) || (stack = Backpacked.getBackpackStack(player2)).func_190926_b() || !ClientEvents.canShowBackpackEffects(stack)) continue;
            String modelName = stack.func_196082_o().func_74779_i("BackpackModel");
            BackpackModel model = BackpackLayer.getModel(modelName);
            model.tickForPlayer(PickpocketUtil.getBackpackBox((LivingEntity)player2, 1.0f).func_189972_c(), player2);
        }
    }

    public static boolean canShowBackpackEffects(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_150297_b(BackpackModelProperty.SHOW_EFFECTS.getTagName(), 1)) {
            return tag.func_74767_n(BackpackModelProperty.SHOW_EFFECTS.getTagName());
        }
        return true;
    }

    @SubscribeEvent
    public void onRightClick(InputEvent.ClickInputEvent event) {
        if (event.isUseItem() && ((Boolean)Config.SERVER.pickpocketBackpacks.get()).booleanValue()) {
            this.performBackpackRaytrace(event);
        }
    }

    private void performBackpackRaytrace(InputEvent.ClickInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null || mc.field_71442_b == null) {
            return;
        }
        double range = (Double)Config.SERVER.pickpocketMaxReachDistance.get();
        ArrayList entities = new ArrayList();
        entities.addAll(mc.field_71441_e.func_217394_a(EntityType.field_200729_aH, mc.field_71439_g.func_174813_aQ().func_186662_g(range), player -> !Backpacked.getBackpackStack(player).func_190926_b() && !player.equals((Object)mc.field_71439_g) && PickpocketUtil.canPickpocketEntity((LivingEntity)player, (PlayerEntity)mc.field_71439_g)));
        entities.addAll(mc.field_71441_e.func_217394_a(EntityType.field_220351_aK, mc.field_71439_g.func_174813_aQ().func_186662_g((double)mc.field_71442_b.func_78757_d()), entity -> PickpocketChallenge.get((LivingEntity)entity).map(PickpocketChallenge::isBackpackEquipped).orElse(false) != false && PickpocketUtil.canPickpocketEntity((LivingEntity)entity, (PlayerEntity)mc.field_71439_g, mc.field_71442_b.func_78757_d())));
        if (entities.isEmpty()) {
            return;
        }
        Vector3d start = mc.field_71439_g.func_174824_e(1.0f);
        Vector3d end = mc.field_71439_g.func_70676_i(1.0f).func_186678_a((double)mc.field_71442_b.func_78757_d()).func_178787_e(start);
        double closestDistance = Double.MAX_VALUE;
        LivingEntity hitEntity = null;
        for (LivingEntity entity2 : entities) {
            double distance;
            AxisAlignedBB box = PickpocketUtil.getBackpackBox(entity2, 1.0f);
            Optional optionalHitVec = box.func_216365_b(start, end);
            if (!optionalHitVec.isPresent() || !((distance = start.func_72438_d((Vector3d)optionalHitVec.get())) < closestDistance)) continue;
            closestDistance = distance;
            hitEntity = entity2;
        }
        if (hitEntity != null) {
            event.setCanceled(true);
            event.setSwingHand(false);
            if (PickpocketUtil.canSeeBackpack(hitEntity, (PlayerEntity)mc.field_71439_g)) {
                Network.getPlayChannel().sendToServer((Object)new MessageEntityBackpack(hitEntity.func_145782_y()));
                event.setSwingHand(true);
            }
        }
    }

    @SubscribeEvent
    public void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.func_175598_ae().func_178634_b()) {
            return;
        }
        if (!((Boolean)Config.SERVER.pickpocketBackpacks.get()).booleanValue()) {
            return;
        }
        MatrixStack stack = event.getMatrixStack();
        stack.func_227860_a_();
        Vector3d view = mc.field_71460_t.func_215316_n().func_216785_c();
        stack.func_227861_a_(-view.func_82615_a(), -view.field_72448_b, -view.func_82616_c());
        IRenderTypeBuffer.Impl source = mc.func_228019_au_().func_228487_b_();
        for (PlayerEntity player : mc.field_71441_e.func_217369_A()) {
            if (Backpacked.getBackpackStack(player).func_190926_b() || player.func_175144_cb()) continue;
            boolean inReach = PickpocketUtil.inReachOfBackpack((LivingEntity)player, (PlayerEntity)mc.field_71439_g, (Double)Config.SERVER.pickpocketMaxReachDistance.get()) && PickpocketUtil.canSeeBackpack((LivingEntity)player, (PlayerEntity)mc.field_71439_g);
            float boxRed = inReach ? 0.0f : 1.0f;
            float boxGreen = inReach ? 1.0f : 1.0f;
            float boxBlue = inReach ? 0.0f : 1.0f;
            IVertexBuilder builder = source.getBuffer(RenderType.func_228659_m_());
            WorldRenderer.func_228430_a_((MatrixStack)stack, (IVertexBuilder)builder, (AxisAlignedBB)PickpocketUtil.getBackpackBox((LivingEntity)player, event.getPartialTicks()), (float)boxRed, (float)boxGreen, (float)boxBlue, (float)1.0f);
            float bodyRotation = MathHelper.func_219799_g((float)event.getPartialTicks(), (float)player.field_70760_ar, (float)player.field_70761_aq);
            boolean inRange = PickpocketUtil.inRangeOfBackpack((LivingEntity)player, (PlayerEntity)mc.field_71439_g);
            float lineRed = inRange ? 0.0f : 1.0f;
            float lineGreen = inRange ? 1.0f : 1.0f;
            float lineBlue = inRange ? 0.0f : 1.0f;
            Matrix4f matrix4f = stack.func_227866_c_().func_227870_a_();
            Vector3d pos = player.func_242282_l(event.getPartialTicks());
            Vector3d start = Vector3d.func_189986_a((float)0.0f, (float)(bodyRotation + 180.0f - ((Double)Config.SERVER.pickpocketMaxRangeAngle.get()).floatValue())).func_186678_a(((Double)Config.SERVER.pickpocketMaxReachDistance.get()).doubleValue());
            Vector3d end = Vector3d.func_189986_a((float)0.0f, (float)(bodyRotation - 180.0f + ((Double)Config.SERVER.pickpocketMaxRangeAngle.get()).floatValue())).func_186678_a(((Double)Config.SERVER.pickpocketMaxReachDistance.get()).doubleValue());
            builder.func_227888_a_(matrix4f, (float)(pos.field_72450_a + start.field_72450_a), (float)(pos.field_72448_b + start.field_72448_b), (float)(pos.field_72449_c + start.field_72449_c)).func_227885_a_(lineRed, lineGreen, lineBlue, 1.0f).func_181675_d();
            builder.func_227888_a_(matrix4f, (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c).func_227885_a_(lineRed, lineGreen, lineBlue, 1.0f).func_181675_d();
            builder.func_227888_a_(matrix4f, (float)(pos.field_72450_a + end.field_72450_a), (float)(pos.field_72448_b + end.field_72448_b), (float)(pos.field_72449_c + end.field_72449_c)).func_227885_a_(lineRed, lineGreen, lineBlue, 1.0f).func_181675_d();
            builder.func_227888_a_(matrix4f, (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c).func_227885_a_(lineRed, lineGreen, lineBlue, 1.0f).func_181675_d();
        }
        source.func_228462_a_(RenderType.func_228659_m_());
        stack.func_227865_b_();
    }

    @SubscribeEvent
    public void onRenderTickStart(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (Backpacked.isCuriosLoaded()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71462_r instanceof CreativeScreen)) {
            currentGroup = null;
            return;
        }
        CreativeScreen screen = (CreativeScreen)mc.field_71462_r;
        ItemGroup group = ItemGroup.field_78032_a[screen.func_147056_g()];
        if ((currentGroup == null || currentGroup != group) && (currentGroup = group) == ItemGroup.field_78036_m) {
            List slots = ((CreativeScreen.CreativeContainer)screen.func_212873_a_()).field_75151_b;
            slots.stream().filter(slot -> slot.field_75224_c instanceof ExtendedPlayerInventory && slot.getSlotIndex() == 41).findFirst().ifPresent(slot -> ReflectionHelper.repositionSlot(slot, 127, 20));
        }
    }
}

