/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer.entity.layers;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.client.ModelInstances;
import com.mrcrayfish.backpacked.client.model.BackpackModel;
import com.mrcrayfish.backpacked.common.BackpackModelProperty;
import com.mrcrayfish.backpacked.integration.Curios;
import com.mrcrayfish.backpacked.item.BackpackItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;

public class BackpackLayer<T extends PlayerEntity, M extends BipedModel<T>>
extends LayerRenderer<T, M> {
    private static final Map<String, BackpackModel> VARIANTS = new HashMap<String, BackpackModel>();

    public BackpackLayer(IEntityRenderer<T, M> renderer) {
        super(renderer);
    }

    public void render(MatrixStack stack, IRenderTypeBuffer renderTypeBuffer, int p_225628_3_, T player, float p_225628_5_, float p_225628_6_, float partialTick, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        ItemStack backpack = Backpacked.getBackpackStack(player);
        if (backpack.func_77973_b() instanceof BackpackItem) {
            ItemStack chestStack = player.func_184582_a(EquipmentSlotType.CHEST);
            if (chestStack.func_77973_b() == Items.field_185160_cR && !BackpackLayer.canRenderWithElytra(backpack)) {
                return;
            }
            if (Backpacked.isCuriosLoaded() && !Curios.isBackpackVisible(player)) {
                return;
            }
            stack.func_227860_a_();
            BackpackItem backpackItem = (BackpackItem)backpack.func_77973_b();
            String modelName = backpack.func_196082_o().func_74779_i("BackpackModel");
            BackpackModel model = VARIANTS.getOrDefault(modelName, backpackItem.getDefaultModel().get());
            model.transformToPlayerBody(((BipedModel)this.func_215332_c()).field_78115_e, !chestStack.func_190926_b());
            model.setupAngles((PlayerEntity)player, ((PlayerEntity)player).field_70173_aa, partialTick);
            IVertexBuilder builder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)model.func_228282_a_(model.getTextureLocation()), (boolean)false, (BackpackLayer.canShowEnchantmentGlint(backpack) && backpack.func_77962_s() ? 1 : 0) != 0);
            model.func_225598_a_(stack, builder, p_225628_3_, OverlayTexture.field_229196_a_, 1.0f, 2.0f, 2.0f, 2.0f);
            stack.func_227865_b_();
        }
    }

    public static boolean canRenderWithElytra(ItemStack stack) {
        return stack.func_196082_o().func_74767_n(BackpackModelProperty.SHOW_WITH_ELYTRA.getTagName());
    }

    public static boolean canShowEnchantmentGlint(ItemStack stack) {
        return stack.func_196082_o().func_74767_n(BackpackModelProperty.SHOW_GLINT.getTagName());
    }

    public static synchronized <T extends BackpackModel> void registerModel(ResourceLocation id, T model) {
        VARIANTS.putIfAbsent(id.toString(), model);
    }

    public static BackpackModel getModel(String id) {
        return VARIANTS.getOrDefault(id, ModelInstances.STANDARD);
    }

    public static Map<String, BackpackModel> getBackpackModels() {
        return ImmutableMap.copyOf(VARIANTS);
    }
}

