/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.BackpackManager;
import com.mrcrayfish.backpacked.common.IProgressTracker;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageSyncUnlockTracker;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="backpacked")
public class UnlockTracker {
    @CapabilityInject(value=UnlockTracker.class)
    public static final Capability<UnlockTracker> UNLOCK_TRACKER_CAPABILITY = null;
    public static final ResourceLocation ID = new ResourceLocation("backpacked", "unlock_tracker");
    private static final Set<ServerPlayerEntity> testForCompletion = new HashSet<ServerPlayerEntity>();
    private final Set<ResourceLocation> unlockedBackpacks = new HashSet<ResourceLocation>();
    private final Map<ResourceLocation, IProgressTracker> progressTrackerMap;

    private UnlockTracker() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        BackpackManager.instance().getRegisteredBackpacks().forEach(backpack -> {
            IProgressTracker tracker = backpack.createProgressTracker();
            if (tracker != null) {
                builder.put((Object)backpack.getId(), (Object)tracker);
            }
        });
        this.progressTrackerMap = builder.build();
    }

    public Set<ResourceLocation> getUnlockedBackpacks() {
        return ImmutableSet.copyOf(this.unlockedBackpacks);
    }

    public boolean isUnlocked(ResourceLocation id) {
        return this.unlockedBackpacks.contains(id);
    }

    public Optional<IProgressTracker> getProgressTracker(ResourceLocation id) {
        if (!((Boolean)Config.SERVER.unlockAllBackpacks.get()).booleanValue() && !this.unlockedBackpacks.contains(id)) {
            return Optional.ofNullable(this.progressTrackerMap.get(id));
        }
        return Optional.empty();
    }

    public boolean unlockBackpack(ResourceLocation id) {
        if (BackpackManager.instance().getBackpack(id) != null) {
            return this.unlockedBackpacks.add(id);
        }
        return false;
    }

    Map<ResourceLocation, IProgressTracker> getProgressTrackerMap() {
        return this.progressTrackerMap;
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(UnlockTracker.class, (Capability.IStorage)new Storage(), UnlockTracker::new);
    }

    static void queuePlayerForCompletionTest(ServerPlayerEntity player) {
        testForCompletion.add(player);
    }

    public static LazyOptional<UnlockTracker> get(PlayerEntity player) {
        return player.getCapability(UNLOCK_TRACKER_CAPABILITY);
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof PlayerEntity) {
            Provider provider = new Provider();
            event.addCapability(ID, (ICapabilityProvider)provider);
            if (!(entity instanceof ServerPlayerEntity)) {
                event.addListener(provider::invalidate);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        PlayerEntity originalPlayer = event.getOriginal();
        originalPlayer.revive();
        UnlockTracker.get(originalPlayer).ifPresent(originalTracker -> UnlockTracker.get(event.getPlayer()).ifPresent(newTracker -> {
            newTracker.unlockedBackpacks.addAll(originalTracker.unlockedBackpacks);
            originalTracker.progressTrackerMap.forEach((location, progressTracker) -> {
                CompoundNBT tag = new CompoundNBT();
                progressTracker.write(tag);
                Optional.ofNullable(newTracker.progressTrackerMap.get(location)).ifPresent(t -> t.read(tag));
            });
        }));
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        UnlockTracker.get(event.getPlayer()).ifPresent(unlockTracker -> Network.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new MessageSyncUnlockTracker(unlockTracker.getUnlockedBackpacks())));
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        UnlockTracker.get(event.getPlayer()).ifPresent(unlockTracker -> Network.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new MessageSyncUnlockTracker(unlockTracker.getUnlockedBackpacks())));
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        UnlockTracker.get(event.getPlayer()).ifPresent(unlockTracker -> Network.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new MessageSyncUnlockTracker(unlockTracker.getUnlockedBackpacks())));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (testForCompletion.isEmpty()) {
            return;
        }
        for (ServerPlayerEntity player : testForCompletion) {
            UnlockTracker.get((PlayerEntity)player).ifPresent(unlockTracker -> unlockTracker.progressTrackerMap.forEach((location, progressTracker) -> {
                if (!unlockTracker.unlockedBackpacks.contains(location) && progressTracker.isComplete()) {
                    BackpackManager.instance().unlockBackpack(player, (ResourceLocation)location);
                }
            }));
        }
        testForCompletion.clear();
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        private final UnlockTracker instance = new UnlockTracker();
        private final LazyOptional<UnlockTracker> optional = LazyOptional.of(() -> this.instance);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return UNLOCK_TRACKER_CAPABILITY.orEmpty(cap, this.optional.cast());
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)UNLOCK_TRACKER_CAPABILITY.writeNBT((Object)this.instance, null);
        }

        public void deserializeNBT(CompoundNBT tag) {
            UNLOCK_TRACKER_CAPABILITY.readNBT((Object)this.instance, null, (INBT)tag);
        }

        public void invalidate() {
            this.optional.invalidate();
        }
    }

    public static class Storage
    implements Capability.IStorage<UnlockTracker> {
        @Nullable
        public INBT writeNBT(Capability<UnlockTracker> capability, UnlockTracker instance, Direction side) {
            CompoundNBT tag = new CompoundNBT();
            ListNBT unlockedBackpacks = new ListNBT();
            instance.unlockedBackpacks.forEach(location -> unlockedBackpacks.add((Object)StringNBT.func_229705_a_((String)location.toString())));
            tag.func_218657_a("UnlockedBackpacks", (INBT)unlockedBackpacks);
            ListNBT progressTrackers = new ListNBT();
            instance.progressTrackerMap.forEach((location, progressTracker) -> {
                CompoundNBT progressTag = new CompoundNBT();
                progressTag.func_74778_a("Id", location.toString());
                CompoundNBT dataTag = new CompoundNBT();
                progressTracker.write(dataTag);
                progressTag.func_218657_a("Data", (INBT)dataTag);
                progressTrackers.add((Object)progressTag);
            });
            tag.func_218657_a("ProgressTrackers", (INBT)progressTrackers);
            return tag;
        }

        public void readNBT(Capability<UnlockTracker> capability, UnlockTracker instance, Direction side, INBT nbt) {
            instance.unlockedBackpacks.clear();
            CompoundNBT tag = (CompoundNBT)nbt;
            ListNBT unlockedBackpacks = tag.func_150295_c("UnlockedBackpacks", 8);
            unlockedBackpacks.forEach(t -> instance.unlockedBackpacks.add(ResourceLocation.func_208304_a((String)t.func_150285_a_())));
            ListNBT progressTrackers = tag.func_150295_c("ProgressTrackers", 10);
            progressTrackers.forEach(t -> {
                CompoundNBT progressTag = (CompoundNBT)t;
                ResourceLocation id = new ResourceLocation(progressTag.func_74779_i("Id"));
                IProgressTracker tracker = (IProgressTracker)instance.progressTrackerMap.get(id);
                if (tracker != null) {
                    CompoundNBT dataTag = progressTag.func_74775_l("Data");
                    tracker.read(dataTag);
                }
            });
        }
    }
}

