/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.IMovedAccess;
import com.mrcrayfish.backpacked.common.UnlockTracker;
import com.mrcrayfish.backpacked.common.backpack.WanderingBagBackpack;
import com.mrcrayfish.backpacked.common.data.PickpocketChallenge;
import com.mrcrayfish.backpacked.inventory.container.WanderingTraderContainer;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageSyncVillagerBackpack;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public class WanderingTraderEvents {
    private static final Field goalsField = ObfuscationReflectionHelper.findField(GoalSelector.class, (String)"field_220892_d");
    public static final TranslationTextComponent WANDERING_BAG_TRANSLATION = new TranslationTextComponent("backpacked.backpack.wandering_bag");

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().func_201670_d() && event.getEntity() instanceof WanderingTraderEntity && ((Boolean)Config.COMMON.spawnBackpackOnWanderingTraders.get()).booleanValue()) {
            WanderingTraderEntity trader = (WanderingTraderEntity)event.getEntity();
            PickpocketChallenge.get((LivingEntity)trader).ifPresent(data -> {
                if (!data.isInitialized()) {
                    boolean equipped = trader.field_70170_p.field_73012_v.nextInt((Integer)Config.COMMON.wanderingTraderBackpackChance.get()) == 0;
                    data.setBackpackEquipped(equipped);
                    data.setInitialized();
                }
            });
            WanderingTraderEvents.patchTraderAiGoals(trader);
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget().func_200600_R() != EntityType.field_220351_aK) {
            return;
        }
        WanderingTraderEntity trader = (WanderingTraderEntity)event.getTarget();
        PickpocketChallenge.get((LivingEntity)trader).ifPresent(data -> {
            if (data.isBackpackEquipped()) {
                Network.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new MessageSyncVillagerBackpack(event.getTarget().func_145782_y()));
            }
        });
    }

    @SubscribeEvent
    public void onTickLivingEntity(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (world.func_201670_d() || entity.func_200600_R() != EntityType.field_220351_aK) {
            return;
        }
        WanderingTraderEntity trader = (WanderingTraderEntity)entity;
        if (trader.func_213719_ec() > 0) {
            trader.func_213720_r(trader.func_213719_ec() - 1);
        }
        PickpocketChallenge.get(entity).ifPresent(data -> {
            if (!data.isBackpackEquipped()) {
                return;
            }
            Map<PlayerEntity, Long> detectedPlayers = data.getDetectedPlayers();
            List<PlayerEntity> newDetectedPlayers = this.findDetectedPlayers((LivingEntity)trader);
            newDetectedPlayers.forEach(player -> detectedPlayers.put((PlayerEntity)player, world.func_82737_E()));
            detectedPlayers.entrySet().removeIf(this.createForgetPlayerPredicate(trader, world));
            data.getDislikedPlayers().entrySet().removeIf(entry -> world.func_82737_E() - (Long)entry.getValue() > (long)((Integer)Config.COMMON.dislikeCooldown.get()).intValue());
        });
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (!entity.field_70170_p.func_201670_d() && entity instanceof WanderingTraderEntity) {
            WanderingTraderEntity trader = (WanderingTraderEntity)entity;
            if (!((Boolean)Config.COMMON.dislikedPlayersCanTrade.get()).booleanValue() && PickpocketChallenge.get((LivingEntity)trader).map(data -> data.isBackpackEquipped() && data.isDislikedPlayer(event.getPlayer())).orElse(false).booleanValue()) {
                trader.func_213720_r(20);
                trader.field_70170_p.func_217384_a(null, (Entity)trader, SoundEvents.field_187913_gm, SoundCategory.NEUTRAL, 1.0f, 1.5f);
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
            }
        }
    }

    private List<PlayerEntity> findDetectedPlayers(LivingEntity entity) {
        return entity.field_70170_p.func_217394_a(EntityType.field_200729_aH, entity.func_174813_aQ().func_186662_g(WanderingTraderEvents.getMaxDetectionDistance()), player -> WanderingTraderEvents.isPlayerInLivingEntityVision(entity, player) && WanderingTraderEvents.isPlayerSeenByLivingEntity(entity, player, (Double)Config.COMMON.wanderingTraderMaxDetectionDistance.get()) || !player.func_213453_ef() && WanderingTraderEvents.isPlayerMoving(player));
    }

    private Predicate<Map.Entry<PlayerEntity, Long>> createForgetPlayerPredicate(WanderingTraderEntity trader, World world) {
        return entry -> !((PlayerEntity)entry.getKey()).func_70089_S() || (double)((PlayerEntity)entry.getKey()).func_70032_d((Entity)trader) > (Double)Config.COMMON.wanderingTraderMaxDetectionDistance.get() * 2.0 || world.func_82737_E() - (Long)entry.getValue() > (Long)Config.COMMON.wanderingTraderForgetTime.get() && (double)((PlayerEntity)entry.getKey()).func_70032_d((Entity)trader) >= (Double)Config.COMMON.wanderingTraderMaxDetectionDistance.get();
    }

    private static boolean isPlayerInLivingEntityVision(LivingEntity entity, PlayerEntity player) {
        if (WanderingTraderEvents.isPlayerInvisible(player)) {
            return false;
        }
        Vector3d between = entity.func_213303_ch().func_178788_d(player.func_213303_ch());
        float angle = (float)Math.toDegrees(MathHelper.func_181159_b((double)between.field_72449_c, (double)between.field_72450_a)) - 90.0f;
        return MathHelper.func_203301_d((float)(entity.field_70759_as + 180.0f), (float)angle) <= 90.0f;
    }

    private static boolean isPlayerSeenByLivingEntity(LivingEntity entity, PlayerEntity player, double distance) {
        Vector3d playerEyePos;
        if (WanderingTraderEvents.isPlayerInvisible(player)) {
            return false;
        }
        if (entity.field_70170_p != player.field_70170_p || (double)entity.func_70032_d((Entity)player) > distance) {
            return false;
        }
        Vector3d livingEyePos = new Vector3d(entity.func_226277_ct_(), entity.func_226280_cw_(), entity.func_226281_cx_());
        if (WanderingTraderEvents.performRayTrace(livingEyePos, playerEyePos = new Vector3d(player.func_226277_ct_(), player.func_226280_cw_(), player.func_226281_cx_()), (Entity)entity).func_216346_c() == RayTraceResult.Type.MISS) {
            return true;
        }
        Vector3d playerLegPos = new Vector3d(player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_());
        return WanderingTraderEvents.performRayTrace(livingEyePos, playerLegPos, (Entity)entity).func_216346_c() == RayTraceResult.Type.MISS;
    }

    private static boolean isPlayerInvisible(PlayerEntity player) {
        return player.func_70644_a(Effects.field_76441_p) && player.func_213343_cS() <= 0.0f && StreamSupport.stream(player.func_184214_aD().spliterator(), false).allMatch(ItemStack::func_190926_b) && Backpacked.getBackpackStack(player).func_190926_b();
    }

    private static RayTraceResult performRayTrace(Vector3d start, Vector3d end, Entity source) {
        return source.field_70170_p.func_217299_a(new RayTraceContext(start, end, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, source));
    }

    private static boolean isPlayerMoving(PlayerEntity player) {
        return ((IMovedAccess)player).backpackedMoved();
    }

    public static void openBackpack(WanderingTraderEntity trader, ServerPlayerEntity openingPlayer) {
        PickpocketChallenge.get((LivingEntity)trader).ifPresent(data -> {
            if (!data.isBackpackEquipped()) {
                return;
            }
            if (data.getDetectedPlayers().containsKey(openingPlayer)) {
                trader.func_213720_r(20);
                trader.func_70671_ap().func_220674_a(openingPlayer.func_174824_e(1.0f));
                trader.field_70170_p.func_217384_a(null, (Entity)trader, SoundEvents.field_187913_gm, SoundCategory.NEUTRAL, 1.0f, 1.5f);
                trader.field_70170_p.func_217394_a(EntityType.field_220354_ax, trader.func_174813_aQ().func_186662_g(((Double)Config.COMMON.wanderingTraderMaxDetectionDistance.get()).doubleValue()), entity -> true).forEach(llama -> llama.func_70624_b((LivingEntity)openingPlayer));
                ((ServerWorld)trader.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197609_b, trader.func_226277_ct_(), trader.func_226280_cw_(), trader.func_226281_cx_(), 1, 0.0, 0.0, 0.0, 0.0);
                data.addDislikedPlayer((PlayerEntity)openingPlayer, trader.field_70170_p.func_82737_E());
                return;
            }
            if (WanderingTraderEvents.generateBackpackLoot(trader, data)) {
                UnlockTracker.get((PlayerEntity)openingPlayer).ifPresent(unlockTracker -> unlockTracker.getProgressTracker(WanderingBagBackpack.ID).ifPresent(tracker -> ((WanderingBagBackpack.PickpocketProgressTracker)tracker).addTrader(trader, openingPlayer)));
            }
            NetworkHooks.openGui((ServerPlayerEntity)openingPlayer, (INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInventory, entity1) -> new WanderingTraderContainer(id, entity1.field_71071_by, trader), (ITextComponent)WANDERING_BAG_TRANSLATION), buffer -> {
                buffer.func_150787_b(8);
                buffer.func_150787_b(1);
                buffer.writeBoolean(false);
            });
            openingPlayer.field_70170_p.func_184148_a((PlayerEntity)openingPlayer, trader.func_226277_ct_(), trader.func_226278_cu_() + 1.0, trader.func_226281_cx_(), SoundEvents.field_187728_s, SoundCategory.PLAYERS, 0.15f, 1.0f);
        });
    }

    private static boolean generateBackpackLoot(WanderingTraderEntity trader, PickpocketChallenge data) {
        if (!data.isLootSpawned()) {
            int size = trader.func_213715_ed().func_70302_i_();
            int reserved = size / 4;
            int count = trader.field_70170_p.field_73012_v.nextInt(Math.max(reserved, 1)) + (size - reserved);
            List randomSlotIndexes = IntStream.range(0, size).boxed().collect(Collectors.toCollection(ArrayList::new));
            Collections.shuffle(randomSlotIndexes);
            MerchantOffers offers = trader.func_213706_dY();
            for (int i = 0; i < size; ++i) {
                if (!((Boolean)Config.COMMON.generateEmeraldsOnly.get()).booleanValue() && i < count) {
                    MerchantOffer offer = (MerchantOffer)offers.get(trader.field_70170_p.field_73012_v.nextInt(offers.size()));
                    ItemStack loot = offer.func_222200_d().func_77946_l();
                    loot.func_190920_e(MathHelper.func_76125_a((int)(loot.func_190916_E() * (trader.field_70170_p.field_73012_v.nextInt((Integer)Config.COMMON.maxLootMultiplier.get()) + 1)), (int)0, (int)loot.func_77976_d()));
                    trader.func_213715_ed().func_70299_a(((Integer)randomSlotIndexes.get(i)).intValue(), loot);
                    continue;
                }
                ItemStack stack = new ItemStack((IItemProvider)Items.field_151166_bC, trader.field_70170_p.field_73012_v.nextInt((Integer)Config.COMMON.maxEmeraldStack.get()) + 1);
                trader.func_213715_ed().func_70299_a(((Integer)randomSlotIndexes.get(i)).intValue(), stack);
            }
            data.setLootSpawned();
            return true;
        }
        return false;
    }

    private static void patchTraderAiGoals(WanderingTraderEntity trader) {
        try {
            Set goals = (Set)goalsField.get(trader.field_70714_bg);
            if (goals != null) {
                goals.removeIf(goal -> goal.func_220772_j() instanceof LookAtWithoutMovingGoal);
            }
            trader.field_70714_bg.func_75776_a(2, (Goal)new LootAtDetectedPlayerGoal(trader));
            trader.field_70714_bg.func_75776_a(9, (Goal)new PickpocketLookAtWithoutMovingGoal((MobEntity)trader, PlayerEntity.class, 3.0f, 1.0f));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static double getMaxDetectionDistance() {
        return (Double)Config.COMMON.wanderingTraderMaxDetectionDistance.get();
    }

    private static class LootAtDetectedPlayerGoal
    extends LookAtGoal {
        private final WanderingTraderEntity trader;

        public LootAtDetectedPlayerGoal(WanderingTraderEntity trader) {
            super((MobEntity)trader, PlayerEntity.class, ((Double)Config.COMMON.wanderingTraderMaxDetectionDistance.get()).floatValue() * 2.0f, 1.0f);
            this.trader = trader;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            super.func_75250_a();
            if (this.trader.func_70643_av() == null && this.field_75334_a instanceof PlayerEntity) {
                PickpocketChallenge data = PickpocketChallenge.get((LivingEntity)this.trader).orElse(null);
                return data != null && data.isBackpackEquipped() && data.getDetectedPlayers().containsKey((PlayerEntity)this.field_75334_a);
            }
            return false;
        }

        public boolean func_75253_b() {
            if (this.field_75334_a instanceof PlayerEntity && (double)this.field_75334_a.func_70032_d((Entity)this.trader) <= (double)((Double)Config.COMMON.wanderingTraderMaxDetectionDistance.get()).floatValue() * 2.0) {
                PickpocketChallenge data = PickpocketChallenge.get((LivingEntity)this.trader).orElse(null);
                return data != null && data.getDetectedPlayers().containsKey((PlayerEntity)this.field_75334_a);
            }
            return false;
        }

        public void func_75249_e() {
            if (this.trader.field_70170_p instanceof ServerWorld && PickpocketChallenge.get((LivingEntity)this.trader).map(data -> data.isDislikedPlayer((PlayerEntity)this.field_75334_a)).orElse(false).booleanValue()) {
                ((ServerWorld)this.trader.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197609_b, this.trader.func_226277_ct_(), this.trader.func_226280_cw_(), this.trader.func_226281_cx_(), 1, 0.0, 0.0, 0.0, 0.0);
                this.trader.field_70170_p.func_217384_a(null, (Entity)this.trader, SoundEvents.field_187913_gm, SoundCategory.NEUTRAL, 1.0f, 1.5f);
            }
        }

        public void func_75246_d() {
            if (WanderingTraderEvents.isPlayerSeenByLivingEntity((LivingEntity)this.trader, (PlayerEntity)this.field_75334_a, (Double)Config.COMMON.wanderingTraderMaxDetectionDistance.get() * 2.0)) {
                this.trader.func_70671_ap().func_220679_a(this.field_75334_a.func_226277_ct_(), this.field_75334_a.func_226280_cw_(), this.field_75334_a.func_226281_cx_());
            }
        }
    }

    private static class PickpocketLookAtWithoutMovingGoal
    extends LookAtWithoutMovingGoal {
        public PickpocketLookAtWithoutMovingGoal(MobEntity entity, Class<? extends LivingEntity> entityClass, float distance, float probability) {
            super(entity, entityClass, distance, probability);
        }

        public boolean func_75250_a() {
            if (PickpocketChallenge.get((LivingEntity)this.field_75332_b).map(PickpocketChallenge::isBackpackEquipped).orElse(false).booleanValue()) {
                return false;
            }
            return super.func_75250_a();
        }
    }
}

