/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.tracker;

import com.mrcrayfish.backpacked.common.tracker.CraftingProgressTracker;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;

public class UniqueCraftingProgressTracker
extends CraftingProgressTracker {
    protected Set<ResourceLocation> craftedItems = new HashSet<ResourceLocation>();

    public UniqueCraftingProgressTracker(int totalCount, Predicate<ItemStack> predicate) {
        super(totalCount, predicate);
    }

    @Override
    public void processCrafted(ItemStack stack, ServerPlayerEntity player) {
        ResourceLocation id = stack.func_77973_b().getRegistryName();
        if (!this.craftedItems.contains(id) && this.predicate.test(stack)) {
            ++this.count;
            this.craftedItems.add(id);
            this.markForCompletionTest(player);
        }
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        this.craftedItems.clear();
        ListNBT list = tag.func_150295_c("CraftedItems", 8);
        list.forEach(inbt -> {
            ResourceLocation id = ResourceLocation.func_208304_a((String)inbt.func_150285_a_());
            if (id != null) {
                this.craftedItems.add(id);
            }
        });
    }

    @Override
    public void write(CompoundNBT tag) {
        super.write(tag);
        ListNBT list = new ListNBT();
        this.craftedItems.forEach(location -> list.add((Object)StringNBT.func_229705_a_((String)location.toString())));
        tag.func_218657_a("CraftedItems", (INBT)list);
    }
}

