/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.integration;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.item.BackpackItem;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.common.capability.CurioItemCapability;

public class Curios {
    public static ItemStack getBackStack(PlayerEntity player) {
        AtomicReference<ItemStack> back = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
        LazyOptional optional = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        optional.ifPresent(itemHandler -> {
            Optional stacksOptional = itemHandler.getStacksHandler(SlotTypePreset.BACK.getIdentifier());
            stacksOptional.ifPresent(stacksHandler -> {
                ItemStack stack = stacksHandler.getStacks().getStackInSlot(0);
                if (!stack.func_190926_b()) {
                    back.set(stack);
                }
            });
        });
        return back.get();
    }

    public static ItemStack getBackpackStack(PlayerEntity player) {
        AtomicReference<ItemStack> backpack = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
        LazyOptional optional = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        optional.ifPresent(itemHandler -> {
            Optional stacksOptional = itemHandler.getStacksHandler(SlotTypePreset.BACK.getIdentifier());
            stacksOptional.ifPresent(stacksHandler -> {
                ItemStack stack = stacksHandler.getStacks().getStackInSlot(0);
                if (stack.func_77973_b() instanceof BackpackItem) {
                    backpack.set(stack);
                }
            });
        });
        return backpack.get();
    }

    public static void setBackpackStack(PlayerEntity player, ItemStack stack) {
        LazyOptional optional = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        optional.ifPresent(itemHandler -> {
            Optional stacksOptional = itemHandler.getStacksHandler(SlotTypePreset.BACK.getIdentifier());
            stacksOptional.ifPresent(stacksHandler -> stacksHandler.getStacks().setStackInSlot(0, stack.func_77946_l()));
        });
    }

    public static boolean isBackpackVisible(PlayerEntity player) {
        AtomicReference<Boolean> visible = new AtomicReference<Boolean>(true);
        LazyOptional optional = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        optional.ifPresent(itemHandler -> {
            Optional stacksOptional = itemHandler.getStacksHandler(SlotTypePreset.BACK.getIdentifier());
            stacksOptional.ifPresent(stacksHandler -> visible.set((Boolean)stacksHandler.getRenders().get(0)));
        });
        return visible.get();
    }

    public static ICapabilityProvider createBackpackProvider(final ItemStack stack) {
        return CurioItemCapability.createProvider((ICurio)new ICurio(){

            @Nonnull
            public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
                return new ICurio.SoundInfo(SoundEvents.field_187728_s, 1.0f, 1.0f);
            }

            public boolean canEquipFromUse(SlotContext slotContext) {
                return true;
            }

            public boolean canUnequip(String identifier, LivingEntity livingEntity) {
                if (!((Boolean)Config.SERVER.lockBackpackIntoSlot.get()).booleanValue()) {
                    return true;
                }
                CompoundNBT tag = stack.func_77978_p();
                return tag == null || tag.func_150295_c("Items", 10).isEmpty();
            }

            @Nonnull
            public ICurio.DropRule getDropRule(LivingEntity livingEntity) {
                return (Boolean)Config.COMMON.keepBackpackOnDeath.get() != false ? ICurio.DropRule.ALWAYS_KEEP : ICurio.DropRule.DEFAULT;
            }
        });
    }
}

