/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.inventory;

import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.util.InventoryHelper;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class BackpackInventory
extends Inventory {
    private final PlayerEntity player;
    private final ItemStack stack;

    public BackpackInventory(int cols, int rows, PlayerEntity player, ItemStack stack) {
        super(rows * cols);
        this.player = player;
        this.stack = stack;
        this.loadBackpackContents(player);
    }

    private void loadBackpackContents(PlayerEntity player) {
        CompoundNBT compound = this.stack.func_196082_o();
        if (compound.func_150297_b("Items", 9)) {
            InventoryHelper.loadAllItems(compound.func_150295_c("Items", 10), this, player.field_70170_p, player.func_213303_ch());
        }
    }

    public ItemStack getBackpackStack() {
        return this.stack;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return Backpacked.getBackpackStack(this.player).equals(this.stack) && (this.player.equals((Object)player) || PickpocketUtil.canPickpocketEntity((LivingEntity)this.player, player, (Double)Config.SERVER.pickpocketMaxReachDistance.get() + 0.5));
    }

    public void func_70296_d() {
        super.func_70296_d();
        CompoundNBT compound = this.stack.func_196082_o();
        compound.func_218657_a("Items", (INBT)InventoryHelper.saveAllItems(new ListNBT(), this));
    }
}

