/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.network.play;

import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.Backpack;
import com.mrcrayfish.backpacked.common.BackpackManager;
import com.mrcrayfish.backpacked.common.BackpackModelProperty;
import com.mrcrayfish.backpacked.common.UnlockTracker;
import com.mrcrayfish.backpacked.common.WanderingTraderEvents;
import com.mrcrayfish.backpacked.inventory.ExtendedPlayerInventory;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageBackpackCosmetics;
import com.mrcrayfish.backpacked.network.message.MessageEntityBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenCustomisation;
import com.mrcrayfish.backpacked.network.message.MessageRequestCustomisation;
import com.mrcrayfish.backpacked.network.message.MessageUpdateBackpack;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.PacketDistributor;

public class ServerPlayHandler {
    public static void handleCustomiseBackpack(MessageBackpackCosmetics message, ServerPlayerEntity player) {
        ItemStack stack = Backpacked.getBackpackStack((PlayerEntity)player);
        if (!stack.func_190926_b()) {
            ResourceLocation id = message.getBackpackId();
            Backpack backpack = BackpackManager.instance().getBackpack(id);
            if (backpack == null) {
                return;
            }
            if (!backpack.isUnlocked((PlayerEntity)player) && !((Boolean)Config.SERVER.unlockAllBackpacks.get()).booleanValue()) {
                return;
            }
            CompoundNBT tag = stack.func_196082_o();
            tag.func_74778_a("BackpackModel", id.toString());
            tag.func_74757_a(BackpackModelProperty.SHOW_GLINT.getTagName(), message.isShowGlint());
            tag.func_74757_a(BackpackModelProperty.SHOW_WITH_ELYTRA.getTagName(), message.isShowWithElytra());
            tag.func_74757_a(BackpackModelProperty.SHOW_EFFECTS.getTagName(), message.isShowEffects());
            if (Backpacked.isCuriosLoaded()) {
                return;
            }
            if (player.field_71071_by instanceof ExtendedPlayerInventory) {
                Network.getPlayChannel().send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new MessageUpdateBackpack(player.func_145782_y(), stack));
            }
        }
    }

    public static void handleOpenBackpack(MessageOpenBackpack message, ServerPlayerEntity player) {
        BackpackItem.openBackpack(player, player);
    }

    public static void handleEntityBackpack(MessageEntityBackpack message, ServerPlayerEntity player) {
        if (!((Boolean)Config.SERVER.pickpocketBackpacks.get()).booleanValue()) {
            return;
        }
        Entity entity = player.field_70170_p.func_73045_a(message.getEntityId());
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!PickpocketUtil.canSeeBackpack(livingEntity, (PlayerEntity)player)) {
            return;
        }
        if (livingEntity instanceof ServerPlayerEntity) {
            ServerPlayerEntity otherPlayer = (ServerPlayerEntity)livingEntity;
            if (BackpackItem.openBackpack(otherPlayer, player)) {
                otherPlayer.func_146105_b((ITextComponent)new TranslationTextComponent("message.backpacked.player_opened"), true);
                player.field_70170_p.func_184148_a((PlayerEntity)player, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_() + 1.0, livingEntity.func_226281_cx_(), SoundEvents.field_187728_s, SoundCategory.PLAYERS, 0.75f, 1.0f);
            }
        } else if (livingEntity instanceof WanderingTraderEntity) {
            WanderingTraderEvents.openBackpack((WanderingTraderEntity)livingEntity, player);
        }
    }

    public static void handleRequestCustomisation(MessageRequestCustomisation message, ServerPlayerEntity player) {
        if (((Boolean)Config.SERVER.disableCustomisation.get()).booleanValue()) {
            return;
        }
        if (Backpacked.getBackpackStack((PlayerEntity)player).func_190926_b()) {
            return;
        }
        UnlockTracker.get((PlayerEntity)player).ifPresent(unlockTracker -> {
            HashMap<ResourceLocation, ITextComponent> map = new HashMap<ResourceLocation, ITextComponent>();
            for (Backpack backpack : BackpackManager.instance().getRegisteredBackpacks()) {
                if (unlockTracker.isUnlocked(backpack.getId())) continue;
                unlockTracker.getProgressTracker(backpack.getId()).ifPresent(progressTracker -> map.put(backpack.getId(), progressTracker.getDisplayComponent()));
            }
            Network.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageOpenCustomisation(map));
        });
    }
}

