/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.tileentity;

import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.block.ShelfBlock;
import com.mrcrayfish.backpacked.core.ModSounds;
import com.mrcrayfish.backpacked.core.ModTileEntities;
import com.mrcrayfish.backpacked.inventory.container.BackpackContainer;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.tileentity.IOptionalStorage;
import com.mrcrayfish.backpacked.util.InventoryHelper;
import com.mrcrayfish.backpacked.util.TileEntityUtil;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ShelfTileEntity
extends TileEntity
implements IOptionalStorage {
    private ItemStack backpack = ItemStack.field_190927_a;
    private Inventory inventory = null;
    private LazyOptional<IItemHandlerModifiable> itemHandler;

    public ShelfTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public ShelfTileEntity() {
        super((TileEntityType)ModTileEntities.SHELF.get());
    }

    @Override
    @Nullable
    public Inventory getInventory() {
        return this.inventory;
    }

    public ItemStack getBackpack() {
        return this.backpack;
    }

    public ItemStack getBackpackWithContents() {
        ItemStack stack = this.backpack.func_77946_l();
        if (!stack.func_190926_b()) {
            this.copyInventoryToStack(stack);
        }
        return stack;
    }

    public ActionResultType interact(PlayerEntity player) {
        if (player.func_213453_ef() || this.backpack.func_190926_b()) {
            ItemStack stack = Backpacked.getBackStack(player);
            if (!stack.func_190926_b() && !(stack.func_77973_b() instanceof BackpackItem)) {
                if (!this.backpack.func_190926_b()) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.backpacked.occupied_back_slot"), true);
                }
                return ActionResultType.FAIL;
            }
            ItemStack result = this.shelveBackpack(stack);
            Backpacked.setBackpackStack(player, result);
        } else if (player instanceof ServerPlayerEntity) {
            this.openBackpackInventory((ServerPlayerEntity)player);
        }
        return ActionResultType.SUCCESS;
    }

    public ItemStack shelveBackpack(ItemStack stack) {
        ItemStack shelvedBackpack = this.backpack.func_77946_l();
        this.copyInventoryToStack(shelvedBackpack);
        this.backpack = stack.func_77946_l();
        if (!this.backpack.func_190926_b() || !shelvedBackpack.func_190926_b()) {
            boolean removed = this.backpack.func_190926_b();
            this.updateInventory(false);
            TileEntityUtil.sendUpdatePacket(this);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, (SoundEvent)ModSounds.ITEM_BACKPACK_PLACE.get(), SoundCategory.BLOCKS, 1.0f, removed ? 0.75f : 1.0f);
            this.func_70296_d();
        }
        return shelvedBackpack;
    }

    private void openBackpackInventory(ServerPlayerEntity player) {
        this.getBackpackInventory().ifPresent(inventory -> this.getBackpackItem().ifPresent(backpackItem -> {
            TranslationTextComponent title = this.backpack.func_82837_s() ? this.backpack.func_200301_q() : BackpackItem.BACKPACK_TRANSLATION;
            int cols = backpackItem.getColumnCount();
            int rows = backpackItem.getRowCount();
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInventory, entity) -> new BackpackContainer(id, playerInventory, (IInventory)inventory, cols, rows, false), (ITextComponent)title), buffer -> {
                buffer.func_150787_b(cols);
                buffer.func_150787_b(rows);
                buffer.writeBoolean(false);
            });
        }));
    }

    private void copyInventoryToStack(ItemStack stack) {
        if (!stack.func_190926_b()) {
            this.getBackpackInventory().ifPresent(inventory -> stack.func_196082_o().func_218657_a("Items", (INBT)InventoryHelper.saveAllItems(new ListNBT(), inventory)));
        }
    }

    private Optional<Inventory> getBackpackInventory() {
        if (this.backpack.func_190926_b()) {
            return Optional.empty();
        }
        if (this.inventory != null && this.inventory.func_70302_i_() != this.getBackpackSize()) {
            this.updateInventory(true);
        }
        return Optional.ofNullable(this.inventory);
    }

    private void updateInventory(boolean resized) {
        if (!this.backpack.func_190926_b()) {
            Inventory oldInventory = this.inventory;
            this.inventory = new ShelfInventory(this.getBackpackSize());
            CompoundNBT compound = this.backpack.func_196082_o();
            this.loadBackpackItems(compound);
            compound.func_82580_o("Items");
            if (resized && oldInventory != null) {
                InventoryHelper.mergeInventory(oldInventory, this.inventory, this.field_145850_b, Vector3d.func_237489_a_((Vector3i)this.field_174879_c));
            }
        } else {
            this.inventory = null;
        }
    }

    private void loadBackpackItems(CompoundNBT compound) {
        if (compound.func_150297_b("Items", 9)) {
            InventoryHelper.loadAllItems(compound.func_150295_c("Items", 10), this.inventory, this.field_145850_b, Vector3d.func_237489_a_((Vector3i)this.field_174879_c));
        }
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)ShelfBlock.field_185512_D);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.backpack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Backpack"));
        this.inventory = this.backpack.func_190926_b() ? null : new ShelfInventory(this.getBackpackSize());
        this.loadBackpackItems(tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("Backpack", (INBT)this.backpack.func_77955_b(new CompoundNBT()));
        if (this.inventory != null) {
            ListNBT items = new ListNBT();
            InventoryHelper.saveAllItems(items, this.inventory);
            tag.func_218657_a("Items", (INBT)items);
        }
        return super.func_189515_b(tag);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(null, pkt.func_148857_g());
    }

    public void func_145836_u() {
        super.func_145836_u();
        if (this.itemHandler != null) {
            LazyOptional<IItemHandlerModifiable> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.itemHandler == null) {
                this.itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this));
            }
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return VoxelShapes.func_197868_b().func_197752_a().func_186662_g(0.5).func_186670_a(this.field_174879_c);
    }

    private Optional<BackpackItem> getBackpackItem() {
        if (this.backpack.func_77973_b() instanceof BackpackItem) {
            return Optional.of((BackpackItem)this.backpack.func_77973_b());
        }
        return Optional.empty();
    }

    private int getBackpackSize() {
        return this.getBackpackItem().map(item -> item.getRowCount() * item.getColumnCount()).orElse(0);
    }

    public class ShelfInventory
    extends Inventory {
        public ShelfInventory(int size) {
            super(size);
        }

        public void func_70296_d() {
            super.func_70296_d();
            ShelfTileEntity.this.func_70296_d();
        }

        public boolean func_70300_a(PlayerEntity player) {
            return ShelfTileEntity.this.inventory == this && !ShelfTileEntity.this.backpack.func_190926_b() && !ShelfTileEntity.this.field_145846_f;
        }
    }
}

