varying vec4 texcoord;
varying vec4 color;
varying vec4 lmcoord;

uniform float frameTimeCounter;
uniform vec3 cameraPosition;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

void main() {
	
	texcoord = gl_TextureMatrix[0] * gl_MultiTexCoord0;
	vec4 position = gl_ModelViewMatrix * gl_Vertex;
	
	position = gbufferModelViewInverse * position;
	vec3 worldpos = position.xyz;
	
	float PI = 3.14159265358979323846264;
	
	if (gl_Color.a != 0.8) {
					float y = position.y;
					float z = position.z;
					float om = -1*sin(((worldpos.z) / 256.0));
					position.y = z*sin(om)+y*cos(om);
					position.z = z*cos(om)+y*sin(om);
					}
	if (gl_Color.a != 0.8) {
					float y = position.y;
					float x = position.x;
					float om = -1*sin(((worldpos.x) / 256.0));
					position.y = x*sin(om)+y*cos(om);
					position.x = x*cos(om)+y*sin(om);
					}
	
	position = gbufferModelView * position;
	
	gl_Position = gl_ProjectionMatrix * position;
		
	color = gl_Color;
	
	texcoord = gl_TextureMatrix[0] * gl_MultiTexCoord0;

	lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;
	
	gl_FogFragCoord = gl_Position.z;
}