/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp;

import com.yogpc.qp.Config;
import com.yogpc.qp.ProxyCommon;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.gui.GuiAdvQuarryFluid;
import com.yogpc.qp.gui.GuiP_List;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.advquarry.AdvContentMessage;
import com.yogpc.qp.packet.advquarry.AdvFilterMessage;
import com.yogpc.qp.render.DummyBlockBakedModel;
import com.yogpc.qp.render.RenderAdvQuarry;
import com.yogpc.qp.render.RenderDistiller;
import com.yogpc.qp.render.RenderFiller;
import com.yogpc.qp.render.RenderLaser;
import com.yogpc.qp.render.RenderMarker;
import com.yogpc.qp.render.RenderQuarry;
import com.yogpc.qp.render.RenderQuarry2;
import com.yogpc.qp.render.Sprites;
import com.yogpc.qp.tile.TileAdvQuarry;
import com.yogpc.qp.tile.TileFiller;
import com.yogpc.qp.tile.TileLaser;
import com.yogpc.qp.tile.TileMarker;
import com.yogpc.qp.tile.TilePump;
import com.yogpc.qp.tile.TileQuarry;
import com.yogpc.qp.tile.TileQuarry2;
import com.yogpc.qp.tile.TileRefinery;
import com.yogpc.qp.version.VersionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@SideOnly(value=Side.CLIENT)
public class ProxyClient
extends ProxyCommon {
    private DummyBlockBakedModel dummyBlockBakedModel;
    private DummyBlockBakedModel dummyItemBakedModel;

    @Override
    public void openPumpGui(World worldIn, EntityPlayer playerIn, EnumFacing facing, TilePump pump2) {
        if (!worldIn.field_72995_K) {
            pump2.S_OpenGUI(facing, playerIn);
        } else {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiP_List(facing.ordinal(), pump2));
        }
    }

    @Override
    public void openAdvQuarryPumpGui(World worldIn, EntityPlayer player, TileAdvQuarry quarry, EnumFacing facing) {
        if (!worldIn.field_72995_K) {
            PacketHandler.sendToClient(AdvContentMessage.create(quarry), (EntityPlayerMP)player);
            PacketHandler.sendToClient(AdvFilterMessage.create(quarry), (EntityPlayerMP)player);
        } else {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiAdvQuarryFluid(quarry, player, facing));
        }
    }

    @Override
    public EntityPlayer getPacketPlayer(INetHandler inh) {
        if (inh instanceof NetHandlerPlayServer) {
            return ((NetHandlerPlayServer)inh).field_147369_b;
        }
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public World getPacketWorld(INetHandler inh) {
        if (inh instanceof NetHandlerPlayServer) {
            return ((NetHandlerPlayServer)inh).field_147369_b.func_130014_f_();
        }
        return this.getClientWorld();
    }

    @Override
    public void removeEntity(Entity e) {
        e.field_70170_p.func_72900_e(e);
        if (e.field_70170_p.field_72995_K) {
            ((WorldClient)e.field_70170_p).func_73028_b(e.func_145782_y());
        }
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public void registerTextures() {
        if (!Config.content().disableRendering()) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileQuarry.class, (TileEntitySpecialRenderer)RenderQuarry.instance());
            ClientRegistry.bindTileEntitySpecialRenderer(TileQuarry2.class, (TileEntitySpecialRenderer)RenderQuarry2.instance());
            ClientRegistry.bindTileEntitySpecialRenderer(TileMarker.class, (TileEntitySpecialRenderer)RenderMarker.instance());
            if (!Config.content().disableMapJ().get(TileAdvQuarry.SYMBOL()).booleanValue()) {
                ClientRegistry.bindTileEntitySpecialRenderer(TileAdvQuarry.class, (TileEntitySpecialRenderer)RenderAdvQuarry.instance());
            }
            if (!Config.content().disableMapJ().get(TileLaser.SYMBOL).booleanValue()) {
                ClientRegistry.bindTileEntitySpecialRenderer(TileLaser.class, (TileEntitySpecialRenderer)RenderLaser.instance());
            }
            if (!Config.content().disableMapJ().get(TileFiller.SYMBOL()).booleanValue()) {
                ClientRegistry.bindTileEntitySpecialRenderer(TileFiller.class, (TileEntitySpecialRenderer)RenderFiller.instance());
            }
            ClientRegistry.bindTileEntitySpecialRenderer(TileRefinery.class, (TileEntitySpecialRenderer)RenderDistiller.instance());
            MinecraftForge.EVENT_BUS.register((Object)Sprites.instance());
        }
    }

    @Override
    public ModelResourceLocation fromEntry(IForgeRegistryEntry<?> entry) {
        return new ModelResourceLocation(VersionUtil.getRegistryName(entry), "inventory");
    }

    @SubscribeEvent
    public void onBake(ModelBakeEvent event) {
        String itemTexName = Config.content().dummyBlockTextureName().split("#")[0];
        IBakedModel blockModel = this.getModel(event.getModelManager(), new ModelResourceLocation(Config.content().dummyBlockTextureName()));
        IBakedModel itemModel = this.getModel(event.getModelManager(), new ModelResourceLocation(itemTexName, "inventory"));
        this.dummyBlockBakedModel = new DummyBlockBakedModel(blockModel);
        this.dummyItemBakedModel = new DummyBlockBakedModel(itemModel);
        String pathIn = VersionUtil.getRegistryName(QuarryPlusI.dummyBlock()).toString();
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(pathIn), (Object)this.dummyBlockBakedModel);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(pathIn, "inventory"), (Object)this.dummyItemBakedModel);
    }

    @Override
    public void setDummyTexture(String textureName) {
        String itemTexName = textureName.split("#")[0];
        ModelManager manager = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a();
        this.dummyBlockBakedModel.model = this.getModel(manager, new ModelResourceLocation(textureName));
        this.dummyItemBakedModel.model = this.getModel(manager, new ModelResourceLocation(itemTexName, "inventory"));
    }

    private IBakedModel getModel(ModelManager manager, ModelResourceLocation location) {
        return manager.func_174953_a(new ModelResourceLocation("minecraft:glass", location.func_177518_c()));
    }
}

